/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.util.getopt;

import com.OooOO0OO;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.getopt.BadParametersException;
import org.benf.cfr.reader.util.getopt.GetOptSinkFactory;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.getopt.PermittedOptionProvider;

public class GetOptParser {
    private static final String argPrefix = OooOO0OO.OooOOoo0oo("1212");

    public static String getHelp(PermittedOptionProvider permittedOptionProvider) {
        StringBuilder sb = new StringBuilder();
        for (String flag : permittedOptionProvider.getFlags()) {
            sb.append(OooOO0OO.OooOOoo0oo("1F1F1F1212")).append(flag).append("\n");
        }
        int max = 10;
        for (PermittedOptionProvider.ArgumentParam<?, ?> param : permittedOptionProvider.getArguments()) {
            int len = param.getName().length();
            max = len > max ? len : max;
        }
        max += 4;
        List<PermittedOptionProvider.ArgumentParam<?, ?>> args = permittedOptionProvider.getArguments();
        Collections.sort(args, new Comparator<PermittedOptionProvider.ArgumentParam<?, ?>>(){

            @Override
            public int compare(PermittedOptionProvider.ArgumentParam<?, ?> a1, PermittedOptionProvider.ArgumentParam<?, ?> a2) {
                if (a1.getName().equals(OooOO0OO.OooOOoo0oo("575A534F"))) {
                    return 1;
                }
                if (a2.getName().equals(OooOO0OO.OooOOoo0oo("575A534F"))) {
                    return -1;
                }
                return a1.getName().compareTo(a2.getName());
            }
        });
        for (PermittedOptionProvider.ArgumentParam<?, ?> param : args) {
            if (param.isHidden()) continue;
            String name = param.getName();
            int pad = max - name.length();
            sb.append(OooOO0OO.OooOOoo0oo("1F1F1F1212")).append(param.getName());
            for (int x = 0; x < pad; ++x) {
                sb.append(' ');
            }
            sb.append(param.shortDescribe()).append("\n");
        }
        return sb.toString();
    }

    private static Map<String, OptData> buildOptTypeMap(PermittedOptionProvider optionProvider) {
        Map<String, OptData> optTypeMap = MapFactory.newMap();
        for (String string : optionProvider.getFlags()) {
            optTypeMap.put(string, new OptData(string));
        }
        for (PermittedOptionProvider.ArgumentParam argumentParam : optionProvider.getArguments()) {
            optTypeMap.put(argumentParam.getName(), new OptData(argumentParam));
        }
        return optTypeMap;
    }

    public <T> Pair<List<String>, T> parse(String[] args, GetOptSinkFactory<T> getOptSinkFactory) {
        Pair<List<String>, Map<String, String>> processed = this.process(args, getOptSinkFactory);
        List<String> positional = processed.getFirst();
        Map<String, String> named = processed.getSecond();
        if (positional.isEmpty() && named.containsKey(OptionsImpl.HELP.getName())) {
            positional.add(OooOO0OO.OooOOoo0oo("565851504D5A725A115C535E4C4C"));
        }
        T res = getOptSinkFactory.create(named);
        if (positional.size() == 0) {
            throw new IllegalArgumentException(OooOO0OO.OooOOoo0oo("76514C4A5959565C565A514B1F4A514E4A5E535659565A5B1F4F5E4D5E525A4B5A4D4C1F121F4F4D5049565B5A1F5E4B1F535A5E4C4B1F5956535A515E525A11"));
        }
        return Pair.make(positional, res);
    }

    private static void printErrHeader() {
        System.err.println(OooOO0OO.OooOOoo0oo("7C796D1F0F600E0C0D35"));
    }

    private static void printUsage() {
        System.err.println(OooOO0OO.OooOOoo0oo("555E495E1F1212555E4D1F5C594D600F600E0C0D11555E4D1F5C535E4C4C60504D60555E4D605956535A1F64525A4B57505B621F64504F4B5650514C6235"));
    }

    public <T> void showHelp(PermittedOptionProvider permittedOptionProvider, Exception e) {
        GetOptParser.printErrHeader();
        GetOptParser.printUsage();
        System.err.println(OooOO0OO.OooOOoo0oo("6F5E4D5E525A4B5A4D1F5A4D4D504D1F051F") + e.getMessage() + "\n");
        System.err.println(OooOO0OO.OooOOoo0oo("6F535A5E4C5A1F4C4F5A5C5659461F181212575A534F181F4B501F585A4B1F504F4B5650511F53564C4B131F504D1F181212575A534F1F504F4B565051515E525A181F59504D1F4C4F5A5C5659565C4C131F5A58351F1F1F1212575A534F1F") + OptionsImpl.PULL_CODE_CASE.getName());
    }

    public <T> void showOptionHelp(PermittedOptionProvider permittedOptionProvider, Options options, PermittedOptionProvider.ArgumentParam<String, Void> helpArg) {
        GetOptParser.printErrHeader();
        String relevantOption = options.getOption(helpArg);
        List<PermittedOptionProvider.ArgumentParam<?, ?>> possible = permittedOptionProvider.getArguments();
        for (PermittedOptionProvider.ArgumentParam<?, ?> opt : possible) {
            if (!opt.getName().equals(relevantOption)) continue;
            System.err.println(opt.describe());
            return;
        }
        System.err.println(GetOptParser.getHelp(permittedOptionProvider));
        if (relevantOption.equals("")) {
            System.err.println(OooOO0OO.OooOOoo0oo("6F535A5E4C5A1F4C4F5A5C5659461F181212575A534F1F504F4B565051515E525A181F59504D1F4C4F5A5C5659565C4C131F5A58351F1F1F1212575A534F1F") + OptionsImpl.PULL_CODE_CASE.getName());
        } else {
            System.err.println(OooOO0OO.OooOOoo0oo("71501F4C4A5C571F5E4D584A525A514B1F18") + relevantOption + OooOO0OO.OooOOoo0oo("18"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pair<List<String>, Map<String, String>> process(String[] in, PermittedOptionProvider optionProvider) {
        Map<String, OptData> optTypeMap = GetOptParser.buildOptTypeMap(optionProvider);
        Map<String, String> res = MapFactory.newMap();
        List positional = ListFactory.newList();
        OptionsImpl optionsSample = new OptionsImpl(res);
        int x = 0;
        while (true) {
            block8: {
                block6: {
                    String value;
                    OptData optData;
                    String name;
                    block11: {
                        block9: {
                            block10: {
                                String next;
                                block7: {
                                    if (x >= in.length) {
                                        return Pair.make(positional, res);
                                    }
                                    if (!in[x].startsWith(argPrefix)) break block6;
                                    name = in[x].substring(2);
                                    optData = optTypeMap.get(name);
                                    if (optData == null) {
                                        throw new IllegalArgumentException(OooOO0OO.OooOOoo0oo("6A5154515048511F5E4D584A525A514B1F") + name);
                                    }
                                    if (!optData.isFlag()) break block7;
                                    res.put(name, null);
                                    break block8;
                                }
                                String string = next = x >= in.length - 1 ? argPrefix : in[x + 1];
                                if (!next.startsWith(argPrefix)) break block9;
                                if (!name.equals(OptionsImpl.HELP.getName())) break block10;
                                value = "";
                                break block11;
                            }
                            value = optData.getArgument().getFn().getDefaultValue();
                            if (value == null) {
                                throw new BadParametersException(OooOO0OO.OooOOoo0oo("6D5A4E4A564D5A4C1F5E4D584A525A514B"), optData.getArgument());
                            }
                            break block8;
                        }
                        value = in[++x];
                    }
                    res.put(name, value);
                    try {
                        optData.getArgument().getFn().invoke(res.get(name), null, optionsSample);
                    }
                    catch (Exception e) {
                        throw new BadParametersException(e.toString(), optData.getArgument());
                    }
                }
                positional.add(in[x]);
            }
            ++x;
        }
    }

    private static class OptData {
        private final boolean isFlag;
        private final String name;
        private final PermittedOptionProvider.ArgumentParam<?, ?> argument;

        private OptData(String name) {
            this.name = name;
            this.isFlag = true;
            this.argument = null;
        }

        private OptData(PermittedOptionProvider.ArgumentParam<?, ?> argument) {
            this.argument = argument;
            this.isFlag = false;
            this.name = argument.getName();
        }

        public boolean isFlag() {
            return this.isFlag;
        }

        public String getName() {
            return this.name;
        }

        public PermittedOptionProvider.ArgumentParam<?, ?> getArgument() {
            return this.argument;
        }
    }
}

