/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.entities.exceptions;

import com.OooOO0OO;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.entities.constantpool.ConstantPool;
import org.benf.cfr.reader.util.ConfusedCFRException;
import org.benf.cfr.reader.util.bytestream.ByteData;
import org.benf.cfr.reader.util.functors.UnaryFunction;

public class ExceptionTableEntry
implements Comparable<ExceptionTableEntry> {
    private static final int OFFSET_INDEX_FROM = 0;
    private static final int OFFSET_INDEX_TO = 2;
    private static final int OFFSET_INDEX_HANDLER = 4;
    private static final int OFFSET_CATCH_TYPE = 6;
    private final int bytecode_index_from;
    private final int bytecode_index_to;
    private final int bytecode_index_handler;
    private final int catch_type;
    private final int priority;

    public ExceptionTableEntry(ByteData raw, int priority) {
        this(raw.getU2At(0L), raw.getU2At(2L), raw.getU2At(4L), raw.getU2At(6L), priority);
    }

    public ExceptionTableEntry(int from, int to, int handler, int catchType, int priority) {
        this.bytecode_index_from = from;
        this.bytecode_index_to = to;
        this.bytecode_index_handler = handler;
        this.catch_type = catchType;
        this.priority = priority;
        if (to < from) {
            throw new IllegalStateException(OooOO0OO.OooOOoo0oo("725E5359504D525A5B1F5A475C5A4F4B5650511F5D53505C54131F4B501F031F594D5052"));
        }
    }

    public ExceptionTableEntry withThrowableCatchType() {
        return new ExceptionTableEntry(this.bytecode_index_from, this.bytecode_index_to, this.bytecode_index_handler, 0, this.priority);
    }

    public JavaRefTypeInstance getCatchType(ConstantPool cp) {
        if (this.catch_type == 0) {
            return cp.getClassCache().getRefClassFor(OooOO0OO.OooOOoo0oo("555E495E11535E5158116B574D50485E5D535A"));
        }
        return (JavaRefTypeInstance)cp.getClassEntry(this.catch_type).getTypeInstance();
    }

    public ExceptionTableEntry copyWithRange(int from, int to) {
        return new ExceptionTableEntry(from, to, this.bytecode_index_handler, this.catch_type, this.priority);
    }

    public int getBytecodeIndexFrom() {
        return this.bytecode_index_from;
    }

    public int getBytecodeIndexTo() {
        return this.bytecode_index_to;
    }

    public int getBytecodeIndexHandler() {
        return this.bytecode_index_handler;
    }

    public int getCatchType() {
        return this.catch_type;
    }

    public int getPriority() {
        return this.priority;
    }

    public ExceptionTableEntry aggregateWith(ExceptionTableEntry later) {
        if (this.bytecode_index_from >= later.bytecode_index_from || this.bytecode_index_to != later.bytecode_index_from) {
            throw new ConfusedCFRException(OooOO0OO.OooOOoo0oo("7C5E51184B1F5E58584D5A585E4B5A1F5A475C5A4F4B5650516B5E5D535A7A514B4D565A4C"));
        }
        return new ExceptionTableEntry(this.bytecode_index_from, later.bytecode_index_to, this.bytecode_index_handler, this.catch_type, this.priority);
    }

    public ExceptionTableEntry aggregateWithLenient(ExceptionTableEntry later) {
        if (this.bytecode_index_from >= later.bytecode_index_from) {
            throw new ConfusedCFRException(OooOO0OO.OooOOoo0oo("7C5E51184B1F5E58584D5A585E4B5A1F5A475C5A4F4B5650516B5E5D535A7A514B4D565A4C"));
        }
        return new ExceptionTableEntry(this.bytecode_index_from, later.bytecode_index_to, this.bytecode_index_handler, this.catch_type, this.priority);
    }

    public static UnaryFunction<ByteData, ExceptionTableEntry> getBuilder(ConstantPool cp) {
        return new ExceptionTableEntryBuilder(cp);
    }

    @Override
    public int compareTo(ExceptionTableEntry other) {
        int res = this.bytecode_index_from - other.bytecode_index_from;
        if (res != 0) {
            return res;
        }
        res = this.bytecode_index_to - other.bytecode_index_to;
        if (res != 0) {
            return 0 - res;
        }
        res = this.bytecode_index_handler - other.bytecode_index_handler;
        return res;
    }

    public String toString() {
        return OooOO0OO.OooOOoo0oo("7A475C5A4F4B5650516B5E5D535A7A514B4D461F") + this.priority + OooOO0OO.OooOOoo0oo("1F051F64") + this.bytecode_index_from + OooOO0OO.OooOOoo0oo("1201") + this.bytecode_index_to + OooOO0OO.OooOOoo0oo("161F051F") + this.bytecode_index_handler;
    }

    private static class ExceptionTableEntryBuilder
    implements UnaryFunction<ByteData, ExceptionTableEntry> {
        int idx = 0;

        public ExceptionTableEntryBuilder(ConstantPool cp) {
        }

        @Override
        public ExceptionTableEntry invoke(ByteData arg) {
            return new ExceptionTableEntry(arg, this.idx++);
        }
    }
}

