/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.entities.constantpool;

import com.OooOO0OO;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.types.ClassNameUtils;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.StackType;
import org.benf.cfr.reader.entities.AbstractConstantPoolEntry;
import org.benf.cfr.reader.entities.constantpool.ConstantPool;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryLiteral;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolUtils;
import org.benf.cfr.reader.util.bytestream.ByteData;
import org.benf.cfr.reader.util.output.Dumper;

public class ConstantPoolEntryClass
extends AbstractConstantPoolEntry
implements ConstantPoolEntryLiteral {
    private static final long OFFSET_OF_NAME_INDEX = 1L;
    final int nameIndex;
    transient JavaTypeInstance javaTypeInstance = null;

    public ConstantPoolEntryClass(ConstantPool cp, ByteData data) {
        super(cp);
        this.nameIndex = data.getU2At(1L);
    }

    @Override
    public long getRawByteLength() {
        return 3L;
    }

    public String toString() {
        return OooOO0OO.OooOOoo0oo("7C70716C6B7E716B607C535E4C4C1F") + this.nameIndex;
    }

    public String getTextPath() {
        return ClassNameUtils.convertFromPath(this.getCp().getUTF8Entry(this.nameIndex).getValue()) + OooOO0OO.OooOOoo0oo("115C535E4C4C");
    }

    public String getFilePath() {
        return this.getCp().getUTF8Entry(this.nameIndex).getValue() + OooOO0OO.OooOOoo0oo("115C535E4C4C");
    }

    @Override
    public void dump(Dumper d) {
        d.print(OooOO0OO.OooOOoo0oo("7C535E4C4C1F") + this.getCp().getUTF8Entry(this.nameIndex).getValue());
    }

    public String getPackageName() {
        String full = ClassNameUtils.convertFromPath(this.getCp().getUTF8Entry(this.nameIndex).getValue());
        int idx = full.lastIndexOf(46);
        if (idx == -1) {
            return "";
        }
        return full.substring(0, idx);
    }

    public JavaTypeInstance convertFromString(String rawType) {
        if (rawType.startsWith(OooOO0OO.OooOOoo0oo("64"))) {
            return ConstantPoolUtils.decodeTypeTok(rawType, this.getCp());
        }
        return this.getCp().getClassCache().getRefClassFor(ClassNameUtils.convertFromPath(rawType));
    }

    public JavaTypeInstance getTypeInstance() {
        if (this.javaTypeInstance == null) {
            String rawType = this.getCp().getUTF8Entry(this.nameIndex).getValue();
            this.javaTypeInstance = this.convertFromString(rawType);
        }
        return this.javaTypeInstance;
    }

    public JavaTypeInstance getTypeInstanceKnownOuter(ConstantPoolEntryClass outer) {
        if (this.javaTypeInstance != null) {
            return this.javaTypeInstance;
        }
        String thisInnerType = this.getCp().getUTF8Entry(this.nameIndex).getValue();
        String thisOuterType = this.getCp().getUTF8Entry(outer.nameIndex).getValue();
        Pair<JavaRefTypeInstance, JavaRefTypeInstance> pair = this.getCp().getClassCache().getRefClassForInnerOuterPair(thisInnerType, thisOuterType);
        this.javaTypeInstance = pair.getFirst();
        return this.javaTypeInstance;
    }

    public JavaTypeInstance getTypeInstanceKnownInner(ConstantPoolEntryClass inner) {
        if (this.javaTypeInstance != null) {
            return this.javaTypeInstance;
        }
        String thisInnerType = this.getCp().getUTF8Entry(inner.nameIndex).getValue();
        String thisOuterType = this.getCp().getUTF8Entry(this.nameIndex).getValue();
        Pair<JavaRefTypeInstance, JavaRefTypeInstance> pair = this.getCp().getClassCache().getRefClassForInnerOuterPair(thisInnerType, thisOuterType);
        this.javaTypeInstance = pair.getSecond();
        return this.javaTypeInstance;
    }

    @Override
    public StackType getStackType() {
        return StackType.REF;
    }
}

