/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.entities.constantpool;

import com.OooOO0OO;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.benf.cfr.reader.entities.AbstractConstantPoolEntry;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntry;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryDouble;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryFieldRef;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryFloat;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryInteger;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryInvokeDynamic;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryLong;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryMethodHandle;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryMethodRef;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryMethodType;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryNameAndType;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryString;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryUTF8;
import org.benf.cfr.reader.state.ClassCache;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.util.ConfusedCFRException;
import org.benf.cfr.reader.util.bytestream.ByteData;
import org.benf.cfr.reader.util.bytestream.OffsettingByteData;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.output.LoggerFactory;

public class ConstantPool {
    private static final Logger logger = LoggerFactory.create(ConstantPool.class);
    private final long length;
    private final List<ConstantPoolEntry> entries;
    private final Options options;
    private final DCCommonState dcCommonState;
    private final ClassCache classCache;
    private final ClassFile classFile;
    private String comparisonKey;
    private boolean isLoaded = false;
    private final int idx = sidx++;
    private static int sidx = 0;

    public ConstantPool(ClassFile classFile, DCCommonState dcCommonState, ByteData raw, int count) {
        this.classFile = classFile;
        this.options = dcCommonState.getOptions();
        ArrayList<ConstantPoolEntry> res = new ArrayList<ConstantPoolEntry>();
        res.ensureCapacity(--count);
        this.length = this.processRaw(raw, count, res);
        this.entries = res;
        this.dcCommonState = dcCommonState;
        this.classCache = dcCommonState.getClassCache();
        this.isLoaded = true;
    }

    public DCCommonState getDCCommonState() {
        return this.dcCommonState;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    private long processRaw(ByteData raw, int count, List<ConstantPoolEntry> tgt) {
        OffsettingByteData data = raw.getOffsettingOffsetData(0L);
        logger.info(OooOO0OO.OooOOoo0oo("6F4D505C5A4C4C5651581F") + count + OooOO0OO.OooOOoo0oo("1F5C50514C4B4F5050531F5A514B4D565A4C11"));
        for (int x = 0; x < count; ++x) {
            AbstractConstantPoolEntry cpe;
            ConstantPoolEntry.Type type = ConstantPoolEntry.Type.get(data.getS1At(0L));
            switch (type) {
                case CPT_NameAndType: {
                    cpe = new ConstantPoolEntryNameAndType(this, data);
                    break;
                }
                case CPT_String: {
                    cpe = new ConstantPoolEntryString(this, data);
                    break;
                }
                case CPT_FieldRef: {
                    cpe = new ConstantPoolEntryFieldRef(this, data);
                    break;
                }
                case CPT_MethodRef: {
                    cpe = new ConstantPoolEntryMethodRef(this, data, false);
                    break;
                }
                case CPT_InterfaceMethodRef: {
                    cpe = new ConstantPoolEntryMethodRef(this, data, true);
                    break;
                }
                case CPT_Class: {
                    cpe = new ConstantPoolEntryClass(this, data);
                    break;
                }
                case CPT_Double: {
                    cpe = new ConstantPoolEntryDouble(this, data);
                    break;
                }
                case CPT_Float: {
                    cpe = new ConstantPoolEntryFloat(this, data);
                    break;
                }
                case CPT_Long: {
                    cpe = new ConstantPoolEntryLong(this, data);
                    break;
                }
                case CPT_Integer: {
                    cpe = new ConstantPoolEntryInteger(this, data);
                    break;
                }
                case CPT_UTF8: {
                    cpe = new ConstantPoolEntryUTF8(this, data, this.options);
                    break;
                }
                case CPT_MethodHandle: {
                    cpe = new ConstantPoolEntryMethodHandle(this, data);
                    break;
                }
                case CPT_MethodType: {
                    cpe = new ConstantPoolEntryMethodType(this, data);
                    break;
                }
                case CPT_InvokeDynamic: {
                    cpe = new ConstantPoolEntryInvokeDynamic(this, data);
                    break;
                }
                default: {
                    throw new ConfusedCFRException(OooOO0OO.OooOOoo0oo("7651495E53565B1F5C50514C4B5E514B1F4F5050531F5A514B4D461F051F") + (Object)((Object)type));
                }
            }
            logger.info("" + (x + 1) + OooOO0OO.OooOOoo0oo("1F051F") + cpe);
            tgt.add(cpe);
            switch (type) {
                case CPT_Double: 
                case CPT_Long: {
                    tgt.add(null);
                    ++x;
                }
            }
            long size = cpe.getRawByteLength();
            data.advance(size);
        }
        return data.getOffset();
    }

    public long getRawByteLength() {
        return this.length;
    }

    public ConstantPoolEntry getEntry(int index) {
        if (index == 0) {
            throw new ConfusedCFRException(OooOO0OO.OooOOoo0oo("7E4B4B5A524F4B1F4B501F595A4B5C571F5A535A525A514B1F0F1F594D50521F5C50514C4B5E514B1F4F505053"));
        }
        if (index > this.entries.size()) {
            throw new IndexOutOfBoundsException(OooOO0OO.OooOOoo0oo("7C50514C4B5E514B1F4F5050531F575E4C1F") + this.entries.size() + OooOO0OO.OooOOoo0oo("1F5A514B4D565A4C1F121F5E4B4B5A524F4B5A5B1F4B501F5E5C5C5A4C4C1F5A514B4D461F1C") + (index - 1));
        }
        return this.entries.get(index - 1);
    }

    public ConstantPoolEntryUTF8 getUTF8Entry(int index) {
        return (ConstantPoolEntryUTF8)this.getEntry(index);
    }

    public ConstantPoolEntryNameAndType getNameAndTypeEntry(int index) {
        return (ConstantPoolEntryNameAndType)this.getEntry(index);
    }

    public ConstantPoolEntryMethodHandle getMethodHandleEntry(int index) {
        return (ConstantPoolEntryMethodHandle)this.getEntry(index);
    }

    public ConstantPoolEntryMethodRef getMethodRefEntry(int index) {
        return (ConstantPoolEntryMethodRef)this.getEntry(index);
    }

    public ConstantPoolEntryClass getClassEntry(int index) {
        return (ConstantPoolEntryClass)this.getEntry(index);
    }

    public ClassCache getClassCache() {
        return this.classCache;
    }

    public boolean equals(Object o) {
        this.getComparisonKey();
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantPool that = (ConstantPool)o;
        return this.comparisonKey.equals(that.comparisonKey);
    }

    public String toString() {
        return this.getComparisonKey() + OooOO0OO.OooOOoo0oo("64") + this.idx + OooOO0OO.OooOOoo0oo("62");
    }

    public int hashCode() {
        return this.getComparisonKey().hashCode();
    }

    private String getComparisonKey() {
        if (this.comparisonKey == null) {
            this.comparisonKey = this.classFile.getFilePath();
        }
        return this.comparisonKey;
    }
}

