/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.entities.classfilehelpers;

import com.OooOO0OO;
import java.util.List;
import org.benf.cfr.reader.bytecode.analysis.types.ClassSignature;
import org.benf.cfr.reader.entities.AccessFlag;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.ClassFileField;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper;
import org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumper;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.util.output.Dumper;

public class ClassFileDumperAnnotation
extends AbstractClassFileDumper {
    private static final AccessFlag[] dumpableAccessFlagsInterface = new AccessFlag[]{AccessFlag.ACC_PUBLIC, AccessFlag.ACC_PRIVATE, AccessFlag.ACC_PROTECTED, AccessFlag.ACC_STATIC, AccessFlag.ACC_FINAL};

    public ClassFileDumperAnnotation(DCCommonState dcCommonState) {
        super(dcCommonState);
    }

    private void dumpHeader(ClassFile c, ClassFileDumper.InnerClassDumpType innerClassDumpType, Dumper d) {
        d.print(ClassFileDumperAnnotation.getAccessFlagsString(c.getAccessFlags(), dumpableAccessFlagsInterface));
        ClassSignature signature = c.getClassSignature();
        d.print(OooOO0OO.OooOOoo0oo("7F56514B5A4D595E5C5A1F")).dump(c.getThisClassConstpoolEntry().getTypeInstance());
        ClassFileDumperAnnotation.getFormalParametersText(signature, d);
        d.print("\n");
        d.removePendingCarriageReturn().print(" ");
    }

    @Override
    public Dumper dump(ClassFile classFile, ClassFileDumper.InnerClassDumpType innerClass, Dumper d) {
        if (!innerClass.isInnerClass()) {
            this.dumpTopHeader(classFile, d);
            this.dumpImports(d, classFile);
        }
        boolean first = true;
        this.dumpAnnotations(classFile, d);
        this.dumpHeader(classFile, innerClass, d);
        d.print(OooOO0OO.OooOOoo0oo("4435"));
        d.indent(1);
        List<ClassFileField> fields = classFile.getFields();
        for (ClassFileField field : fields) {
            field.dump(d);
            first = false;
        }
        List<Method> methods = classFile.getMethods();
        if (!methods.isEmpty()) {
            for (Method meth : methods) {
                if (!first) {
                    d.newln();
                }
                first = false;
                meth.dump(d, false);
            }
        }
        classFile.dumpNamedInnerClasses(d);
        d.indent(-1);
        d.print(OooOO0OO.OooOOoo0oo("4235"));
        return d;
    }

    @Override
    public void collectTypeUsages(TypeUsageCollector collector) {
    }
}

