/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.entities;

import com.OooOO0OO;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.MethodPrototype;
import org.benf.cfr.reader.bytecode.analysis.types.MethodPrototypeAnnotationsHelper;
import org.benf.cfr.reader.bytecode.analysis.variables.Ident;
import org.benf.cfr.reader.bytecode.analysis.variables.VariableNamer;
import org.benf.cfr.reader.bytecode.analysis.variables.VariableNamerFactory;
import org.benf.cfr.reader.entities.AccessFlag;
import org.benf.cfr.reader.entities.AccessFlagMethod;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.attributes.Attribute;
import org.benf.cfr.reader.entities.attributes.AttributeAnnotationDefault;
import org.benf.cfr.reader.entities.attributes.AttributeCode;
import org.benf.cfr.reader.entities.attributes.AttributeExceptions;
import org.benf.cfr.reader.entities.attributes.AttributeLocalVariableTable;
import org.benf.cfr.reader.entities.attributes.AttributeRuntimeInvisibleAnnotations;
import org.benf.cfr.reader.entities.attributes.AttributeRuntimeInvisibleParameterAnnotations;
import org.benf.cfr.reader.entities.attributes.AttributeRuntimeVisibleAnnotations;
import org.benf.cfr.reader.entities.attributes.AttributeRuntimeVisibleParameterAnnotations;
import org.benf.cfr.reader.entities.attributes.AttributeSignature;
import org.benf.cfr.reader.entities.constantpool.ConstantPool;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryUTF8;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolUtils;
import org.benf.cfr.reader.entityfactories.AttributeFactory;
import org.benf.cfr.reader.entityfactories.ContiguousEntityFactory;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.state.LocalClassAwareTypeUsageInformation;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.util.ClassFileVersion;
import org.benf.cfr.reader.util.CollectionUtils;
import org.benf.cfr.reader.util.ConfusedCFRException;
import org.benf.cfr.reader.util.DecompilerComment;
import org.benf.cfr.reader.util.DecompilerComments;
import org.benf.cfr.reader.util.KnowsRawSize;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.SetFactory;
import org.benf.cfr.reader.util.StringUtils;
import org.benf.cfr.reader.util.TypeUsageCollectable;
import org.benf.cfr.reader.util.bytestream.ByteData;
import org.benf.cfr.reader.util.functors.UnaryFunction;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.output.Dumper;
import org.benf.cfr.reader.util.output.TypeOverridingDumper;

public class Method
implements KnowsRawSize,
TypeUsageCollectable {
    private static final long OFFSET_OF_ACCESS_FLAGS = 0L;
    private static final long OFFSET_OF_NAME_INDEX = 2L;
    private static final long OFFSET_OF_DESCRIPTOR_INDEX = 4L;
    private static final long OFFSET_OF_ATTRIBUTES_COUNT = 6L;
    private static final long OFFSET_OF_ATTRIBUTES = 8L;
    private final long length;
    private final EnumSet<AccessFlagMethod> accessFlags;
    private final Map<String, Attribute> attributes;
    private final MethodConstructor isConstructor;
    private final int descriptorIndex;
    private final AttributeCode codeAttribute;
    private final ConstantPool cp;
    private final VariableNamer variableNamer;
    private final MethodPrototype methodPrototype;
    private final ClassFile classFile;
    private Visibility hidden;
    private DecompilerComments comments;
    private final Map<JavaRefTypeInstance, String> localClasses = MapFactory.newOrderedMap();
    private boolean isOverride;
    private transient Set<JavaTypeInstance> thrownTypes = null;

    public Method(ByteData raw, ClassFile classFile, ConstantPool cp, DCCommonState dcCommonState, ClassFileVersion classFileVersion) {
        Attribute codeAttribute;
        Options options = dcCommonState.getOptions();
        this.cp = cp;
        this.classFile = classFile;
        this.accessFlags = AccessFlagMethod.build(raw.getU2At(0L));
        this.descriptorIndex = raw.getU2At(4L);
        this.hidden = Visibility.Visible;
        int nameIndex = raw.getU2At(2L);
        String initialName = cp.getUTF8Entry(nameIndex).getValue();
        int numAttributes = raw.getU2At(6L);
        ArrayList tmpAttributes = new ArrayList();
        tmpAttributes.ensureCapacity(numAttributes);
        long attributesLength = ContiguousEntityFactory.build(raw.getOffsetData(8L), numAttributes, tmpAttributes, AttributeFactory.getBuilder(cp, classFileVersion));
        this.attributes = ContiguousEntityFactory.addToMap(new HashMap(), tmpAttributes);
        AccessFlagMethod.applyAttributes(this.attributes, this.accessFlags);
        this.length = 8L + attributesLength;
        MethodConstructor methodConstructor = MethodConstructor.NOT;
        if (initialName.equals(OooOO0OO.OooOOoo0oo("035651564B01"))) {
            boolean isEnum = classFile.getAccessFlags().contains((Object)AccessFlag.ACC_ENUM);
            methodConstructor = isEnum ? MethodConstructor.ENUM_CONSTRUCTOR : MethodConstructor.CONSTRUCTOR;
        } else if (initialName.equals(OooOO0OO.OooOOoo0oo("035C535651564B01"))) {
            methodConstructor = MethodConstructor.STATIC_CONSTRUCTOR;
        }
        this.isConstructor = methodConstructor;
        if (this.isConstructor() && this.accessFlags.contains((Object)AccessFlagMethod.ACC_STRICT)) {
            this.accessFlags.remove((Object)AccessFlagMethod.ACC_STRICT);
            classFile.getAccessFlags().add(AccessFlag.ACC_STRICT);
        }
        if ((codeAttribute = this.attributes.get(OooOO0OO.OooOOoo0oo("7C505B5A"))) == null) {
            this.variableNamer = VariableNamerFactory.getNamer(null, cp);
            this.codeAttribute = null;
        } else {
            this.codeAttribute = (AttributeCode)codeAttribute;
            AttributeLocalVariableTable variableTable = (Boolean)options.getOption(OptionsImpl.USE_NAME_TABLE) != false ? this.codeAttribute.getLocalVariableTable() : null;
            this.variableNamer = VariableNamerFactory.getNamer(variableTable, cp);
            this.codeAttribute.setMethod(this);
        }
        this.methodPrototype = this.generateMethodPrototype(initialName);
        if (this.accessFlags.contains((Object)AccessFlagMethod.ACC_BRIDGE) && !this.accessFlags.contains((Object)AccessFlagMethod.ACC_STATIC) && ((Boolean)options.getOption(OptionsImpl.HIDE_BRIDGE_METHODS)).booleanValue()) {
            this.hidden = Visibility.HiddenBridge;
        }
    }

    @Override
    public void collectTypeUsages(TypeUsageCollector collector) {
        this.methodPrototype.collectTypeUsages(collector);
        collector.collectFrom((TypeUsageCollectable)this.getAttributeByName(OooOO0OO.OooOOoo0oo("6D4A514B56525A69564C565D535A7E5151504B5E4B5650514C")));
        collector.collectFrom((TypeUsageCollectable)this.getAttributeByName(OooOO0OO.OooOOoo0oo("6D4A514B56525A765149564C565D535A7E5151504B5E4B5650514C")));
        collector.collectFrom((TypeUsageCollectable)this.getAttributeByName(OooOO0OO.OooOOoo0oo("6D4A514B56525A69564C565D535A6F5E4D5E525A4B5A4D7E5151504B5E4B5650514C")));
        collector.collectFrom((TypeUsageCollectable)this.getAttributeByName(OooOO0OO.OooOOoo0oo("6D4A514B56525A765149564C565D535A6F5E4D5E525A4B5A4D7E5151504B5E4B5650514C")));
        collector.collectFrom((TypeUsageCollectable)this.getAttributeByName(OooOO0OO.OooOOoo0oo("7E5151504B5E4B5650517B5A595E4A534B")));
        if (this.codeAttribute != null) {
            this.codeAttribute.collectTypeUsages(collector);
            this.codeAttribute.analyse().collectTypeUsages(collector);
        }
        collector.collect(this.localClasses.keySet());
        collector.collectFrom((TypeUsageCollectable)this.getAttributeByName(OooOO0OO.OooOOoo0oo("7A475C5A4F4B5650514C")));
    }

    public Set<AccessFlagMethod> getAccessFlags() {
        return this.accessFlags;
    }

    public void hideSynthetic() {
        this.hidden = Visibility.HiddenSynthetic;
    }

    public Visibility hiddenState() {
        return this.hidden;
    }

    public boolean testAccessFlag(AccessFlagMethod flag) {
        return this.accessFlags.contains((Object)flag);
    }

    public MethodConstructor getConstructorFlag() {
        return this.isConstructor;
    }

    AttributeSignature getSignatureAttribute() {
        return (AttributeSignature)this.getAttributeByName(OooOO0OO.OooOOoo0oo("6C5658515E4B4A4D5A"));
    }

    private <T extends Attribute> T getAttributeByName(String name) {
        Attribute attribute = this.attributes.get(name);
        if (attribute == null) {
            return null;
        }
        Attribute tmp = attribute;
        return (T)tmp;
    }

    public VariableNamer getVariableNamer() {
        return this.variableNamer;
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    @Override
    public long getRawByteLength() {
        return this.length;
    }

    public String getName() {
        return this.methodPrototype.getName();
    }

    private MethodPrototype generateMethodPrototype(String initialName) {
        MethodPrototype descriptorProto;
        AttributeSignature sig = this.getSignatureAttribute();
        ConstantPoolEntryUTF8 signature = sig == null ? null : sig.getSignature();
        ConstantPoolEntryUTF8 descriptor = this.cp.getUTF8Entry(this.descriptorIndex);
        ConstantPoolEntryUTF8 prototype = null;
        prototype = signature == null ? descriptor : signature;
        boolean isInstance = !this.accessFlags.contains((Object)AccessFlagMethod.ACC_STATIC);
        boolean isVarargs = this.accessFlags.contains((Object)AccessFlagMethod.ACC_VARARGS);
        boolean isSynthetic = this.accessFlags.contains((Object)AccessFlagMethod.ACC_SYNTHETIC);
        MethodPrototype res = ConstantPoolUtils.parseJavaMethodPrototype(this.classFile, this.classFile.getClassType(), initialName, isInstance, this.getConstructorFlag(), prototype, this.cp, isVarargs, isSynthetic, this.variableNamer);
        if (this.classFile.isInnerClass() && signature != null && (descriptorProto = ConstantPoolUtils.parseJavaMethodPrototype(this.classFile, this.classFile.getClassType(), initialName, isInstance, this.getConstructorFlag(), descriptor, this.cp, isVarargs, isSynthetic, this.variableNamer)).getArgs().size() != res.getArgs().size()) {
            res = Method.fixupInnerClassSignature(descriptorProto, res);
        }
        return res;
    }

    private static MethodPrototype fixupInnerClassSignature(MethodPrototype descriptor, MethodPrototype signature) {
        List<JavaTypeInstance> descriptorArgs = descriptor.getArgs();
        List<JavaTypeInstance> signatureArgs = signature.getArgs();
        if (signatureArgs.size() != descriptorArgs.size() - 1) {
            signature.setDescriptorProto(descriptor);
            return signature;
        }
        for (int x = 0; x < signatureArgs.size(); ++x) {
            if (descriptorArgs.get(x + 1).equals(signatureArgs.get(x).getDeGenerifiedType())) continue;
            return signature;
        }
        signatureArgs.add(0, descriptorArgs.get(0));
        return signature;
    }

    public MethodPrototype getMethodPrototype() {
        return this.methodPrototype;
    }

    public void markOverride() {
        this.isOverride = true;
    }

    public void markUsedLocalClassType(JavaTypeInstance javaTypeInstance, String suggestedName) {
        if (!((javaTypeInstance = javaTypeInstance.getDeGenerifiedType()) instanceof JavaRefTypeInstance)) {
            throw new IllegalStateException(OooOO0OO.OooOOoo0oo("7D5E5B1F53505C5E531F5C535E4C4C1F6B464F5A1F") + javaTypeInstance.getRawName());
        }
        this.localClasses.put((JavaRefTypeInstance)javaTypeInstance, suggestedName);
    }

    public void markUsedLocalClassType(JavaTypeInstance javaTypeInstance) {
        this.markUsedLocalClassType(javaTypeInstance, null);
    }

    private void dumpMethodAnnotations(Dumper d) {
        AttributeRuntimeVisibleAnnotations runtimeVisibleAnnotations = (AttributeRuntimeVisibleAnnotations)this.getAttributeByName(OooOO0OO.OooOOoo0oo("6D4A514B56525A69564C565D535A7E5151504B5E4B5650514C"));
        AttributeRuntimeInvisibleAnnotations runtimeInvisibleAnnotations = (AttributeRuntimeInvisibleAnnotations)this.getAttributeByName(OooOO0OO.OooOOoo0oo("6D4A514B56525A765149564C565D535A7E5151504B5E4B5650514C"));
        if (runtimeVisibleAnnotations != null) {
            runtimeVisibleAnnotations.dump(d);
        }
        if (runtimeInvisibleAnnotations != null) {
            runtimeInvisibleAnnotations.dump(d);
        }
        if (this.isOverride) {
            d.print(OooOO0OO.OooOOoo0oo("7F70495A4D4D565B5A35"));
        }
    }

    public Set<JavaTypeInstance> getThrownTypes() {
        if (this.thrownTypes == null) {
            this.thrownTypes = SetFactory.newOrderedSet();
            AttributeExceptions exceptionsAttribute = (AttributeExceptions)this.getAttributeByName(OooOO0OO.OooOOoo0oo("7A475C5A4F4B5650514C"));
            if (exceptionsAttribute != null) {
                List<ConstantPoolEntryClass> exceptionClasses = exceptionsAttribute.getExceptionClassList();
                for (ConstantPoolEntryClass exceptionClass : exceptionClasses) {
                    JavaTypeInstance typeInstance = exceptionClass.getTypeInstance();
                    this.thrownTypes.add(typeInstance);
                }
            }
        }
        return this.thrownTypes;
    }

    private void dumpSignatureText(boolean asClass, Dumper d) {
        String prefix;
        this.dumpMethodAnnotations(d);
        EnumSet<AccessFlagMethod> localAccessFlags = this.accessFlags;
        if (!asClass) {
            if (this.codeAttribute != null && !this.accessFlags.contains((Object)AccessFlagMethod.ACC_STATIC) && !this.accessFlags.contains((Object)AccessFlagMethod.ACC_PRIVATE)) {
                d.print(OooOO0OO.OooOOoo0oo("5B5A595E4A534B1F"));
            }
            localAccessFlags = SetFactory.newSet(localAccessFlags);
            localAccessFlags.remove((Object)AccessFlagMethod.ACC_ABSTRACT);
        }
        if (!(prefix = CollectionUtils.join(localAccessFlags, " ")).isEmpty()) {
            d.print(prefix);
        }
        if (this.isConstructor == MethodConstructor.STATIC_CONSTRUCTOR) {
            return;
        }
        if (!prefix.isEmpty()) {
            d.print(' ');
        }
        MethodPrototypeAnnotationsHelper paramAnnotationsHelper = new MethodPrototypeAnnotationsHelper((AttributeRuntimeVisibleParameterAnnotations)this.getAttributeByName(OooOO0OO.OooOOoo0oo("6D4A514B56525A69564C565D535A6F5E4D5E525A4B5A4D7E5151504B5E4B5650514C")), (AttributeRuntimeInvisibleParameterAnnotations)this.getAttributeByName(OooOO0OO.OooOOoo0oo("6D4A514B56525A765149564C565D535A6F5E4D5E525A4B5A4D7E5151504B5E4B5650514C")));
        String displayName = this.isConstructor.isConstructor() ? d.getTypeUsageInformation().getName(this.classFile.getClassType()) : this.methodPrototype.getFixedName();
        this.getMethodPrototype().dumpDeclarationSignature(d, displayName, this.isConstructor, paramAnnotationsHelper);
        AttributeExceptions exceptionsAttribute = (AttributeExceptions)this.getAttributeByName(OooOO0OO.OooOOoo0oo("7A475C5A4F4B5650514C"));
        if (exceptionsAttribute != null) {
            d.print(OooOO0OO.OooOOoo0oo("1F4B574D50484C1F"));
            boolean first = true;
            for (JavaTypeInstance typeInstance : this.getThrownTypes()) {
                first = StringUtils.comma(first, d);
                d.dump(typeInstance);
            }
        }
    }

    public Op04StructuredStatement getAnalysis() {
        if (this.codeAttribute == null) {
            throw new ConfusedCFRException(OooOO0OO.OooOOoo0oo("71501F5C505B5A1F56511F4B57564C1F525A4B57505B1F4B501F5E515E5346455A"));
        }
        Op04StructuredStatement analysis = this.codeAttribute.analyse();
        return analysis;
    }

    public boolean isConstructor() {
        return this.isConstructor.isConstructor();
    }

    void analyse() {
        try {
            if (this.codeAttribute != null) {
                this.codeAttribute.analyse();
            }
            if (!this.methodPrototype.parametersComputed()) {
                Map<Integer, Ident> identMap = MapFactory.newLazyMap(new UnaryFunction<Integer, Ident>(){
                    public int x = 0;

                    @Override
                    public Ident invoke(Integer arg) {
                        return new Ident(arg, 0);
                    }
                });
                this.methodPrototype.computeParameters(this.getConstructorFlag(), identMap);
            }
        }
        catch (RuntimeException e) {
            System.out.println(OooOO0OO.OooOOoo0oo("685756535A1F4F4D505C5A4C4C5651581F525A4B57505B1F051F") + this.getName());
            throw e;
        }
    }

    public boolean hasCodeAttribute() {
        return this.codeAttribute != null;
    }

    public AttributeCode getCodeAttribute() {
        return this.codeAttribute;
    }

    private void dumpComments(Dumper d) {
        if (this.comments != null) {
            this.comments.dump(d);
            for (DecompilerComment decompilerComment : this.comments.getCommentCollection()) {
                String string = decompilerComment.getSummaryMessage();
                if (string == null) continue;
                d.addSummaryError(this, string);
            }
        }
    }

    public void setComments(DecompilerComments comments) {
        this.comments = comments;
    }

    private boolean isInnerVisibleTo(JavaTypeInstance maybeCaller) {
        JavaRefTypeInstance thisClass = this.getClassFile().getRefClasstype();
        if (maybeCaller.getInnerClassHereInfo().isTransitiveInnerClassOf(thisClass)) {
            return true;
        }
        return thisClass.getInnerClassHereInfo().isTransitiveInnerClassOf(maybeCaller);
    }

    public boolean isVisibleTo(JavaRefTypeInstance maybeCaller) {
        if (this.accessFlags.contains((Object)AccessFlagMethod.ACC_PUBLIC)) {
            return true;
        }
        if (maybeCaller.equals(this.getClassFile().getClassType())) {
            return true;
        }
        if (this.accessFlags.contains((Object)AccessFlagMethod.ACC_PRIVATE)) {
            return this.isInnerVisibleTo(maybeCaller);
        }
        if (this.accessFlags.contains((Object)AccessFlagMethod.ACC_PROTECTED)) {
            BindingSuperContainer bindingSuperContainer = maybeCaller.getBindingSupers();
            if (bindingSuperContainer == null) {
                return false;
            }
            if (bindingSuperContainer.containsBase(this.getClassFile().getClassType())) {
                return true;
            }
            return this.isInnerVisibleTo(maybeCaller);
        }
        return maybeCaller.getPackageName().equals(this.getClassFile().getRefClasstype().getPackageName());
    }

    public void dump(Dumper d, boolean asClass) {
        if (this.codeAttribute != null) {
            this.codeAttribute.analyse();
        }
        this.dumpComments(d);
        this.dumpSignatureText(asClass, d);
        if (this.codeAttribute == null) {
            AttributeAnnotationDefault annotationDefault = (AttributeAnnotationDefault)this.getAttributeByName(OooOO0OO.OooOOoo0oo("7E5151504B5E4B5650517B5A595E4A534B"));
            if (annotationDefault != null) {
                JavaTypeInstance resultType = this.methodPrototype.getReturnType();
                d.print(OooOO0OO.OooOOoo0oo("1F5B5A595E4A534B1F")).dump(annotationDefault.getElementValue().withTypeHint(resultType));
            }
            d.endCodeln();
        } else {
            if (!this.localClasses.isEmpty()) {
                LocalClassAwareTypeUsageInformation overrides = new LocalClassAwareTypeUsageInformation(this.localClasses, d.getTypeUsageInformation());
                d = new TypeOverridingDumper(d, overrides);
            }
            d.print(' ').dump(this.codeAttribute);
        }
    }

    public String toString() {
        return this.getName() + OooOO0OO.OooOOoo0oo("051F") + this.methodPrototype;
    }

    public static enum Visibility {
        Visible,
        HiddenSynthetic,
        HiddenBridge;

    }

    public static enum MethodConstructor {
        NOT(false),
        STATIC_CONSTRUCTOR(false),
        CONSTRUCTOR(true),
        ENUM_CONSTRUCTOR(true);

        private final boolean isConstructor;

        private MethodConstructor(boolean isConstructor) {
            this.isConstructor = isConstructor;
        }

        public boolean isConstructor() {
            return this.isConstructor;
        }
    }
}

