/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.types;

import com.OooOO0OO;
import java.util.Map;
import java.util.Set;
import org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer;
import org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder;
import org.benf.cfr.reader.bytecode.analysis.types.InnerClassInfo;
import org.benf.cfr.reader.bytecode.analysis.types.JavaAnnotatedTypeIterator;
import org.benf.cfr.reader.bytecode.analysis.types.JavaGenericPlaceholderTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.StackType;
import org.benf.cfr.reader.bytecode.analysis.types.TypeConstants;
import org.benf.cfr.reader.bytecode.analysis.types.annotated.JavaAnnotatedTypeInstance;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.state.TypeUsageInformation;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.SetFactory;
import org.benf.cfr.reader.util.output.Dumper;

public enum RawJavaType implements JavaTypeInstance
{
    BOOLEAN(OooOO0OO.OooOOoo0oo("5D5050535A5E51"), OooOO0OO.OooOOoo0oo("5D53"), StackType.INT, true, OooOO0OO.OooOOoo0oo("555E495E11535E5158117D5050535A5E51"), false, false),
    BYTE(OooOO0OO.OooOOoo0oo("5D464B5A"), OooOO0OO.OooOOoo0oo("5D46"), StackType.INT, true, OooOO0OO.OooOOoo0oo("555E495E11535E5158117D464B5A"), true, false),
    CHAR(OooOO0OO.OooOOoo0oo("5C575E4D"), OooOO0OO.OooOOoo0oo("5C"), StackType.INT, true, OooOO0OO.OooOOoo0oo("555E495E11535E5158117C575E4D5E5C4B5A4D"), false, false),
    SHORT(OooOO0OO.OooOOoo0oo("4C57504D4B"), OooOO0OO.OooOOoo0oo("4C"), StackType.INT, true, OooOO0OO.OooOOoo0oo("555E495E11535E5158116C57504D4B"), true, false),
    INT(OooOO0OO.OooOOoo0oo("56514B"), OooOO0OO.OooOOoo0oo("51"), StackType.INT, true, OooOO0OO.OooOOoo0oo("555E495E11535E51581176514B5A585A4D"), true, false),
    LONG(OooOO0OO.OooOOoo0oo("53505158"), OooOO0OO.OooOOoo0oo("53"), StackType.LONG, true, OooOO0OO.OooOOoo0oo("555E495E11535E51581173505158"), true, false),
    FLOAT(OooOO0OO.OooOOoo0oo("5953505E4B"), OooOO0OO.OooOOoo0oo("59"), StackType.FLOAT, true, OooOO0OO.OooOOoo0oo("555E495E11535E5158117953505E4B"), true, false),
    DOUBLE(OooOO0OO.OooOOoo0oo("5B504A5D535A"), OooOO0OO.OooOOoo0oo("5B"), StackType.DOUBLE, true, OooOO0OO.OooOOoo0oo("555E495E11535E5158117B504A5D535A"), true, false),
    VOID(OooOO0OO.OooOOoo0oo("4950565B"), null, StackType.VOID, false, false),
    REF(OooOO0OO.OooOOoo0oo("4D5A595A4D5A515C5A"), null, StackType.REF, false, true),
    RETURNADDRESS(OooOO0OO.OooOOoo0oo("4D5A4B4A4D515E5B5B4D5A4C4C"), null, StackType.RETURNADDRESS, false, true),
    RETURNADDRESSORREF(OooOO0OO.OooOOoo0oo("4D5A4B4A4D515E5B5B4D5A4C4C1F504D1F4D5A59"), null, StackType.RETURNADDRESSORREF, false, true),
    NULL(OooOO0OO.OooOOoo0oo("514A5353"), null, StackType.REF, false, true);

    private final String name;
    private final String suggestedVarName;
    private final StackType stackType;
    private final boolean usableType;
    private final String boxedName;
    private final boolean isNumber;
    private final boolean isObject;
    private static final Map<RawJavaType, Set<RawJavaType>> implicitCasts;
    private static final Map<String, RawJavaType> boxingTypes;

    public static RawJavaType getUnboxedTypeFor(JavaTypeInstance type) {
        String rawName = type.getRawName();
        RawJavaType tgt = boxingTypes.get(rawName);
        return tgt;
    }

    private RawJavaType(String name, String suggestedVarName, StackType stackType, boolean usableType, String boxedName, boolean isNumber, boolean objectType) {
        this.name = name;
        this.stackType = stackType;
        this.usableType = usableType;
        this.boxedName = boxedName;
        this.suggestedVarName = suggestedVarName;
        this.isNumber = isNumber;
        this.isObject = objectType;
    }

    private RawJavaType(String name, String suggestedVarName, StackType stackType, boolean usableType, boolean objectType) {
        this(name, suggestedVarName, stackType, usableType, null, false, objectType);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public JavaAnnotatedTypeInstance getAnnotatedInstance() {
        return new Annotated();
    }

    @Override
    public StackType getStackType() {
        return this.stackType;
    }

    @Override
    public boolean isComplexType() {
        return false;
    }

    @Override
    public boolean isObject() {
        return this.isObject;
    }

    public int compareTypePriorityTo(RawJavaType other) {
        if (this.stackType != StackType.INT) {
            throw new IllegalArgumentException();
        }
        if (other.stackType != StackType.INT) {
            throw new IllegalArgumentException();
        }
        return this.ordinal() - other.ordinal();
    }

    public int compareAllPriorityTo(RawJavaType other) {
        return this.ordinal() - other.ordinal();
    }

    @Override
    public boolean isUsableType() {
        return this.usableType;
    }

    @Override
    public RawJavaType getRawTypeOfSimpleType() {
        return this;
    }

    @Override
    public JavaTypeInstance removeAnArrayIndirection() {
        return VOID;
    }

    @Override
    public JavaTypeInstance getArrayStrippedType() {
        return this;
    }

    @Override
    public JavaTypeInstance getDeGenerifiedType() {
        return this;
    }

    @Override
    public int getNumArrayDimensions() {
        return 0;
    }

    @Override
    public String getRawName() {
        return this.name;
    }

    @Override
    public InnerClassInfo getInnerClassHereInfo() {
        return InnerClassInfo.NOT;
    }

    @Override
    public BindingSuperContainer getBindingSupers() {
        return null;
    }

    private boolean implicitlyCastsTo(RawJavaType other) {
        if (other == this) {
            return true;
        }
        Set<RawJavaType> tgt = implicitCasts.get(this);
        if (tgt == null) {
            return false;
        }
        return tgt.contains(other);
    }

    @Override
    public boolean implicitlyCastsTo(JavaTypeInstance other, GenericTypeBinder gtb) {
        if (other instanceof RawJavaType) {
            return this.implicitlyCastsTo((RawJavaType)other);
        }
        if (this == NULL) {
            return true;
        }
        if (this == REF) {
            return true;
        }
        if (other instanceof JavaGenericPlaceholderTypeInstance) {
            return true;
        }
        if (other instanceof JavaRefTypeInstance) {
            if (other == TypeConstants.OBJECT) {
                return true;
            }
            RawJavaType tgt = RawJavaType.getUnboxedTypeFor((JavaRefTypeInstance)other);
            if (tgt == null) {
                if (other.getRawName().equals(OooOO0OO.OooOOoo0oo("555E495E11535E515811714A525D5A4D"))) {
                    return this.isNumber;
                }
                return false;
            }
            return this.equals(tgt);
        }
        return false;
    }

    @Override
    public boolean impreciseCanCastTo(JavaTypeInstance other, GenericTypeBinder gtb) {
        if (this.boxedName != null && other instanceof JavaRefTypeInstance) {
            RawJavaType tgt = RawJavaType.getUnboxedTypeFor((JavaRefTypeInstance)other);
            if (tgt == null) {
                if (other == TypeConstants.OBJECT) {
                    return true;
                }
                if (other.getRawName().equals(OooOO0OO.OooOOoo0oo("555E495E11535E515811714A525D5A4D"))) {
                    return this.isNumber;
                }
                return false;
            }
            return this.implicitlyCastsTo(tgt) || tgt.implicitlyCastsTo(this);
        }
        return true;
    }

    @Override
    public boolean correctCanCastTo(JavaTypeInstance other, GenericTypeBinder gtb) {
        return this.impreciseCanCastTo(other, gtb);
    }

    @Override
    public String suggestVarName() {
        return this.suggestedVarName;
    }

    @Override
    public void dumpInto(Dumper d, TypeUsageInformation typeUsageInformation) {
        if (this == NULL) {
            TypeConstants.OBJECT.dumpInto(d, typeUsageInformation);
            return;
        }
        d.print(this.toString());
    }

    @Override
    public void collectInto(TypeUsageCollector typeUsageCollector) {
    }

    public String toString() {
        return this.name;
    }

    static {
        implicitCasts = MapFactory.newMap();
        boxingTypes = MapFactory.newMap();
        implicitCasts.put(FLOAT, SetFactory.newSet(DOUBLE));
        implicitCasts.put(LONG, SetFactory.newSet(FLOAT, DOUBLE));
        implicitCasts.put(INT, SetFactory.newSet(LONG, FLOAT, DOUBLE));
        implicitCasts.put(CHAR, SetFactory.newSet(INT, LONG, FLOAT, DOUBLE));
        implicitCasts.put(SHORT, SetFactory.newSet(INT, LONG, FLOAT, DOUBLE));
        implicitCasts.put(BYTE, SetFactory.newSet(SHORT, INT, LONG, FLOAT, DOUBLE));
        for (RawJavaType type : RawJavaType.values()) {
            if (type.boxedName == null) continue;
            boxingTypes.put(type.boxedName, type);
        }
    }

    private class Annotated
    implements JavaAnnotatedTypeInstance {
        private Annotated() {
        }

        @Override
        public JavaAnnotatedTypeIterator pathIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Dumper dump(Dumper d) {
            return d;
        }
    }
}

