/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.structured.statement;

import com.OooOO0OO;
import java.util.List;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.MatchIterator;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.MatchResultCollector;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.StructuredStatementTransformer;
import org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriter;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.BlockIdentifier;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.scope.LValueScopeDiscoverer;
import org.benf.cfr.reader.bytecode.analysis.structured.StructuredScope;
import org.benf.cfr.reader.bytecode.analysis.structured.StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.AbstractStructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.Block;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFinally;
import org.benf.cfr.reader.entities.exceptions.ExceptionGroup;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.output.Dumper;

public class StructuredTry
extends AbstractStructuredStatement {
    private final ExceptionGroup exceptionGroup;
    private Op04StructuredStatement tryBlock;
    private List<Op04StructuredStatement> catchBlocks = ListFactory.newList();
    private Op04StructuredStatement finallyBlock;
    private final BlockIdentifier tryBlockIdentifier;
    private List<Op04StructuredStatement> resourceBlock;

    public StructuredTry(ExceptionGroup exceptionGroup, Op04StructuredStatement tryBlock, BlockIdentifier tryBlockIdentifier) {
        this.exceptionGroup = exceptionGroup;
        this.tryBlock = tryBlock;
        this.finallyBlock = null;
        this.tryBlockIdentifier = tryBlockIdentifier;
        this.resourceBlock = null;
    }

    public void addResources(List<Op04StructuredStatement> resources) {
        if (this.resourceBlock == null) {
            this.resourceBlock = ListFactory.newList();
        }
        this.resourceBlock.addAll(resources);
    }

    public List<Op04StructuredStatement> getResources() {
        return this.resourceBlock;
    }

    public boolean hasResources() {
        return this.resourceBlock != null;
    }

    public List<Op04StructuredStatement> getCatchBlocks() {
        return this.catchBlocks;
    }

    public void clearCatchBlocks() {
        this.catchBlocks.clear();
    }

    @Override
    public Dumper dump(Dumper dumper) {
        dumper.print(OooOO0OO.OooOOoo0oo("4B4D461F"));
        if (this.resourceBlock != null) {
            dumper.print(OooOO0OO.OooOOoo0oo("17"));
            boolean first = true;
            for (Op04StructuredStatement resource : this.resourceBlock) {
                if (!first) {
                    dumper.print("     ");
                }
                resource.dump(dumper);
                first = false;
            }
            dumper.removePendingCarriageReturn();
            dumper.print(OooOO0OO.OooOOoo0oo("16"));
        }
        this.tryBlock.dump(dumper);
        for (Op04StructuredStatement catchBlock : this.catchBlocks) {
            catchBlock.dump(dumper);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.dump(dumper);
        }
        return dumper;
    }

    @Override
    public void collectTypeUsages(TypeUsageCollector collector) {
        collector.collectFrom(this.tryBlock);
        collector.collectFrom(this.catchBlocks);
        collector.collectFrom(this.finallyBlock);
        collector.collectFrom(this.resourceBlock);
    }

    @Override
    public boolean isProperlyStructured() {
        return true;
    }

    @Override
    public boolean fallsNopToNext() {
        return true;
    }

    public void addCatch(Op04StructuredStatement catchStatement) {
        this.catchBlocks.add(catchStatement);
    }

    public void setFinally(Op04StructuredStatement finallyBlock) {
        this.finallyBlock = finallyBlock;
    }

    public void removeFinalJumpsTo(Op04StructuredStatement after) {
        this.tryBlock.removeLastGoto(after);
    }

    @Override
    public boolean isScopeBlock() {
        return true;
    }

    @Override
    public void transformStructuredChildren(StructuredStatementTransformer transformer, StructuredScope scope) {
        if (this.resourceBlock != null) {
            for (Op04StructuredStatement resource : this.resourceBlock) {
                resource.transform(transformer, scope);
            }
        }
        this.tryBlock.transform(transformer, scope);
        for (Op04StructuredStatement catchBlock : this.catchBlocks) {
            catchBlock.transform(transformer, scope);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.transform(transformer, scope);
        }
    }

    @Override
    public void linearizeInto(List<StructuredStatement> out) {
        out.add(this);
        if (this.resourceBlock != null) {
            for (Op04StructuredStatement resource : this.resourceBlock) {
                out.add(resource.getStatement());
            }
        }
        this.tryBlock.linearizeStatementsInto(out);
        for (Op04StructuredStatement catchBlock : this.catchBlocks) {
            catchBlock.linearizeStatementsInto(out);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.linearizeStatementsInto(out);
        }
    }

    @Override
    public void traceLocalVariableScope(LValueScopeDiscoverer scopeDiscoverer) {
        if (this.resourceBlock != null) {
            scopeDiscoverer.enterBlock(this);
            for (Op04StructuredStatement resource : this.resourceBlock) {
                resource.traceLocalVariableScope(scopeDiscoverer);
            }
        }
        this.tryBlock.traceLocalVariableScope(scopeDiscoverer);
        for (Op04StructuredStatement catchBlock : this.catchBlocks) {
            catchBlock.traceLocalVariableScope(scopeDiscoverer);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.traceLocalVariableScope(scopeDiscoverer);
        }
        if (this.resourceBlock != null) {
            scopeDiscoverer.leaveBlock(this);
        }
    }

    @Override
    public boolean isRecursivelyStructured() {
        if (this.resourceBlock != null) {
            for (Op04StructuredStatement resource : this.resourceBlock) {
                if (resource.isFullyStructured()) continue;
                return false;
            }
        }
        if (!this.tryBlock.isFullyStructured()) {
            return false;
        }
        for (Op04StructuredStatement catchBlock : this.catchBlocks) {
            if (catchBlock.isFullyStructured()) continue;
            return false;
        }
        return this.finallyBlock == null || this.finallyBlock.isFullyStructured();
    }

    public Op04StructuredStatement getFinallyBlock() {
        return this.finallyBlock;
    }

    @Override
    public boolean match(MatchIterator<StructuredStatement> matchIterator, MatchResultCollector matchResultCollector) {
        StructuredStatement o = matchIterator.getCurrent();
        if (!(o instanceof StructuredTry)) {
            return false;
        }
        StructuredTry other = (StructuredTry)o;
        matchIterator.advance();
        return true;
    }

    @Override
    public void rewriteExpressions(ExpressionRewriter expressionRewriter) {
    }

    private boolean isPointlessTry() {
        if (!this.catchBlocks.isEmpty()) {
            return false;
        }
        if (this.finallyBlock == null) {
            return true;
        }
        if (!(this.finallyBlock.getStatement() instanceof StructuredFinally)) {
            return false;
        }
        StructuredFinally structuredFinally = (StructuredFinally)this.finallyBlock.getStatement();
        Op04StructuredStatement finallyCode = structuredFinally.getCatchBlock();
        if (!(finallyCode.getStatement() instanceof Block)) {
            return false;
        }
        Block block = (Block)finallyCode.getStatement();
        return block.isEffectivelyNOP();
    }

    private boolean isJustTryCatchThrow() {
        if (this.resourceBlock != null) {
            return false;
        }
        if (this.finallyBlock != null) {
            return false;
        }
        if (this.catchBlocks.size() != 1) {
            return false;
        }
        Op04StructuredStatement catchBlock = this.catchBlocks.get(0);
        StructuredStatement catchS = catchBlock.getStatement();
        if (!(catchS instanceof StructuredCatch)) {
            return false;
        }
        StructuredCatch structuredCatch = (StructuredCatch)catchS;
        return structuredCatch.isRethrow();
    }

    @Override
    public boolean inlineable() {
        return this.isPointlessTry() || this.isJustTryCatchThrow();
    }

    public BlockIdentifier getTryBlockIdentifier() {
        return this.tryBlockIdentifier;
    }

    @Override
    public Op04StructuredStatement getInline() {
        return this.tryBlock;
    }

    public void setTryBlock(Op04StructuredStatement tryBlock) {
        this.tryBlock = tryBlock;
    }
}

