/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.parse.literal;

import com.OooOO0OO;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.QuotingUtils;
import org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.RawJavaType;
import org.benf.cfr.reader.bytecode.analysis.types.StackType;
import org.benf.cfr.reader.bytecode.analysis.types.TypeConstants;
import org.benf.cfr.reader.bytecode.analysis.types.discovery.InferredJavaType;
import org.benf.cfr.reader.entities.constantpool.ConstantPool;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntry;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryDouble;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryFloat;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryInteger;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryLong;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryMethodHandle;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryMethodRef;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryMethodType;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryString;
import org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryUTF8;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.util.ConfusedCFRException;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.TypeUsageCollectable;
import org.benf.cfr.reader.util.output.Dumpable;
import org.benf.cfr.reader.util.output.Dumper;
import org.benf.cfr.reader.util.output.ToStringDumper;

public class TypedLiteral
implements TypeUsageCollectable,
Dumpable {
    private final InferredJavaType inferredJavaType;
    private final LiteralType type;
    private final Object value;

    protected TypedLiteral(LiteralType type, InferredJavaType inferredJavaType, Object value) {
        this.type = type;
        this.value = value;
        this.inferredJavaType = inferredJavaType;
    }

    @Override
    public void collectTypeUsages(TypeUsageCollector collector) {
        if (this.type == LiteralType.Class) {
            collector.collect((JavaTypeInstance)this.value);
        }
    }

    private static String integerName(Object o) {
        if (!(o instanceof Integer)) {
            return o.toString();
        }
        int i = (Integer)o;
        switch (i) {
            case 0x7FFFFFFF: {
                return OooOO0OO.OooOOoo0oo("76514B5A585A4D11727E6760697E736A7A");
            }
            case -2147483648: {
                return OooOO0OO.OooOOoo0oo("76514B5A585A4D1172767160697E736A7A");
            }
        }
        return o.toString();
    }

    private static String doubleName(Object o) {
        boolean isNeg;
        if (!(o instanceof Double)) {
            return o.toString();
        }
        double d = (Double)o;
        boolean bl = isNeg = d < 0.0;
        if (Double.isInfinite(d)) {
            return isNeg ? OooOO0OO.OooOOoo0oo("7B504A5D535A11717A787E6B76697A607671797671766B66") : OooOO0OO.OooOOoo0oo("7B504A5D535A116F706C766B76697A607671797671766B66");
        }
        if (Double.compare(d, Double.MAX_VALUE) == 0) {
            return OooOO0OO.OooOOoo0oo("7B504A5D535A11727E6760697E736A7A");
        }
        if (Double.compare(d, Double.MIN_VALUE) == 0) {
            return OooOO0OO.OooOOoo0oo("7B504A5D535A1172767160697E736A7A");
        }
        if (Double.compare(d, Double.MIN_NORMAL) == 0) {
            return OooOO0OO.OooOOoo0oo("7B504A5D535A117276716071706D727E73");
        }
        if (Double.isNaN(d)) {
            return OooOO0OO.OooOOoo0oo("7B504A5D535A11715E71");
        }
        return o.toString();
    }

    private static String floatName(Object o) {
        boolean isNeg;
        if (!(o instanceof Float)) {
            return o.toString() + OooOO0OO.OooOOoo0oo("59");
        }
        float d = ((Float)o).floatValue();
        boolean bl = isNeg = d < 0.0f;
        if (Float.isInfinite(d)) {
            return isNeg ? OooOO0OO.OooOOoo0oo("7953505E4B11717A787E6B76697A607671797671766B66") : OooOO0OO.OooOOoo0oo("7953505E4B116F706C766B76697A607671797671766B66");
        }
        if (Float.compare(d, Float.MAX_VALUE) == 0) {
            return OooOO0OO.OooOOoo0oo("7953505E4B11727E6760697E736A7A");
        }
        if (Float.compare(d, Float.MIN_VALUE) == 0) {
            return OooOO0OO.OooOOoo0oo("7953505E4B1172767160697E736A7A");
        }
        if (Float.compare(d, Float.MIN_NORMAL) == 0) {
            return OooOO0OO.OooOOoo0oo("7953505E4B117276716071706D727E73");
        }
        if (Float.isNaN(d)) {
            return OooOO0OO.OooOOoo0oo("7953505E4B11715E71");
        }
        return o.toString() + OooOO0OO.OooOOoo0oo("59");
    }

    public boolean getBoolValue() {
        if (this.type != LiteralType.Integer) {
            throw new IllegalStateException(OooOO0OO.OooOOoo0oo("7A474F5A5C4B5651581F56514B5A584D5E531F53564B5A4D5E53"));
        }
        Integer i = (Integer)this.value;
        return i != 0;
    }

    public Boolean getMaybeBoolValue() {
        if (this.type != LiteralType.Integer) {
            return null;
        }
        Integer i = (Integer)this.value;
        return i == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    private static String charName(Object o) {
        if (!(o instanceof Integer)) {
            throw new ConfusedCFRException(OooOO0OO.OooOOoo0oo("7A474F5A5C4B5651581F5C575E4D125E4C1256514B"));
        }
        int i = (Integer)o;
        char c = (char)i;
        switch (c) {
            case '\"': {
                return OooOO0OO.OooOOoo0oo("18631D18");
            }
            case '\r': {
                return OooOO0OO.OooOOoo0oo("18634D18");
            }
            case '\n': {
                return OooOO0OO.OooOOoo0oo("18635118");
            }
            case '\t': {
                return OooOO0OO.OooOOoo0oo("18634B18");
            }
            case '\b': {
                return OooOO0OO.OooOOoo0oo("18635D18");
            }
            case '\f': {
                return OooOO0OO.OooOOoo0oo("18635918");
            }
            case '\\': {
                return OooOO0OO.OooOOoo0oo("18636318");
            }
            case '\'': {
                return OooOO0OO.OooOOoo0oo("18631818");
            }
        }
        if (i < 32 || i >= 254) {
            return OooOO0OO.OooOOoo0oo("18634A") + String.format(OooOO0OO.OooOOoo0oo("1A0F0B47"), i) + OooOO0OO.OooOOoo0oo("18");
        }
        return OooOO0OO.OooOOoo0oo("18") + c + OooOO0OO.OooOOoo0oo("18");
    }

    private static String boolName(Object o) {
        if (!(o instanceof Integer)) {
            throw new ConfusedCFRException(OooOO0OO.OooOOoo0oo("7A474F5A5C4B5651581F5D5050535A5E51125E4C1256514B"));
        }
        int i = (Integer)o;
        switch (i) {
            case 0: {
                return OooOO0OO.OooOOoo0oo("595E534C5A");
            }
            case 1: {
                return OooOO0OO.OooOOoo0oo("4B4D4A5A");
            }
        }
        return OooOO0OO.OooOOoo0oo("7D7E7B7D7070731F") + i;
    }

    private static String longName(Object o) {
        if (!(o instanceof Long)) {
            return o.toString();
        }
        long l = (Long)o;
        if (l == Long.MAX_VALUE) {
            return OooOO0OO.OooOOoo0oo("7350515811727E6760697E736A7A");
        }
        if (l == Long.MIN_VALUE) {
            return OooOO0OO.OooOOoo0oo("735051581172767160697E736A7A");
        }
        if (l == Integer.MAX_VALUE) {
            return OooOO0OO.OooOOoo0oo("76514B5A585A4D11727E6760697E736A7A");
        }
        if (l == Integer.MIN_VALUE) {
            return OooOO0OO.OooOOoo0oo("76514B5A585A4D1172767160697E736A7A");
        }
        String longString = o.toString();
        if (l > 1048575L) {
            String hexTest = Long.toHexString(l).toUpperCase();
            byte[] bytes = hexTest.getBytes();
            byte[] count = new byte[16];
            int diff = 0;
            int len = bytes.length;
            for (int i = 0; i < len; ++i) {
                byte b = bytes[i];
                if (b >= 48 && b <= 57) {
                    int n = bytes[i] - 48;
                    count[n] = (byte)(count[n] + 1);
                    if (count[n] != 1) continue;
                    ++diff;
                    continue;
                }
                if (b >= 65 && b <= 70) {
                    int n = bytes[i] - 65 + 10;
                    count[n] = (byte)(count[n] + 1);
                    if (count[n] != 1) continue;
                    ++diff;
                    continue;
                }
                diff = 10;
                break;
            }
            if (diff <= 2) {
                longString = OooOO0OO.OooOOoo0oo("0F47") + hexTest;
            }
        }
        return longString + OooOO0OO.OooOOoo0oo("73");
    }

    private static String methodHandleName(Object o) {
        ConstantPoolEntryMethodHandle methodHandle = (ConstantPoolEntryMethodHandle)o;
        ConstantPoolEntryMethodRef methodRef = methodHandle.getMethodRef();
        return methodRef.getMethodPrototype().toString();
    }

    private static String methodTypeName(Object o) {
        ConstantPoolEntryMethodType methodType = (ConstantPoolEntryMethodType)o;
        return methodType.getDescriptor().getValue();
    }

    @Override
    public Dumper dump(Dumper d) {
        switch (this.type) {
            case String: {
                return d.print((String)this.value);
            }
            case NullObject: {
                return d.print(OooOO0OO.OooOOoo0oo("514A5353"));
            }
            case Integer: {
                switch (this.inferredJavaType.getRawType()) {
                    case CHAR: {
                        return d.print(TypedLiteral.charName(this.value));
                    }
                    case BOOLEAN: {
                        return d.print(TypedLiteral.boolName(this.value));
                    }
                }
                return d.print(TypedLiteral.integerName(this.value));
            }
            case Long: {
                return d.print(TypedLiteral.longName(this.value));
            }
            case MethodType: {
                return d.print(TypedLiteral.methodTypeName(this.value));
            }
            case MethodHandle: {
                return d.print(TypedLiteral.methodHandleName(this.value));
            }
            case Class: {
                return d.dump((JavaTypeInstance)this.value).print(OooOO0OO.OooOOoo0oo("115C535E4C4C"));
            }
            case Double: {
                return d.print(TypedLiteral.doubleName(this.value));
            }
            case Float: {
                return d.print(TypedLiteral.floatName(this.value));
            }
        }
        return d.print(this.value.toString());
    }

    public String toString() {
        return ToStringDumper.toString(this);
    }

    public static TypedLiteral getLong(long v) {
        return new TypedLiteral(LiteralType.Long, new InferredJavaType(RawJavaType.LONG, InferredJavaType.Source.LITERAL), v);
    }

    public static TypedLiteral getInt(int v) {
        return new TypedLiteral(LiteralType.Integer, new InferredJavaType(RawJavaType.INT, InferredJavaType.Source.LITERAL), v);
    }

    public static TypedLiteral getChar(int v) {
        return new TypedLiteral(LiteralType.Integer, new InferredJavaType(RawJavaType.CHAR, InferredJavaType.Source.LITERAL), v);
    }

    public static TypedLiteral getBoolean(int v) {
        return new TypedLiteral(LiteralType.Integer, new InferredJavaType(RawJavaType.BOOLEAN, InferredJavaType.Source.LITERAL), v);
    }

    public static TypedLiteral getDouble(double v) {
        return new TypedLiteral(LiteralType.Double, new InferredJavaType(RawJavaType.DOUBLE, InferredJavaType.Source.LITERAL), v);
    }

    public static TypedLiteral getFloat(float v) {
        return new TypedLiteral(LiteralType.Float, new InferredJavaType(RawJavaType.FLOAT, InferredJavaType.Source.LITERAL), Float.valueOf(v));
    }

    public static TypedLiteral getClass(JavaTypeInstance v) {
        JavaGenericRefTypeInstance tgt = new JavaGenericRefTypeInstance(TypeConstants.CLASS, ListFactory.newImmutableList(v));
        return new TypedLiteral(LiteralType.Class, new InferredJavaType(tgt, InferredJavaType.Source.LITERAL), v);
    }

    public static TypedLiteral getString(String v) {
        return new TypedLiteral(LiteralType.String, new InferredJavaType(TypeConstants.STRING, InferredJavaType.Source.LITERAL), v);
    }

    public static TypedLiteral getNull() {
        return new TypedLiteral(LiteralType.NullObject, new InferredJavaType(RawJavaType.NULL, InferredJavaType.Source.LITERAL), null);
    }

    public static TypedLiteral getMethodHandle(ConstantPoolEntryMethodHandle methodHandle, ConstantPool cp) {
        JavaRefTypeInstance typeInstance = cp.getClassCache().getRefClassFor(OooOO0OO.OooOOoo0oo("555E495E11535E51581156514950545A11725A4B57505B775E515B535A"));
        return new TypedLiteral(LiteralType.MethodHandle, new InferredJavaType(typeInstance, InferredJavaType.Source.LITERAL), methodHandle);
    }

    public static TypedLiteral getMethodType(ConstantPoolEntryMethodType methodType, ConstantPool cp) {
        JavaRefTypeInstance typeInstance = cp.getClassCache().getRefClassFor(OooOO0OO.OooOOoo0oo("555E495E11535E51581156514950545A11725A4B57505B6B464F5A"));
        return new TypedLiteral(LiteralType.MethodType, new InferredJavaType(typeInstance, InferredJavaType.Source.LITERAL), methodType);
    }

    public static TypedLiteral getConstantPoolEntryUTF8(ConstantPoolEntryUTF8 cpe) {
        return TypedLiteral.getString(QuotingUtils.enquoteString(cpe.getValue()));
    }

    public static TypedLiteral getConstantPoolEntry(ConstantPool cp, ConstantPoolEntry cpe) {
        if (cpe instanceof ConstantPoolEntryDouble) {
            return TypedLiteral.getDouble(((ConstantPoolEntryDouble)cpe).getValue());
        }
        if (cpe instanceof ConstantPoolEntryFloat) {
            return TypedLiteral.getFloat(((ConstantPoolEntryFloat)cpe).getValue());
        }
        if (cpe instanceof ConstantPoolEntryLong) {
            return TypedLiteral.getLong(((ConstantPoolEntryLong)cpe).getValue());
        }
        if (cpe instanceof ConstantPoolEntryInteger) {
            return TypedLiteral.getInt(((ConstantPoolEntryInteger)cpe).getValue());
        }
        if (cpe instanceof ConstantPoolEntryString) {
            return TypedLiteral.getString(((ConstantPoolEntryString)cpe).getValue());
        }
        if (cpe instanceof ConstantPoolEntryClass) {
            return TypedLiteral.getClass(((ConstantPoolEntryClass)cpe).getTypeInstance());
        }
        if (cpe instanceof ConstantPoolEntryMethodHandle) {
            return TypedLiteral.getMethodHandle((ConstantPoolEntryMethodHandle)cpe, cp);
        }
        if (cpe instanceof ConstantPoolEntryMethodType) {
            return TypedLiteral.getMethodType((ConstantPoolEntryMethodType)cpe, cp);
        }
        throw new ConfusedCFRException(OooOO0OO.OooOOoo0oo("7C5E51184B1F4B4A4D511F7C50514C4B5E514B6F5050537A514B4D461F56514B501F73564B5A4D5E531F121F58504B1F") + cpe);
    }

    public static TypedLiteral shrinkTo(TypedLiteral original, RawJavaType tgt) {
        if (original.getType() != LiteralType.Integer) {
            return original;
        }
        if (tgt.getStackType() != StackType.INT) {
            return original;
        }
        Integer i = (Integer)original.value;
        if (i == null) {
            return original;
        }
        switch (tgt) {
            case BOOLEAN: {
                return TypedLiteral.getBoolean(i);
            }
            case CHAR: {
                return TypedLiteral.getChar(i);
            }
        }
        return original;
    }

    public LiteralType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public InferredJavaType getInferredJavaType() {
        return this.inferredJavaType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypedLiteral)) {
            return false;
        }
        TypedLiteral other = (TypedLiteral)o;
        return this.type == other.type && (this.value == null ? other.value == null : this.value.equals(other.value));
    }

    public static enum LiteralType {
        Integer,
        Long,
        Double,
        Float,
        String,
        NullObject,
        Class,
        MethodHandle,
        MethodType;

    }
}

