/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.parse.expression;

import com.OooOO0OO;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.misc.Precedence;
import org.benf.cfr.reader.bytecode.opcode.JVMInstr;
import org.benf.cfr.reader.util.ConfusedCFRException;

public enum ArithOp {
    LCMP(OooOO0OO.OooOOoo0oo("737C726F"), true, Precedence.WEAKEST),
    DCMPL(OooOO0OO.OooOOoo0oo("7B7C726F73"), true, Precedence.WEAKEST),
    DCMPG(OooOO0OO.OooOOoo0oo("7B7C726F78"), true, Precedence.WEAKEST),
    FCMPL(OooOO0OO.OooOOoo0oo("797C726F73"), true, Precedence.WEAKEST),
    FCMPG(OooOO0OO.OooOOoo0oo("797C726F78"), true, Precedence.WEAKEST),
    PLUS(OooOO0OO.OooOOoo0oo("14"), false, Precedence.ADD_SUB),
    MINUS(OooOO0OO.OooOOoo0oo("12"), false, Precedence.ADD_SUB),
    MULTIPLY(OooOO0OO.OooOOoo0oo("15"), false, Precedence.MUL_DIV_MOD),
    DIVIDE(OooOO0OO.OooOOoo0oo("10"), false, Precedence.MUL_DIV_MOD),
    REM(OooOO0OO.OooOOoo0oo("1A"), false, Precedence.MUL_DIV_MOD),
    OR(OooOO0OO.OooOOoo0oo("43"), false, Precedence.BIT_OR),
    AND(OooOO0OO.OooOOoo0oo("19"), false, Precedence.BIT_AND),
    SHR(OooOO0OO.OooOOoo0oo("0101"), false, Precedence.BITWISE_SHIFT),
    SHL(OooOO0OO.OooOOoo0oo("0303"), false, Precedence.BITWISE_SHIFT),
    SHRU(OooOO0OO.OooOOoo0oo("010101"), false, Precedence.BITWISE_SHIFT),
    XOR(OooOO0OO.OooOOoo0oo("61"), false, Precedence.BIT_XOR),
    NEG(OooOO0OO.OooOOoo0oo("41"), false, Precedence.UNARY_OTHER);

    private final String showAs;
    private final boolean temporary;
    private final Precedence precedence;

    private ArithOp(String showAs, boolean temporary, Precedence precedence) {
        this.showAs = showAs;
        this.temporary = temporary;
        this.precedence = precedence;
    }

    public String getShowAs() {
        return this.showAs;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public Precedence getPrecedence() {
        return this.precedence;
    }

    public static ArithOp getOpFor(JVMInstr instr) {
        switch (instr) {
            case LCMP: {
                return LCMP;
            }
            case DCMPG: {
                return DCMPG;
            }
            case DCMPL: {
                return DCMPL;
            }
            case FCMPG: {
                return FCMPG;
            }
            case FCMPL: {
                return FCMPL;
            }
            case ISUB: 
            case LSUB: 
            case FSUB: 
            case DSUB: {
                return MINUS;
            }
            case IMUL: 
            case LMUL: 
            case FMUL: 
            case DMUL: {
                return MULTIPLY;
            }
            case IADD: 
            case LADD: 
            case FADD: 
            case DADD: {
                return PLUS;
            }
            case LDIV: 
            case IDIV: 
            case FDIV: 
            case DDIV: {
                return DIVIDE;
            }
            case LOR: 
            case IOR: {
                return OR;
            }
            case LAND: 
            case IAND: {
                return AND;
            }
            case IREM: 
            case LREM: 
            case FREM: 
            case DREM: {
                return REM;
            }
            case ISHR: 
            case LSHR: {
                return SHR;
            }
            case IUSHR: 
            case LUSHR: {
                return SHRU;
            }
            case ISHL: 
            case LSHL: {
                return SHL;
            }
            case IXOR: 
            case LXOR: {
                return XOR;
            }
        }
        throw new ConfusedCFRException(OooOO0OO.OooOOoo0oo("7B5051184B1F545150481F5E4D564B571F504F1F59504D1F") + (Object)((Object)instr));
    }
}

