/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters;

import com.OooOO0OO;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.benf.cfr.reader.bytecode.BytecodeMeta;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.Op04Rewriter;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.AbstractMatchResultIterator;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.CollectMatch;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.KleenePlus;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.KleeneStar;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.MatchIterator;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.MatchResultCollector;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.MatchSequence;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.Matcher;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.util.MiscStatementTools;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.BooleanExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.Literal;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.NotOperation;
import org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.BlockIdentifier;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.parse.wildcard.WildcardMatch;
import org.benf.cfr.reader.bytecode.analysis.structured.StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.AbstractStructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.Block;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredBreak;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCase;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredSwitch;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.placeholder.BeginBlock;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.placeholder.EndBlock;
import org.benf.cfr.reader.bytecode.analysis.types.TypeConstants;
import org.benf.cfr.reader.bytecode.analysis.types.discovery.InferredJavaType;
import org.benf.cfr.reader.util.ClassFileVersion;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.functors.UnaryFunction;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;

public class SwitchStringRewriter
implements Op04Rewriter {
    private final Options options;
    private final ClassFileVersion classFileVersion;
    private final BytecodeMeta bytecodeMeta;

    public SwitchStringRewriter(Options options, ClassFileVersion classFileVersion, BytecodeMeta bytecodeMeta) {
        this.options = options;
        this.classFileVersion = classFileVersion;
        this.bytecodeMeta = bytecodeMeta;
    }

    @Override
    public void rewrite(Op04StructuredStatement root) {
        if (!this.options.getOption(OptionsImpl.STRING_SWITCH, this.classFileVersion).booleanValue() && !this.bytecodeMeta.has(BytecodeMeta.CodeInfoFlag.STRING_SWITCHES)) {
            return;
        }
        List<StructuredStatement> structuredStatements = MiscStatementTools.linearise(root);
        if (structuredStatements == null) {
            return;
        }
        MatchIterator<StructuredStatement> mi = new MatchIterator<StructuredStatement>(structuredStatements);
        WildcardMatch wcm1 = new WildcardMatch();
        WildcardMatch wcm2 = new WildcardMatch();
        WildcardMatch wcm3 = new WildcardMatch();
        ResetAfterTest m = new ResetAfterTest(wcm1, new MatchSequence(new CollectMatch(OooOO0OO.OooOOoo0oo("5E4C4C0E"), new StructuredAssignment(wcm1.getLValueWildCard(OooOO0OO.OooOOoo0oo("4C4B4D565158505D555A5C4B")), wcm1.getExpressionWildCard(OooOO0OO.OooOOoo0oo("504D565856515E534C4B4D565158")))), new CollectMatch(OooOO0OO.OooOOoo0oo("5E4C4C0D"), new StructuredAssignment(wcm1.getLValueWildCard(OooOO0OO.OooOOoo0oo("56514B5A4D525A5B")), wcm1.getExpressionWildCard(OooOO0OO.OooOOoo0oo("5B5A595E4A534B56514B5A4D525A5B")))), new CollectMatch(OooOO0OO.OooOOoo0oo("4C48564B5C570E"), new StructuredSwitch(wcm1.getMemberFunction(OooOO0OO.OooOOoo0oo("4C48564B5C57"), OooOO0OO.OooOOoo0oo("575E4C577C505B5A"), (Expression)new LValueExpression(wcm1.getLValueWildCard(OooOO0OO.OooOOoo0oo("4C4B4D565158505D555A5C4B")))), null, wcm1.getBlockIdentifier(OooOO0OO.OooOOoo0oo("4C48564B5C575D53505C54")))), new BeginBlock(null), new KleenePlus((Matcher<StructuredStatement>)new ResetAfterTest(wcm2, new MatchSequence(new StructuredCase(wcm2.getList(OooOO0OO.OooOOoo0oo("575E4C57495E534C")), null, null, wcm2.getBlockIdentifier(OooOO0OO.OooOOoo0oo("5C5E4C5A"))), new BeginBlock(null), new KleeneStar((Matcher<StructuredStatement>)new ResetAfterTest(wcm3, new MatchSequence(new StructuredIf(new BooleanExpression(wcm3.getMemberFunction(OooOO0OO.OooOOoo0oo("5C505353564C565051"), OooOO0OO.OooOOoo0oo("5A4E4A5E534C"), new LValueExpression(wcm1.getLValueWildCard(OooOO0OO.OooOOoo0oo("4C4B4D565158505D555A5C4B"))), wcm3.getExpressionWildCard(OooOO0OO.OooOOoo0oo("4C4B4D565158495E534A5A")))), null), new BeginBlock(null), new StructuredAssignment(wcm1.getLValueWildCard(OooOO0OO.OooOOoo0oo("56514B5A4D525A5B")), wcm3.getExpressionWildCard(OooOO0OO.OooOOoo0oo("5C5E4C5A0D565B"))), new StructuredBreak(wcm1.getBlockIdentifier(OooOO0OO.OooOOoo0oo("4C48564B5C575D53505C54")), true), new EndBlock(null)))), new StructuredIf(new NotOperation(new BooleanExpression(wcm2.getMemberFunction(OooOO0OO.OooOOoo0oo("5E514B565C505353564C565051"), OooOO0OO.OooOOoo0oo("5A4E4A5E534C"), new LValueExpression(wcm1.getLValueWildCard(OooOO0OO.OooOOoo0oo("4C4B4D565158505D555A5C4B"))), wcm2.getExpressionWildCard(OooOO0OO.OooOOoo0oo("4C4B4D565158495E534A5A"))))), null), new StructuredBreak(wcm1.getBlockIdentifier(OooOO0OO.OooOOoo0oo("4C48564B5C575D53505C54")), true), new StructuredAssignment(wcm1.getLValueWildCard(OooOO0OO.OooOOoo0oo("56514B5A4D525A5B")), wcm2.getExpressionWildCard(OooOO0OO.OooOOoo0oo("5C5E4C5A0D565B"))), new KleeneStar((Matcher<StructuredStatement>)new StructuredBreak(wcm1.getBlockIdentifier(OooOO0OO.OooOOoo0oo("4C48564B5C575D53505C54")), true)), new EndBlock(null)))), new EndBlock(null), new CollectMatch(OooOO0OO.OooOOoo0oo("4C48564B5C570D"), new StructuredSwitch(new LValueExpression(wcm1.getLValueWildCard(OooOO0OO.OooOOoo0oo("56514B5A4D525A5B"))), null, wcm1.getBlockIdentifier(OooOO0OO.OooOOoo0oo("4C48564B5C575D53505C540D"))))));
        SwitchStringMatchResultCollector matchResultCollector = new SwitchStringMatchResultCollector(wcm1, wcm2, wcm3);
        while (mi.hasNext()) {
            mi.advance();
            matchResultCollector.clear();
            if (!m.match(mi, (MatchResultCollector)matchResultCollector)) continue;
            StructuredSwitch firstSwitch = (StructuredSwitch)matchResultCollector.getStatementByName(OooOO0OO.OooOOoo0oo("4C48564B5C570E"));
            StructuredSwitch secondSwitch = (StructuredSwitch)matchResultCollector.getStatementByName(OooOO0OO.OooOOoo0oo("4C48564B5C570D"));
            StructuredSwitch replacement = this.rewriteSwitch(secondSwitch, matchResultCollector);
            secondSwitch.getContainer().replaceContainedStatement(replacement);
            firstSwitch.getContainer().nopThis();
            ((AbstractStructuredStatement)matchResultCollector.getStatementByName(OooOO0OO.OooOOoo0oo("5E4C4C0E"))).getContainer().nopThis();
            ((AbstractStructuredStatement)matchResultCollector.getStatementByName(OooOO0OO.OooOOoo0oo("5E4C4C0D"))).getContainer().nopThis();
            mi.rewind1();
        }
    }

    private StructuredSwitch rewriteSwitch(StructuredSwitch original, SwitchStringMatchResultCollector matchResultCollector) {
        Op04StructuredStatement body = original.getBody();
        BlockIdentifier blockIdentifier = original.getBlockIdentifier();
        StructuredStatement inner = body.getStatement();
        if (!(inner instanceof Block)) {
            throw new FailedRewriteException(OooOO0OO.OooOOoo0oo("6C48564B5C571F5D505B461F564C1F51504B1F5E1F5D53505C54131F564C1F5E1F") + inner.getClass());
        }
        Block block = (Block)inner;
        Map<Integer, List<String>> replacements = matchResultCollector.getValidatedHashes();
        List<Op04StructuredStatement> caseStatements = block.getBlockStatements();
        LinkedList<Op04StructuredStatement> tgt = ListFactory.newLinkedList();
        InferredJavaType typeOfSwitch = matchResultCollector.getStringExpression().getInferredJavaType();
        for (Op04StructuredStatement op04StructuredStatement : caseStatements) {
            inner = op04StructuredStatement.getStatement();
            if (!(inner instanceof StructuredCase)) {
                throw new FailedRewriteException(OooOO0OO.OooOOoo0oo("7D53505C541F525A525D5A4D1F564C1F51504B1F5E1F5C5E4C5A131F564B184C1F5E1F") + inner.getClass());
            }
            StructuredCase structuredCase = (StructuredCase)inner;
            List<Expression> values = structuredCase.getValues();
            List<Expression> transformedValues = ListFactory.newList();
            for (Expression value : values) {
                Integer i = SwitchStringRewriter.getInt(value);
                List<String> replacementStrings = replacements.get(i);
                if (replacementStrings == null) {
                    throw new FailedRewriteException(OooOO0OO.OooOOoo0oo("71501F4D5A4F535E5C5A525A514B4C1F59504D1F") + i);
                }
                for (String s : replacementStrings) {
                    transformedValues.add(new Literal(TypedLiteral.getString(s)));
                }
            }
            StructuredCase replacementStructuredCase = new StructuredCase(transformedValues, typeOfSwitch, structuredCase.getBody(), structuredCase.getBlockIdentifier());
            tgt.add(new Op04StructuredStatement(replacementStructuredCase));
        }
        Block newBlock = new Block(tgt, true);
        Expression switchOn = matchResultCollector.getStringExpression();
        if (switchOn.equals(Literal.NULL)) {
            switchOn = new CastExpression(new InferredJavaType(TypeConstants.STRING, InferredJavaType.Source.EXPRESSION), switchOn, true);
        }
        return new StructuredSwitch(switchOn, new Op04StructuredStatement(newBlock), blockIdentifier);
    }

    static String getString(Expression e) {
        if (!(e instanceof Literal)) {
            throw new TooOptimisticMatchException();
        }
        Literal l = (Literal)e;
        TypedLiteral typedLiteral = l.getValue();
        if (typedLiteral.getType() != TypedLiteral.LiteralType.String) {
            throw new TooOptimisticMatchException();
        }
        String s = (String)typedLiteral.getValue();
        return s;
    }

    static Integer getInt(Expression e) {
        if (!(e instanceof Literal)) {
            throw new TooOptimisticMatchException();
        }
        Literal l = (Literal)e;
        TypedLiteral typedLiteral = l.getValue();
        if (typedLiteral.getType() != TypedLiteral.LiteralType.Integer) {
            throw new TooOptimisticMatchException();
        }
        return (Integer)typedLiteral.getValue();
    }

    private static class FailedRewriteException
    extends IllegalStateException {
        public FailedRewriteException(String s) {
            super(s);
        }
    }

    private static class TooOptimisticMatchException
    extends IllegalStateException {
        private TooOptimisticMatchException() {
        }
    }

    private static class SwitchStringMatchResultCollector
    extends AbstractMatchResultIterator {
        private final WildcardMatch wholeBlock;
        private final WildcardMatch caseStatement;
        private final WildcardMatch hashCollision;
        private Expression stringExpression = null;
        private final List<Pair<String, Integer>> pendingHashCode = ListFactory.newList();
        private final Map<Integer, List<String>> validatedHashes = MapFactory.newLazyMap(new UnaryFunction<Integer, List<String>>(){

            @Override
            public List<String> invoke(Integer arg) {
                return ListFactory.newList();
            }
        });
        private final Map<String, StructuredStatement> collectedStatements = MapFactory.newMap();

        private SwitchStringMatchResultCollector(WildcardMatch wholeBlock, WildcardMatch caseStatement, WildcardMatch hashCollision) {
            this.wholeBlock = wholeBlock;
            this.caseStatement = caseStatement;
            this.hashCollision = hashCollision;
        }

        @Override
        public void clear() {
            this.stringExpression = null;
            this.pendingHashCode.clear();
            this.validatedHashes.clear();
            this.collectedStatements.clear();
        }

        @Override
        public void collectStatement(String name, StructuredStatement statement) {
            this.collectedStatements.put(name, statement);
        }

        @Override
        public void collectMatches(String name, WildcardMatch wcm) {
            if (wcm == this.wholeBlock) {
                Expression stringObject;
                this.stringExpression = stringObject = wcm.getExpressionWildCard(OooOO0OO.OooOOoo0oo("504D565856515E534C4B4D565158")).getMatch();
            } else if (wcm == this.caseStatement) {
                List hashvals = wcm.getList(OooOO0OO.OooOOoo0oo("575E4C57495E534C")).getMatch();
                Expression case2id = wcm.getExpressionWildCard(OooOO0OO.OooOOoo0oo("5C5E4C5A0D565B")).getMatch();
                Expression stringValue = wcm.getExpressionWildCard(OooOO0OO.OooOOoo0oo("4C4B4D565158495E534A5A")).getMatch();
                this.pendingHashCode.add(Pair.make(SwitchStringRewriter.getString(stringValue), SwitchStringRewriter.getInt(case2id)));
                this.processPendingWithHashCode(hashvals);
            } else if (wcm == this.hashCollision) {
                Expression case2id = wcm.getExpressionWildCard(OooOO0OO.OooOOoo0oo("5C5E4C5A0D565B")).getMatch();
                Expression stringValue = wcm.getExpressionWildCard(OooOO0OO.OooOOoo0oo("4C4B4D565158495E534A5A")).getMatch();
                this.pendingHashCode.add(Pair.make(SwitchStringRewriter.getString(stringValue), SwitchStringRewriter.getInt(case2id)));
            } else {
                throw new IllegalStateException();
            }
        }

        void processPendingWithHashCode(List<Expression> hashVals) {
            for (Pair<String, Integer> pair : this.pendingHashCode) {
                this.validatedHashes.get(pair.getSecond()).add(pair.getFirst());
            }
            this.pendingHashCode.clear();
        }

        public Expression getStringExpression() {
            return this.stringExpression;
        }

        public Map<Integer, List<String>> getValidatedHashes() {
            return this.validatedHashes;
        }

        public StructuredStatement getStatementByName(String name) {
            StructuredStatement structuredStatement = this.collectedStatements.get(name);
            if (structuredStatement == null) {
                throw new IllegalArgumentException(OooOO0OO.OooOOoo0oo("71501F5C5053535A5C4B5A5B1F4C4B5E4B5A525A514B1F") + name);
            }
            return structuredStatement;
        }
    }
}

