/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader;

import com.OooOO0OO;
import java.util.Collections;
import java.util.List;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.relationship.MemberNameResolver;
import org.benf.cfr.reader.state.ClassFileSourceImpl;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.util.AnalysisType;
import org.benf.cfr.reader.util.CannotLoadClassException;
import org.benf.cfr.reader.util.ConfusedCFRException;
import org.benf.cfr.reader.util.Functional;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.MiscUtils;
import org.benf.cfr.reader.util.Predicate;
import org.benf.cfr.reader.util.getopt.GetOptParser;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.output.Dumper;
import org.benf.cfr.reader.util.output.DumperFactory;
import org.benf.cfr.reader.util.output.DumperFactoryImpl;
import org.benf.cfr.reader.util.output.IllegalIdentifierDump;
import org.benf.cfr.reader.util.output.NopSummaryDumper;
import org.benf.cfr.reader.util.output.ProgressDumper;
import org.benf.cfr.reader.util.output.SummaryDumper;
import org.benf.cfr.reader.util.output.ToStringDumper;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doClass(DCCommonState dcCommonState, String path, boolean skipInnerClass, DumperFactory dumperFactory) {
        Options options = dcCommonState.getOptions();
        IllegalIdentifierDump illegalIdentifierDump = IllegalIdentifierDump.Factory.get(options);
        Dumper d = new ToStringDumper();
        try {
            NopSummaryDumper summaryDumper = new NopSummaryDumper();
            ClassFile c = dcCommonState.getClassFileMaybePath(path);
            if (skipInnerClass && c.isInnerClass()) {
                return;
            }
            dcCommonState.configureWith(c);
            dumperFactory.getProgressDumper().analysingType(c.getClassType());
            try {
                c = dcCommonState.getClassFile(c.getClassType());
            }
            catch (CannotLoadClassException e) {
                // empty catch block
            }
            if (((Boolean)options.getOption(OptionsImpl.DECOMPILE_INNER_CLASSES)).booleanValue()) {
                c.loadInnerClasses(dcCommonState);
            }
            if (((Boolean)options.getOption(OptionsImpl.RENAME_DUP_MEMBERS)).booleanValue()) {
                MemberNameResolver.resolveNames(dcCommonState, ListFactory.newList(dcCommonState.getClassCache().getLoadedTypes()));
            }
            c.analyseTop(dcCommonState);
            TypeUsageCollector collectingDumper = new TypeUsageCollector(c);
            c.collectTypeUsages(collectingDumper);
            d = dumperFactory.getNewTopLevelDumper(c.getClassType(), summaryDumper, collectingDumper.getTypeUsageInformation(), illegalIdentifierDump);
            String methname = (String)options.getOption(OptionsImpl.METHODNAME);
            if (methname == null) {
                c.dump(d);
            } else {
                try {
                    for (Method method : c.getMethodByName(methname)) {
                        method.dump(d, true);
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException(OooOO0OO.OooOOoo0oo("71501F4C4A5C571F525A4B57505B1F18") + methname + OooOO0OO.OooOOoo0oo("1811"));
                }
            }
            d.print("");
        }
        catch (ConfusedCFRException e) {
            System.err.println(e.toString());
            for (StackTraceElement x : e.getStackTrace()) {
                System.err.println(x);
            }
        }
        catch (CannotLoadClassException e) {
            System.out.println(OooOO0OO.OooOOoo0oo("7C5E51184B1F53505E5B1F4B575A1F5C535E4C4C1F4C4F5A5C5659565A5B05"));
            System.out.println(e.toString());
        }
        catch (RuntimeException e) {
            System.err.println(e.toString());
            for (StackTraceElement x : e.getStackTrace()) {
                System.err.println(x);
            }
        }
        finally {
            if (d != null) {
                d.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doJar(DCCommonState dcCommonState, String path, DumperFactory dumperFactory) {
        Options options = dcCommonState.getOptions();
        IllegalIdentifierDump illegalIdentifierDump = IllegalIdentifierDump.Factory.get(options);
        SummaryDumper summaryDumper = null;
        boolean silent = true;
        try {
            final Predicate<String> matcher = MiscUtils.mkRegexFilter((String)options.getOption(OptionsImpl.JAR_FILTER), true);
            silent = (Boolean)options.getOption(OptionsImpl.SILENT);
            summaryDumper = dumperFactory.getSummaryDumper();
            summaryDumper.notify(OooOO0OO.OooOOoo0oo("6C4A52525E4D461F59504D1F") + path);
            summaryDumper.notify(OooOO0OO.OooOOoo0oo("7C796DDAB0B2D883A9D790AE1F0F600E0C0D"));
            if (!silent) {
                System.err.println(OooOO0OO.OooOOoo0oo("6F4D505C5A4C4C5651581F") + path + OooOO0OO.OooOOoo0oo("1F174A4C5A1F") + OptionsImpl.SILENT.getName() + OooOO0OO.OooOOoo0oo("1F4B501F4C56535A515C5A16"));
            }
            List<JavaTypeInstance> types = dcCommonState.explicitlyLoadJar(path);
            types = Functional.filter(types, new Predicate<JavaTypeInstance>(){

                @Override
                public boolean test(JavaTypeInstance in) {
                    return matcher.test(in.getRawName());
                }
            });
            if (((Boolean)options.getOption(OptionsImpl.RENAME_DUP_MEMBERS)).booleanValue() || ((Boolean)options.getOption(OptionsImpl.RENAME_ENUM_MEMBERS)).booleanValue()) {
                MemberNameResolver.resolveNames(dcCommonState, types);
            }
            ProgressDumper progressDumper = dumperFactory.getProgressDumper();
            for (JavaTypeInstance type : types) {
                Dumper d = new ToStringDumper();
                try {
                    ClassFile c = dcCommonState.getClassFile(type);
                    if (c.isInnerClass()) {
                        d = null;
                        continue;
                    }
                    if (!silent) {
                        progressDumper.analysingType(type);
                    }
                    if (((Boolean)options.getOption(OptionsImpl.DECOMPILE_INNER_CLASSES)).booleanValue()) {
                        c.loadInnerClasses(dcCommonState);
                    }
                    c.analyseTop(dcCommonState);
                    TypeUsageCollector collectingDumper = new TypeUsageCollector(c);
                    c.collectTypeUsages(collectingDumper);
                    d = dumperFactory.getNewTopLevelDumper(c.getClassType(), summaryDumper, collectingDumper.getTypeUsageInformation(), illegalIdentifierDump);
                    c.dump(d);
                    d.print("\n");
                    d.print("\n");
                }
                catch (Dumper.CannotCreate e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    d.print(e.toString()).print("\n").print("\n").print("\n");
                }
                finally {
                    if (d == null) continue;
                    d.close();
                }
            }
        }
        catch (RuntimeException e) {
            String err = OooOO0OO.OooOOoo0oo("7A475C5A4F4B5650511F5E515E53464C5651581F555E4D1F") + e;
            System.err.println(err);
            if (summaryDumper != null) {
                summaryDumper.notify(err);
            }
        }
        finally {
            if (summaryDumper != null) {
                summaryDumper.NotifyAdditionalAtEnd();
                summaryDumper.close();
            }
        }
    }

    public static void main(String[] args) {
        GetOptParser getOptParser = new GetOptParser();
        Options options = null;
        List<String> files = null;
        try {
            Pair<List<String>, Options> processedArgs = getOptParser.parse(args, OptionsImpl.getFactory());
            files = processedArgs.getFirst();
            options = processedArgs.getSecond();
        }
        catch (Exception e) {
            getOptParser.showHelp(OptionsImpl.getFactory(), e);
            System.exit(1);
        }
        if (options.optionIsSet(OptionsImpl.HELP) || files.isEmpty()) {
            getOptParser.showOptionHelp(OptionsImpl.getFactory(), options, OptionsImpl.HELP);
            return;
        }
        ClassFileSourceImpl classFileSource = new ClassFileSourceImpl(options);
        boolean skipInnerClass = files.size() > 1 && (Boolean)options.getOption(OptionsImpl.SKIP_BATCH_INNER_CLASSES) != false;
        Collections.sort(files);
        for (String path : files) {
            classFileSource.clearConfiguration();
            DCCommonState dcCommonState = new DCCommonState(options, classFileSource);
            DumperFactoryImpl dumperFactory = new DumperFactoryImpl(options);
            path = classFileSource.adjustInputPath(path);
            AnalysisType type = (AnalysisType)((Object)options.getOption(OptionsImpl.ANALYSE_AS));
            if (type == null) {
                type = dcCommonState.detectClsJar(path);
            }
            if (type == AnalysisType.JAR) {
                Main.doJar(dcCommonState, path, dumperFactory);
            }
            if (type != AnalysisType.CLASS) continue;
            Main.doClass(dcCommonState, path, skipInnerClass, dumperFactory);
        }
    }
}

