/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.iff;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.monte.media.AbortException;
import org.monte.media.ParseException;
import org.monte.media.iff.IFFChunk;
import org.monte.media.iff.IFFVisitor;
import org.monte.media.iff.MC68000InputStream;

public class IFFParser {
    public static final int ID_FORM = 1179603533;
    public static final int ID_CAT = 1128354848;
    public static final int ID_LIST = 1279873876;
    public static final int ID_PROP = 1347571536;
    public static final int ID_FILLER = 0x20202020;
    public static final int[] RESERVED_IDs = new int[]{1279873876, 1179603533, 1347571536, 1128354848, 0x20202020, 1279873841, 1279873842, 1279873843, 1279873844, 1279873845, 1279873846, 1279873847, 1279873848, 1279873849, 1179603505, 1179603506, 1179603507, 1179603508, 1179603509, 1179603510, 1179603511, 1179603512, 1179603513, 1128354865, 1128354866, 1128354867, 1128354868, 1128354869, 1128354870, 1128354871, 1128354872, 1128354873};
    private IFFVisitor visitor;
    private Hashtable<IFFChunk, IFFChunk> dataChunks;
    private Hashtable<IFFChunk, IFFChunk> propertyChunks;
    private Hashtable<IFFChunk, IFFChunk> collectionChunks;
    private Hashtable<Integer, IFFChunk> groupChunks;
    private MC68000InputStream in;

    public void parse(InputStream in, IFFVisitor v) throws ParseException, AbortException, IOException {
        this.in = new MC68000InputStream(new BufferedInputStream(in));
        this.visitor = v;
        this.parseFile();
    }

    private void parseFile() throws ParseException, AbortException, IOException {
        int id = this.in.readLONG();
        switch (id) {
            case 1179603533: {
                this.parseFORM(null);
                break;
            }
            case 1128354848: {
                this.parseCAT(null);
                break;
            }
            case 1279873876: {
                this.parseLIST(null);
                break;
            }
            default: {
                throw new ParseException("IFF-85 files must start with 'FORM', 'CAT ', or 'LIST'. But not with: '" + IFFParser.idToString(id) + "'");
            }
        }
    }

    private void parseFORM(Hashtable props) throws ParseException, AbortException, IOException {
        long size = this.in.readULONG();
        long scan = this.in.getScan();
        int type = this.in.readLONG();
        if (!IFFParser.isFormType(type)) {
            throw new ParseException("Invalid Form Type: " + IFFParser.idToString(type));
        }
        IFFChunk propGroup = props == null ? null : (IFFChunk)props.get(new Integer(type));
        IFFChunk chunk = new IFFChunk(type, 1179603533, size, scan, propGroup);
        if (this.isGroupChunk(chunk)) {
            this.visitor.enterGroup(chunk);
        }
        long finish = scan + size;
        try {
            while (this.in.getScan() < finish) {
                long idscan = this.in.getScan();
                int id = this.in.readLONG();
                switch (id) {
                    case 1179603533: {
                        this.parseFORM(props);
                        break;
                    }
                    case 1128354848: {
                        this.parseCAT(props);
                        break;
                    }
                    case 1279873876: {
                        this.parseLIST(props);
                        break;
                    }
                    default: {
                        if (IFFParser.isLocalChunkID(id)) {
                            this.parseLocalChunk(chunk, id);
                            break;
                        }
                        throw new ParseException("Invalid IFFChunk within FORM: " + IFFParser.idToString(id) + " at offset:" + idscan);
                    }
                }
                this.in.align();
            }
        }
        catch (EOFException e) {
            System.err.println("Unexpected EOF after:" + (this.in.getScan() - scan) + " should be:" + size);
            e.printStackTrace();
        }
        if (this.isGroupChunk(chunk)) {
            this.visitor.leaveGroup(chunk);
        }
    }

    private void parseCAT(Hashtable props) throws ParseException, AbortException, IOException {
        long size = this.in.readULONG();
        long scan = this.in.getScan();
        int type = this.in.readLONG();
        if (!IFFParser.isContentType(type)) {
            throw new ParseException("Invalid Content Type: " + IFFParser.idToString(type));
        }
        IFFChunk propGroup = props == null ? null : (IFFChunk)props.get(new Integer(type));
        IFFChunk chunk = new IFFChunk(type, 1128354848, size, scan, propGroup);
        if (this.isGroupChunk(chunk)) {
            this.visitor.enterGroup(chunk);
        }
        long finish = scan + size;
        while (this.in.getScan() < finish) {
            int id = this.in.readLONG();
            switch (id) {
                case 1179603533: {
                    this.parseFORM(props);
                    break;
                }
                case 1128354848: {
                    this.parseCAT(props);
                    break;
                }
                case 1279873876: {
                    this.parseLIST(props);
                    break;
                }
                default: {
                    throw new ParseException("Invalid IFFChunk within CAT: " + IFFParser.idToString(id));
                }
            }
            this.in.align();
        }
        if (this.isGroupChunk(chunk)) {
            this.visitor.leaveGroup(chunk);
        }
    }

    private void parseLIST(Hashtable props) throws ParseException, AbortException, IOException {
        long size = this.in.readULONG();
        long scan = this.in.getScan();
        int type = this.in.readLONG();
        if (!IFFParser.isFormType(type)) {
            throw new ParseException("Invalid Form Type: " + IFFParser.idToString(type));
        }
        IFFChunk propGroup = props == null ? null : (IFFChunk)props.get(new Integer(type));
        IFFChunk chunk = new IFFChunk(type, 1279873876, size, scan, propGroup);
        if (this.isGroupChunk(chunk)) {
            this.visitor.enterGroup(chunk);
        }
        props = new Hashtable<Integer, IFFChunk>();
        long finish = scan + size;
        while (this.in.getScan() < finish) {
            int id = this.in.readLONG();
            switch (id) {
                case 1179603533: {
                    this.parseFORM(props);
                    break;
                }
                case 1128354848: {
                    this.parseCAT(props);
                    break;
                }
                case 1279873876: {
                    this.parseLIST(props);
                    break;
                }
                case 1347571536: {
                    IFFChunk prop = this.parsePROP();
                    props.put(new Integer(prop.getType()), prop);
                    break;
                }
                default: {
                    if (IFFParser.isLocalChunkID(id)) {
                        this.parseLocalChunk(chunk, id);
                        break;
                    }
                    throw new ParseException("Invalid IFFChunk ID within LIST: " + IFFParser.idToString(id));
                }
            }
            this.in.align();
        }
        if (this.isGroupChunk(chunk)) {
            this.visitor.leaveGroup(chunk);
        }
    }

    private IFFChunk parsePROP() throws ParseException, AbortException, IOException {
        long size = this.in.readULONG();
        long scan = this.in.getScan();
        int type = this.in.readLONG();
        if (!IFFParser.isFormType(type)) {
            throw new ParseException("Invalid Form Type: " + IFFParser.idToString(type));
        }
        IFFChunk chunk = new IFFChunk(type, 1347571536, size, scan);
        if (this.isGroupChunk(chunk)) {
            this.visitor.enterGroup(chunk);
        }
        long finish = scan + size;
        while (this.in.getScan() < finish) {
            int id = this.in.readLONG();
            if (!IFFParser.isLocalChunkID(id)) {
                throw new ParseException("Invalid IFFChunk ID within PROP: " + IFFParser.idToString(id));
            }
            this.parseLocalChunk(chunk, id);
            this.in.align();
        }
        if (this.isGroupChunk(chunk)) {
            this.visitor.leaveGroup(chunk);
        }
        return chunk;
    }

    private void parseLocalChunk(IFFChunk parent, int id) throws ParseException, AbortException, IOException {
        long size = this.in.readULONG();
        long scan = this.in.getScan();
        IFFChunk chunk = new IFFChunk(parent.getType(), id, size, scan);
        if (this.isDataChunk(chunk)) {
            byte[] data = new byte[(int)size];
            this.in.read(data, 0, (int)size);
            chunk.setData(data);
            this.visitor.visitChunk(parent, chunk);
        } else if (this.isPropertyChunk(chunk)) {
            byte[] data = new byte[(int)size];
            this.in.read(data, 0, (int)size);
            chunk.setData(data);
            parent.putPropertyChunk(chunk);
        } else if (this.isCollectionChunk(chunk)) {
            byte[] data = new byte[(int)size];
            this.in.read(data, 0, (int)size);
            chunk.setData(data);
            parent.addCollectionChunk(chunk);
        } else if (size > 0L) {
            this.in.skipFully((int)size);
        }
    }

    protected boolean isDataChunk(IFFChunk chunk) {
        if (this.dataChunks == null) {
            return this.collectionChunks == null && this.propertyChunks == null;
        }
        return this.dataChunks.containsKey(chunk);
    }

    protected boolean isGroupChunk(IFFChunk chunk) {
        if (this.groupChunks == null) {
            return true;
        }
        return this.groupChunks.containsKey(new Integer(chunk.getID()));
    }

    protected boolean isPropertyChunk(IFFChunk chunk) {
        if (this.propertyChunks == null) {
            return false;
        }
        return this.propertyChunks.containsKey(chunk);
    }

    protected boolean isCollectionChunk(IFFChunk chunk) {
        if (this.collectionChunks == null) {
            return false;
        }
        return this.collectionChunks.containsKey(chunk);
    }

    public void declareDataChunk(int type, int id) {
        IFFChunk chunk = new IFFChunk(type, id);
        if (this.dataChunks == null) {
            this.dataChunks = new Hashtable();
        }
        this.dataChunks.put(chunk, chunk);
    }

    public void declareGroupChunk(int type, int id) {
        IFFChunk chunk = new IFFChunk(type, id);
        if (this.groupChunks == null) {
            this.groupChunks = new Hashtable();
        }
        this.groupChunks.put(new Integer(id), chunk);
    }

    public void declarePropertyChunk(int type, int id) {
        IFFChunk chunk = new IFFChunk(type, id);
        if (this.propertyChunks == null) {
            this.propertyChunks = new Hashtable();
        }
        this.propertyChunks.put(chunk, chunk);
    }

    public void declareCollectionChunk(int type, int id) {
        IFFChunk chunk = new IFFChunk(type, id);
        if (this.collectionChunks == null) {
            this.collectionChunks = new Hashtable();
        }
        this.collectionChunks.put(chunk, chunk);
    }

    public static boolean isGroupID(int id) {
        return id == 1179603533 || id == 1128354848 || id == 1279873876 || id == 1347571536;
    }

    public static boolean isID(int id) {
        int value1 = id >> 24;
        int value2 = id >> 16 & 0xFF;
        int value3 = id >> 8 & 0xFF;
        int value4 = id & 0xFF;
        if (value1 < 32 || value1 > 126 || value2 < 32 || value2 > 126 || value3 < 32 || value3 > 126 || value4 < 32 || value4 > 126) {
            return false;
        }
        return id == 0x20202020 || value1 != 32;
    }

    public static boolean isLocalChunkID(int id) {
        if (id == 0x20202020) {
            return false;
        }
        if (IFFParser.isGroupID(id)) {
            return false;
        }
        return IFFParser.isID(id);
    }

    public static boolean isReservedID(int id) {
        int i = 0;
        while (i < RESERVED_IDs.length) {
            if (id == RESERVED_IDs[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isFormType(int id) {
        if (IFFParser.isReservedID(id)) {
            return false;
        }
        int value1 = id >> 24;
        int value2 = id >> 16 & 0xFF;
        int value3 = id >> 8 & 0xFF;
        int value4 = id & 0xFF;
        if (value1 < 48 || value1 > 90 || value1 > 73 && value1 < 65 || value2 < 48 && value2 != 32 || value2 > 90 || value2 > 73 && value2 < 65 || value3 < 48 && value3 != 32 || value3 > 90 || value3 > 73 && value3 < 65 || value4 < 48 && value4 != 32 || value4 > 90 || value4 > 73 && value4 < 65) {
            return false;
        }
        return !IFFParser.isGroupID(id);
    }

    public static boolean isContentType(int id) {
        if (id == 0x20202020) {
            return true;
        }
        return IFFParser.isFormType(id);
    }

    public static String idToString(int anID) {
        byte[] bytes = new byte[]{(byte)(anID >>> 24), (byte)(anID >>> 16), (byte)(anID >>> 8), (byte)(anID >>> 0)};
        return new String(bytes);
    }

    public static int stringToID(String aString) {
        byte[] bytes = aString.getBytes();
        return bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3] << 0;
    }
}

