/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.eightsvx;

import java.io.IOException;
import java.io.OutputStream;
import org.monte.media.eightsvx.JDK10AudioClip;
import org.monte.media.eightsvx.JDK13LongAudioClip;
import org.monte.media.eightsvx.JDK13ShortAudioClip;
import org.monte.media.eightsvx.LoopableAudioClip;

public class EightSVXAudioClip
implements LoopableAudioClip {
    private String name_ = "";
    private String author_ = "";
    private String copyright_ = "";
    private String remark_ = "";
    private byte[] body_;
    private long oneShotHiSamples_;
    private long repeatHiSamples_;
    private long samplesPerHiCycle_;
    private int sampleRate_;
    private int ctOctave_;
    public static final int S_CMP_NONE = 0;
    public static final int S_CMP_FIB_DELTA = 1;
    private int sCompression_;
    private static final double UNITY = 65536.0;
    private int volume_;
    private LoopableAudioClip cachedAudioClip_;
    private int cachedSampleRate_;
    public static final int RIGHT = 4;
    public static final int LEFT = 2;
    public static final int STEREO = 6;
    private int sampleType_;
    private static Boolean javaxAudioIsPresent;
    private static final byte[] CODE_TO_DELTA;
    private static final boolean ZEROTRAP = true;
    private static final short BIAS = 132;
    private static final int CLIP = 32635;
    private static final int[] exp_lut1;

    static {
        byte[] byArray = new byte[16];
        byArray[0] = -34;
        byArray[1] = -21;
        byArray[2] = -13;
        byArray[3] = -8;
        byArray[4] = -5;
        byArray[5] = -3;
        byArray[6] = -2;
        byArray[7] = -1;
        byArray[9] = 1;
        byArray[10] = 2;
        byArray[11] = 3;
        byArray[12] = 5;
        byArray[13] = 8;
        byArray[14] = 13;
        byArray[15] = 21;
        CODE_TO_DELTA = byArray;
        int[] nArray = new int[256];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 3;
        nArray[16] = 4;
        nArray[17] = 4;
        nArray[18] = 4;
        nArray[19] = 4;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 4;
        nArray[23] = 4;
        nArray[24] = 4;
        nArray[25] = 4;
        nArray[26] = 4;
        nArray[27] = 4;
        nArray[28] = 4;
        nArray[29] = 4;
        nArray[30] = 4;
        nArray[31] = 4;
        nArray[32] = 5;
        nArray[33] = 5;
        nArray[34] = 5;
        nArray[35] = 5;
        nArray[36] = 5;
        nArray[37] = 5;
        nArray[38] = 5;
        nArray[39] = 5;
        nArray[40] = 5;
        nArray[41] = 5;
        nArray[42] = 5;
        nArray[43] = 5;
        nArray[44] = 5;
        nArray[45] = 5;
        nArray[46] = 5;
        nArray[47] = 5;
        nArray[48] = 5;
        nArray[49] = 5;
        nArray[50] = 5;
        nArray[51] = 5;
        nArray[52] = 5;
        nArray[53] = 5;
        nArray[54] = 5;
        nArray[55] = 5;
        nArray[56] = 5;
        nArray[57] = 5;
        nArray[58] = 5;
        nArray[59] = 5;
        nArray[60] = 5;
        nArray[61] = 5;
        nArray[62] = 5;
        nArray[63] = 5;
        nArray[64] = 6;
        nArray[65] = 6;
        nArray[66] = 6;
        nArray[67] = 6;
        nArray[68] = 6;
        nArray[69] = 6;
        nArray[70] = 6;
        nArray[71] = 6;
        nArray[72] = 6;
        nArray[73] = 6;
        nArray[74] = 6;
        nArray[75] = 6;
        nArray[76] = 6;
        nArray[77] = 6;
        nArray[78] = 6;
        nArray[79] = 6;
        nArray[80] = 6;
        nArray[81] = 6;
        nArray[82] = 6;
        nArray[83] = 6;
        nArray[84] = 6;
        nArray[85] = 6;
        nArray[86] = 6;
        nArray[87] = 6;
        nArray[88] = 6;
        nArray[89] = 6;
        nArray[90] = 6;
        nArray[91] = 6;
        nArray[92] = 6;
        nArray[93] = 6;
        nArray[94] = 6;
        nArray[95] = 6;
        nArray[96] = 6;
        nArray[97] = 6;
        nArray[98] = 6;
        nArray[99] = 6;
        nArray[100] = 6;
        nArray[101] = 6;
        nArray[102] = 6;
        nArray[103] = 6;
        nArray[104] = 6;
        nArray[105] = 6;
        nArray[106] = 6;
        nArray[107] = 6;
        nArray[108] = 6;
        nArray[109] = 6;
        nArray[110] = 6;
        nArray[111] = 6;
        nArray[112] = 6;
        nArray[113] = 6;
        nArray[114] = 6;
        nArray[115] = 6;
        nArray[116] = 6;
        nArray[117] = 6;
        nArray[118] = 6;
        nArray[119] = 6;
        nArray[120] = 6;
        nArray[121] = 6;
        nArray[122] = 6;
        nArray[123] = 6;
        nArray[124] = 6;
        nArray[125] = 6;
        nArray[126] = 6;
        nArray[127] = 6;
        nArray[128] = 7;
        nArray[129] = 7;
        nArray[130] = 7;
        nArray[131] = 7;
        nArray[132] = 7;
        nArray[133] = 7;
        nArray[134] = 7;
        nArray[135] = 7;
        nArray[136] = 7;
        nArray[137] = 7;
        nArray[138] = 7;
        nArray[139] = 7;
        nArray[140] = 7;
        nArray[141] = 7;
        nArray[142] = 7;
        nArray[143] = 7;
        nArray[144] = 7;
        nArray[145] = 7;
        nArray[146] = 7;
        nArray[147] = 7;
        nArray[148] = 7;
        nArray[149] = 7;
        nArray[150] = 7;
        nArray[151] = 7;
        nArray[152] = 7;
        nArray[153] = 7;
        nArray[154] = 7;
        nArray[155] = 7;
        nArray[156] = 7;
        nArray[157] = 7;
        nArray[158] = 7;
        nArray[159] = 7;
        nArray[160] = 7;
        nArray[161] = 7;
        nArray[162] = 7;
        nArray[163] = 7;
        nArray[164] = 7;
        nArray[165] = 7;
        nArray[166] = 7;
        nArray[167] = 7;
        nArray[168] = 7;
        nArray[169] = 7;
        nArray[170] = 7;
        nArray[171] = 7;
        nArray[172] = 7;
        nArray[173] = 7;
        nArray[174] = 7;
        nArray[175] = 7;
        nArray[176] = 7;
        nArray[177] = 7;
        nArray[178] = 7;
        nArray[179] = 7;
        nArray[180] = 7;
        nArray[181] = 7;
        nArray[182] = 7;
        nArray[183] = 7;
        nArray[184] = 7;
        nArray[185] = 7;
        nArray[186] = 7;
        nArray[187] = 7;
        nArray[188] = 7;
        nArray[189] = 7;
        nArray[190] = 7;
        nArray[191] = 7;
        nArray[192] = 7;
        nArray[193] = 7;
        nArray[194] = 7;
        nArray[195] = 7;
        nArray[196] = 7;
        nArray[197] = 7;
        nArray[198] = 7;
        nArray[199] = 7;
        nArray[200] = 7;
        nArray[201] = 7;
        nArray[202] = 7;
        nArray[203] = 7;
        nArray[204] = 7;
        nArray[205] = 7;
        nArray[206] = 7;
        nArray[207] = 7;
        nArray[208] = 7;
        nArray[209] = 7;
        nArray[210] = 7;
        nArray[211] = 7;
        nArray[212] = 7;
        nArray[213] = 7;
        nArray[214] = 7;
        nArray[215] = 7;
        nArray[216] = 7;
        nArray[217] = 7;
        nArray[218] = 7;
        nArray[219] = 7;
        nArray[220] = 7;
        nArray[221] = 7;
        nArray[222] = 7;
        nArray[223] = 7;
        nArray[224] = 7;
        nArray[225] = 7;
        nArray[226] = 7;
        nArray[227] = 7;
        nArray[228] = 7;
        nArray[229] = 7;
        nArray[230] = 7;
        nArray[231] = 7;
        nArray[232] = 7;
        nArray[233] = 7;
        nArray[234] = 7;
        nArray[235] = 7;
        nArray[236] = 7;
        nArray[237] = 7;
        nArray[238] = 7;
        nArray[239] = 7;
        nArray[240] = 7;
        nArray[241] = 7;
        nArray[242] = 7;
        nArray[243] = 7;
        nArray[244] = 7;
        nArray[245] = 7;
        nArray[246] = 7;
        nArray[247] = 7;
        nArray[248] = 7;
        nArray[249] = 7;
        nArray[250] = 7;
        nArray[251] = 7;
        nArray[252] = 7;
        nArray[253] = 7;
        nArray[254] = 7;
        nArray[255] = 7;
        exp_lut1 = nArray;
    }

    protected void setName(String value) {
        this.name_ = value;
    }

    protected String getName() {
        return this.name_;
    }

    protected void setAuthor(String value) {
        this.author_ = value;
    }

    protected String getAuthor() {
        return this.author_;
    }

    protected void setCopyright(String value) {
        this.copyright_ = value;
    }

    protected String getCopyright() {
        return this.copyright_;
    }

    protected void setRemark(String value) {
        this.remark_ = value;
    }

    protected String getRemark() {
        return this.remark_;
    }

    public void set8SVXBody(byte[] value) {
        this.body_ = value;
        this.cachedAudioClip_ = null;
    }

    public byte[] get8SVXBody() {
        return this.body_;
    }

    public void setOneShotHiSamples(long value) {
        this.oneShotHiSamples_ = value;
    }

    public void setRepeatHiSamples(long value) {
        this.repeatHiSamples_ = value;
    }

    public void setSamplesPerHiCycle(long value) {
        this.samplesPerHiCycle_ = value;
    }

    public void setSampleType(int value) {
        this.sampleType_ = value;
    }

    public void setSampleRate(int value) {
        this.sampleRate_ = value;
    }

    public void setCtOctave(int value) {
        this.ctOctave_ = value;
    }

    public void setSCompression(int value) {
        this.sCompression_ = value;
    }

    public void setVolume(int value) {
        this.volume_ = value;
    }

    public long getOneShotHiSamples() {
        return this.oneShotHiSamples_;
    }

    public long getRepeatHiSamples() {
        return this.repeatHiSamples_;
    }

    public long getSamplesPerHiCycle() {
        return this.samplesPerHiCycle_;
    }

    public long getSampleType() {
        return this.sampleType_;
    }

    public int getSampleRate() {
        return this.sampleRate_;
    }

    public int getCtOctave() {
        return this.ctOctave_;
    }

    public int getVolume() {
        return this.volume_;
    }

    public int getSCompression() {
        return this.sCompression_;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.getName().length() == 0) {
            buf.append("<unnamed>");
        } else {
            buf.append(this.getName());
        }
        if (this.getAuthor().length() != 0) {
            buf.append(", ");
            buf.append(this.getAuthor());
        }
        if (this.getCopyright().length() != 0) {
            buf.append(", \ufffd ");
            buf.append(this.getCopyright());
        }
        buf.append(' ');
        buf.append(Integer.toString(this.getSampleRate()));
        buf.append(" Hz");
        return buf.toString();
    }

    public LoopableAudioClip createAudioClip() {
        return this.createAudioClip(this.getSampleRate(), this.volume_, 0.0f);
    }

    public LoopableAudioClip createAudioClip(int sampleRate, int volume, float pan) {
        if (javaxAudioIsPresent == null || javaxAudioIsPresent == Boolean.TRUE) {
            try {
                LoopableAudioClip clip = this.createJDK13AudioClip(sampleRate, volume, pan);
                javaxAudioIsPresent = Boolean.TRUE;
                return clip;
            }
            catch (Throwable t) {
                t.printStackTrace();
                javaxAudioIsPresent = Boolean.FALSE;
            }
        }
        return this.createJDK10AudioClip(sampleRate);
    }

    public LoopableAudioClip createJDK13AudioClip(int sampleRate, int volume, float pan) {
        byte[] samples;
        Object audioClip = null;
        if (this.sCompression_ == 1) {
            this.body_ = EightSVXAudioClip.unpackFibonacciDeltaCompression(this.body_);
            this.sCompression_ = 0;
        }
        if (this.sampleType_ == 6) {
            double volumeCorrection = EightSVXAudioClip.computeStereoVolumeCorrection(this.body_);
            this.body_ = EightSVXAudioClip.linear8StereoToMono(this.body_, volumeCorrection);
            this.sampleType_ = 2;
        }
        if ((samples = this.get8SVXBody()).length > 1000000) {
            return new JDK13LongAudioClip(samples, sampleRate, volume, pan);
        }
        return new JDK13ShortAudioClip(samples, sampleRate, volume, pan);
    }

    public LoopableAudioClip createJDK10AudioClip(int sampleRate) {
        Object audioClip = null;
        if (this.sCompression_ == 1) {
            this.body_ = EightSVXAudioClip.unpackFibonacciDeltaCompression(this.body_);
            this.sCompression_ = 0;
        }
        if (this.sampleType_ == 6) {
            double volumeCorrection = EightSVXAudioClip.computeStereoVolumeCorrection(this.body_);
            this.body_ = EightSVXAudioClip.linear8StereoToMono(this.body_, volumeCorrection);
            this.sampleType_ = 2;
        }
        byte[] samples = this.get8SVXBody();
        samples = EightSVXAudioClip.resample(samples, sampleRate, 8000);
        samples = EightSVXAudioClip.linear8ToULaw(samples);
        return new JDK10AudioClip(samples, 8000);
    }

    @Override
    public void play() {
        this.stop();
        if (this.cachedAudioClip_ == null) {
            this.cachedAudioClip_ = this.createAudioClip();
        }
        this.cachedAudioClip_.play();
    }

    @Override
    public void loop() {
        this.stop();
        if (this.cachedAudioClip_ == null) {
            this.cachedAudioClip_ = this.createAudioClip();
        }
        this.cachedAudioClip_.loop();
    }

    @Override
    public void stop() {
        if (this.cachedAudioClip_ != null) {
            this.cachedAudioClip_.stop();
        }
    }

    public void prepare() {
        if (this.cachedAudioClip_ == null) {
            this.cachedAudioClip_ = this.createAudioClip();
        }
    }

    public static double computeStereoVolumeCorrection(byte[] stereo) {
        int half = stereo.length / 2;
        int max = 0;
        int i = 0;
        while (i < half) {
            max = Math.max(max, Math.abs(stereo[i] + stereo[half + i]));
            ++i;
        }
        if (max < 128) {
            return 1.0;
        }
        return 128.0 / (double)max;
    }

    public static byte[] linear8StereoToMono(byte[] stereo, double volumeCorrection) {
        int half = stereo.length / 2;
        byte[] mono = new byte[half];
        int i = 0;
        while (i < half) {
            mono[i] = (byte)((double)(stereo[i] + stereo[half + i]) * volumeCorrection);
            ++i;
        }
        return mono;
    }

    public static byte[] resample(byte[] input, int inputSampleRate, int outputSampleRate) {
        if (inputSampleRate == outputSampleRate) {
            return input;
        }
        if (inputSampleRate > outputSampleRate) {
            float factor = (float)inputSampleRate / (float)outputSampleRate;
            byte[] output = new byte[(int)Math.floor((float)input.length / factor)];
            int i = 0;
            while (i < output.length) {
                output[i] = input[(int)((float)i * factor)];
                ++i;
            }
            return output;
        }
        float factor = (float)inputSampleRate / (float)outputSampleRate;
        byte[] output = new byte[(int)Math.ceil((float)input.length / factor)];
        int i = 0;
        while (i < output.length) {
            output[i] = input[(int)((float)i * factor)];
            ++i;
        }
        return output;
    }

    public static byte[] linear8ToULaw(byte[] linear8) {
        byte[] ulaw = new byte[linear8.length];
        int i = 0;
        while (i < linear8.length) {
            ulaw[i] = EightSVXAudioClip.linear16ToULaw(linear8[i] << 8);
            ++i;
        }
        return ulaw;
    }

    public static byte[] linear16ToULaw(int[] linear16) {
        byte[] ulaw = new byte[linear16.length];
        int i = 0;
        while (i < linear16.length) {
            ulaw[i] = EightSVXAudioClip.linear16ToULaw(linear16[i]);
            ++i;
        }
        return ulaw;
    }

    public static byte[] unpackFibonacciDeltaCompression(byte[] source) {
        int n = source.length - 2;
        int lim = n * 2;
        byte[] dest = new byte[lim];
        int x = source[1];
        int i = 0;
        int j = 2;
        while (j < n) {
            byte d = source[j];
            dest[i++] = (byte)(x += CODE_TO_DELTA[d >> 4 & 0xF]);
            dest[i++] = (byte)(x += CODE_TO_DELTA[d & 0xF]);
            ++j;
        }
        return dest;
    }

    public static void writeSunAudioHeader(OutputStream outfile, int dataSize, int sampleRate, int sampleType) throws IOException {
        EightSVXAudioClip.wrulong(outfile, 779316836);
        EightSVXAudioClip.wrulong(outfile, 24);
        EightSVXAudioClip.wrulong(outfile, dataSize);
        EightSVXAudioClip.wrulong(outfile, 1);
        EightSVXAudioClip.wrulong(outfile, sampleRate);
        EightSVXAudioClip.wrulong(outfile, sampleType == 6 ? 2 : 1);
    }

    public static void wrulong(OutputStream outfile, int ulong) throws IOException {
        outfile.write(ulong >> 24 & 0xFF);
        outfile.write(ulong >> 16 & 0xFF);
        outfile.write(ulong >> 8 & 0xFF);
        outfile.write(ulong >> 0 & 0xFF);
    }

    private static byte linear16ToULaw(int sample) {
        int mantissa;
        int exponent;
        int ulawbyte;
        if (sample > Short.MAX_VALUE) {
            sample = Short.MAX_VALUE;
        } else if (sample < Short.MIN_VALUE) {
            sample = Short.MIN_VALUE;
        }
        int sign = sample >> 8 & 0x80;
        if (sign != 0) {
            sample = -sample;
        }
        if (sample > 32635) {
            sample = 32635;
        }
        if ((ulawbyte = ~(sign | (exponent = exp_lut1[(sample += 132) >> 7 & 0xFF]) << 4 | (mantissa = sample >> exponent + 3 & 0xF))) == 0) {
            ulawbyte = 2;
        }
        return (byte)ulawbyte;
    }

    @Override
    public void loop(int count) {
        this.stop();
        if (this.cachedAudioClip_ == null) {
            this.cachedAudioClip_ = this.createAudioClip();
        }
        this.cachedAudioClip_.loop(count);
    }
}

