/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.nio.ByteOrder;
import org.monte.media.AudioFormatKeys;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;

public class FormatFormatter {
    private static String audioToString(Format f) {
        StringBuilder buf = new StringBuilder();
        buf.append(f.get(FormatKeys.EncodingKey).equals("\u0000\u0000\u0000\u0001") ? "PCM" : f.get(FormatKeys.EncodingKey)).append(", ").append(f.get(AudioFormatKeys.ChannelsKey)).append(" channel(s)").append(", ").append(f.get(AudioFormatKeys.SampleSizeInBitsKey)).append("-bit").append(f.get(AudioFormatKeys.SignedKey) != false ? " signed" : " unsigned").append(f.get(AudioFormatKeys.ByteOrderKey) == ByteOrder.BIG_ENDIAN ? " BE" : " LE").append(", ").append(f.get(AudioFormatKeys.SampleRateKey)).append(" Hz, ").append("");
        return buf.toString();
    }

    private static String videoToString(Format f) {
        StringBuilder buf = new StringBuilder();
        buf.append(f.get(FormatKeys.EncodingKey)).append(", ").append(f.get(VideoFormatKeys.WidthKey)).append("x").append(f.get(VideoFormatKeys.HeightKey)).append(", ").append(f.get(VideoFormatKeys.DepthKey)).append("-bit, ").append(f.get(FormatKeys.FrameRateKey, new Rational(0L, 0L))).append(" fps").append(f.get(VideoFormatKeys.FixedFrameRateKey, false) != false ? ", fixed rate" : "").append(f.get(VideoFormatKeys.PixelAspectRatioKey, new Rational(1L, 1L)).equals(new Rational(1L, 1L)) ? "" : ", " + f.get(VideoFormatKeys.PixelAspectRatioKey) + " pixel ratio").append("");
        return buf.toString();
    }

    private static String fileToString(Format f) {
        StringBuilder buf = new StringBuilder();
        buf.append(f.get(FormatKeys.MimeTypeKey));
        return buf.toString();
    }

    public static String toString(Format f) {
        switch (f.get(FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO)) {
            case AUDIO: {
                return FormatFormatter.audioToString(f);
            }
            case VIDEO: {
                return FormatFormatter.videoToString(f);
            }
            case FILE: {
                return FormatFormatter.fileToString(f);
            }
        }
        return f.toString();
    }
}

