/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets;

import com.explodingpixels.macwidgets.plaf.ITunesTableUI;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class StripedViewportBorder
extends AbstractBorder
implements ListSelectionListener,
PropertyChangeListener {
    private final JViewport fViewport;
    private final JTable fTable;
    private final Color fStripeColor;

    public StripedViewportBorder(JViewport viewport, JTable table, Color stripeColor) {
        this.fViewport = viewport;
        this.fTable = table;
        this.fStripeColor = stripeColor;
        this.fTable.getSelectionModel().addListSelectionListener(this);
        this.fTable.addPropertyChangeListener(this);
        WindowUtils.installWeakWindowFocusListener(table, this.createWindowFocusListener());
    }

    public StripedViewportBorder(JViewport viewport, JTable table) {
        this(viewport, table, new Color(241, 245, 250));
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintStripedBackground(g, y);
        this.paintVerticalGridLines(g, y, height);
    }

    private void paintStripedBackground(Graphics g, int borderY) {
        Rectangle clip = g.getClipBounds();
        Point viewPosition = this.fViewport.getViewPosition();
        int rowAtPoint = this.fTable.rowAtPoint(viewPosition);
        int topY = rowAtPoint < 0 ? borderY : this.fTable.getCellRect((int)rowAtPoint, (int)0, (boolean)true).y - viewPosition.y + borderY;
        int currentRow = rowAtPoint < 0 ? 0 : rowAtPoint;
        int rowHeight = this.fTable.getRowHeight();
        Border border = null;
        if (this.fTable.getUI() instanceof ITunesTableUI) {
            ITunesTableUI ui = (ITunesTableUI)this.fTable.getUI();
            border = ui.getSelectedRowBorder();
        }
        while (topY < clip.y + clip.height) {
            int bottomY = topY + rowHeight;
            g.setColor(this.getRowColor(currentRow));
            g.fillRect(clip.x, topY, clip.width, rowHeight);
            if (border != null && this.fTable.isRowSelected(currentRow)) {
                border.paintBorder(this.fViewport, g, 0, topY, this.fViewport.getWidth(), this.fTable.getRowHeight());
            }
            topY = bottomY;
            ++currentRow;
        }
    }

    private Color getRowColor(int row) {
        if (this.fTable.isRowSelected(row)) {
            return this.fTable.getSelectionBackground();
        }
        return row % 2 == 0 ? this.fStripeColor : this.fTable.getBackground();
    }

    private void paintVerticalGridLines(Graphics g, int y, int height) {
        int x = 0 - this.fViewport.getViewPosition().x + this.fViewport.getLocation().x;
        g.setColor(this.fTable.getGridColor());
        for (int i = 0; i < this.fTable.getColumnCount(); ++i) {
            TableColumn column = this.fTable.getColumnModel().getColumn(i);
            g.setColor(this.fTable.getGridColor());
            g.drawLine((x += column.getWidth()) - 1, y, x - 1, y + height);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.fViewport.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.fTable)) {
            if (evt.getPropertyName().equals("selectionModel")) {
                ListSelectionModel oldModel = (ListSelectionModel)evt.getOldValue();
                ListSelectionModel newModel = (ListSelectionModel)evt.getNewValue();
                oldModel.removeListSelectionListener(this);
                newModel.addListSelectionListener(this);
            } else if (evt.getPropertyName().equals("selectionBackground")) {
                this.fViewport.repaint();
            }
        }
    }

    private WindowFocusListener createWindowFocusListener() {
        return new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                StripedViewportBorder.this.fViewport.repaint();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                StripedViewportBorder.this.fViewport.repaint();
            }
        };
    }
}

