/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.manager;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.player.manager.MediaManager;

public class DefaultMediaManager
implements MediaManager {
    private final Logger logger = LoggerFactory.getLogger(DefaultMediaManager.class);
    protected final LibVlc libvlc;
    protected final libvlc_instance_t instance;

    public DefaultMediaManager(LibVlc libvlc, libvlc_instance_t instance) {
        this.libvlc = libvlc;
        this.instance = instance;
        this.createInstance();
    }

    @Override
    public boolean addBroadcast(String name, String inputMrl, String outputMrl, boolean enable, boolean loop, String ... options) {
        this.logger.debug("addBrodcast(name={},inputMrl={},outputMrl={},enable={},loop={},options={})", name, inputMrl, outputMrl, enable, loop, Arrays.toString(options));
        return this.libvlc.libvlc_vlm_add_broadcast(this.instance, name, inputMrl, outputMrl, options != null ? options.length : 0, options, enable ? 1 : 0, loop ? 1 : 0) == 0;
    }

    @Override
    public boolean addVideoOnDemand(String name, String inputMrl, boolean enable, String mux, String ... options) {
        this.logger.debug("addVideoOnDemand(name={},inputMrl={},enable={},mux={},options={})", name, inputMrl, enable, mux, Arrays.toString(options));
        return this.libvlc.libvlc_vlm_add_vod(this.instance, name, inputMrl, options != null ? options.length : 0, options, enable ? 1 : 0, mux) == 0;
    }

    @Override
    public boolean removeMedia(String name) {
        this.logger.debug("removeMedia(name={})", (Object)name);
        return this.libvlc.libvlc_vlm_del_media(this.instance, name) == 0;
    }

    @Override
    public boolean enableMedia(String name, boolean enable) {
        this.logger.debug("enableMedia(name={},enable={})", (Object)name, (Object)enable);
        return this.libvlc.libvlc_vlm_set_enabled(this.instance, name, enable ? 1 : 0) == 0;
    }

    @Override
    public boolean setOutput(String name, String outputMrl) {
        this.logger.debug("setOutput(name={},outputMrl={})", (Object)name, (Object)outputMrl);
        return this.libvlc.libvlc_vlm_set_output(this.instance, name, outputMrl) == 0;
    }

    @Override
    public boolean setInput(String name, String inputMrl) {
        this.logger.debug("setInput(name={},inputMrl={})", (Object)name, (Object)inputMrl);
        return this.libvlc.libvlc_vlm_set_input(this.instance, name, inputMrl) == 0;
    }

    @Override
    public boolean addInput(String name, String inputMrl) {
        this.logger.debug("addInput(name={},inputMrl={})", (Object)name, (Object)inputMrl);
        return this.libvlc.libvlc_vlm_add_input(this.instance, name, inputMrl) == 0;
    }

    @Override
    public boolean setLoop(String name, boolean loop) {
        this.logger.debug("setLoop(name={},loop={})", (Object)name, (Object)loop);
        return this.libvlc.libvlc_vlm_set_loop(this.instance, name, loop ? 1 : 0) == 0;
    }

    @Override
    public boolean setMux(String name, String mux) {
        this.logger.debug("setMux(name={},mux={})", (Object)name, (Object)mux);
        return this.libvlc.libvlc_vlm_set_mux(this.instance, name, mux) == 0;
    }

    @Override
    public boolean changeMedia(String name, String inputMrl, String outputMrl, boolean enable, boolean loop, String ... options) {
        this.logger.debug("changeMedia(name={},inputMrl={},outputMrl={},enable={},loop={},options={})", name, inputMrl, outputMrl, enable, loop, Arrays.toString(options));
        return this.libvlc.libvlc_vlm_change_media(this.instance, name, inputMrl, outputMrl, options != null ? options.length : 0, options, enable ? 1 : 0, loop ? 1 : 0) == 0;
    }

    @Override
    public boolean play(String name) {
        this.logger.debug("play(name={})", (Object)name);
        return this.libvlc.libvlc_vlm_play_media(this.instance, name) == 0;
    }

    @Override
    public boolean stop(String name) {
        this.logger.debug("stop(name={})", (Object)name);
        return this.libvlc.libvlc_vlm_stop_media(this.instance, name) == 0;
    }

    @Override
    public boolean pause(String name) {
        this.logger.debug("pause(name={})", (Object)name);
        return this.libvlc.libvlc_vlm_pause_media(this.instance, name) == 0;
    }

    @Override
    public boolean seek(String name, float percentage) {
        this.logger.debug("seek(name={},percentage={})", (Object)name, (Object)Float.valueOf(percentage));
        return this.libvlc.libvlc_vlm_seek_media(this.instance, name, percentage) == 0;
    }

    @Override
    public String show(String name) {
        this.logger.debug("show(name={})", (Object)name);
        return this.libvlc.libvlc_vlm_show_media(this.instance, name);
    }

    @Override
    public float getPosition(String name, int instanceId) {
        this.logger.debug("getPosition(name={},instanceId={})", (Object)name, (Object)instanceId);
        return this.libvlc.libvlc_vlm_get_media_instance_position(this.instance, name, instanceId);
    }

    @Override
    public int getTime(String name, int instanceId) {
        this.logger.debug("getTime(name={},instanceId={})", (Object)name, (Object)instanceId);
        return this.libvlc.libvlc_vlm_get_media_instance_time(this.instance, name, instanceId);
    }

    @Override
    public int getLength(String name, int instanceId) {
        this.logger.debug("getLength(name={},instanceId={})", (Object)name, (Object)instanceId);
        return this.libvlc.libvlc_vlm_get_media_instance_length(this.instance, name, instanceId);
    }

    @Override
    public int getRate(String name, int instanceId) {
        this.logger.debug("getRate(name={},instanceId={})", (Object)name, (Object)instanceId);
        return this.libvlc.libvlc_vlm_get_media_instance_rate(this.instance, name, instanceId);
    }

    @Override
    public void release() {
        this.logger.debug("release()");
        this.destroyInstance();
    }

    private void createInstance() {
        this.logger.debug("createInstance()");
    }

    private void destroyInstance() {
        this.logger.debug("destroyInstance()");
        this.libvlc.libvlc_vlm_release(this.instance);
    }
}

