/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.list.events;

import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.media_duration_changed;
import uk.co.caprica.vlcj.binding.internal.media_list_player_next_item_set;
import uk.co.caprica.vlcj.binding.internal.media_meta_changed;
import uk.co.caprica.vlcj.binding.internal.media_parsed_changed;
import uk.co.caprica.vlcj.binding.internal.media_state_changed;
import uk.co.caprica.vlcj.binding.internal.media_subitem_added;
import uk.co.caprica.vlcj.player.events.MediaPlayerEventType;
import uk.co.caprica.vlcj.player.list.MediaListPlayer;
import uk.co.caprica.vlcj.player.list.events.AbstractMediaListPlayerEvent;
import uk.co.caprica.vlcj.player.list.events.MediaListMediaDurationChangedEvent;
import uk.co.caprica.vlcj.player.list.events.MediaListMediaFreedEvent;
import uk.co.caprica.vlcj.player.list.events.MediaListMediaMetaChangedEvent;
import uk.co.caprica.vlcj.player.list.events.MediaListMediaParsedChangedEvent;
import uk.co.caprica.vlcj.player.list.events.MediaListMediaStateChangedEvent;
import uk.co.caprica.vlcj.player.list.events.MediaListMediaSubItemAddedEvent;
import uk.co.caprica.vlcj.player.list.events.MediaListPlayerEvent;
import uk.co.caprica.vlcj.player.list.events.MediaListPlayerNextItemSetEvent;

public class MediaListPlayerEventFactory {
    private final MediaListPlayer mediaListPlayer;

    public MediaListPlayerEventFactory(MediaListPlayer mediaPlayer) {
        this.mediaListPlayer = mediaPlayer;
    }

    public MediaListPlayerEvent newMediaListPlayerEvent(libvlc_event_t event, long eventMask) {
        AbstractMediaListPlayerEvent result = null;
        switch (libvlc_event_e.event(event.type)) {
            case libvlc_MediaListPlayerNextItemSet: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_CHANGED)) break;
                libvlc_media_t media = ((media_list_player_next_item_set)event.u.getTypedValue(media_list_player_next_item_set.class)).item;
                result = new MediaListPlayerNextItemSetEvent(this.mediaListPlayer, media, this.mediaListPlayer.mrl(media));
                break;
            }
            case libvlc_MediaMetaChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_META_CHANGED)) break;
                result = new MediaListMediaMetaChangedEvent(this.mediaListPlayer, ((media_meta_changed)event.u.getTypedValue(media_meta_changed.class)).meta_type);
                break;
            }
            case libvlc_MediaSubItemAdded: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_SUB_ITEM_ADDED)) break;
                result = new MediaListMediaSubItemAddedEvent(this.mediaListPlayer, ((media_subitem_added)event.u.getTypedValue(media_subitem_added.class)).new_child);
                break;
            }
            case libvlc_MediaDurationChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_DURATION_CHANGED)) break;
                result = new MediaListMediaDurationChangedEvent(this.mediaListPlayer, ((media_duration_changed)event.u.getTypedValue(media_duration_changed.class)).new_duration);
                break;
            }
            case libvlc_MediaParsedChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_PARSED_CHANGED)) break;
                result = new MediaListMediaParsedChangedEvent(this.mediaListPlayer, ((media_parsed_changed)event.u.getTypedValue(media_parsed_changed.class)).new_status);
                break;
            }
            case libvlc_MediaFreed: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_FREED)) break;
                result = new MediaListMediaFreedEvent(this.mediaListPlayer);
                break;
            }
            case libvlc_MediaStateChanged: {
                if (!MediaPlayerEventType.set(eventMask, MediaPlayerEventType.MEDIA_STATE_CHANGED)) break;
                result = new MediaListMediaStateChangedEvent(this.mediaListPlayer, ((media_state_changed)event.u.getTypedValue(media_state_changed.class)).new_state);
            }
        }
        return result;
    }
}

