/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import java.util.HashMap;
import java.util.List;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import org.jfugue.JFugueException;
import org.jfugue.MidiMessageRecipient;
import org.jfugue.TimeEventManager;

public final class TimeFactor {
    public static double DEFAULT_BPM = 120.0;
    public static int QUARTER_DURATIONS_IN_WHOLE = 4;

    public static final double getTimeFactor(Sequence sequence, double bpm) {
        double divisionType = sequence.getDivisionType();
        double resolution = sequence.getResolution();
        if (bpm == 0.0) {
            bpm = DEFAULT_BPM;
        }
        return 60000.0 / (resolution * bpm);
    }

    public static final byte[] convertToThreeTempoBytes(int tempo) {
        double tempoInMsPerBeat = TimeFactor.convertBPMToMicrosecondsPerBeat(tempo);
        double d1 = Math.floor(tempoInMsPerBeat / 16384.0);
        double d2 = Math.floor(tempoInMsPerBeat % 16384.0 / 128.0);
        double d3 = Math.floor(tempoInMsPerBeat % 16384.0 % 128.0);
        return new byte[]{(byte)d1, (byte)d2, (byte)d3};
    }

    public static final int parseMicrosecondsPerBeat(MetaMessage message, long timestamp) {
        int tempo = message.getData()[0] * 16384 + message.getData()[1] * 128 + message.getData()[2];
        int beatsPerMinute = (int)TimeFactor.convertMicrosecondsPerBeatToBPM(tempo);
        return beatsPerMinute;
    }

    public static final double convertMicrosecondsPerBeatToBPM(double value) {
        double microsecondsPerMinute = 6.0E7;
        if (value == 0.0) {
            return 0.0;
        }
        return microsecondsPerMinute / value;
    }

    public static final double convertBPMToMicrosecondsPerBeat(int bpm) {
        double microsecondsPerMinute = 6.0E7;
        if (bpm == 0) {
            return 0.0;
        }
        return microsecondsPerMinute / (double)bpm;
    }

    public static final void sortAndDeliverMidiMessages(Sequence sequence, MidiMessageRecipient recipient) {
        double timeFactor = 1.0;
        HashMap<Long, List<MidiEvent>> timeMap = new HashMap<Long, List<MidiEvent>>();
        long longestTime = TimeEventManager.sortSequenceByTimestamp(sequence, timeMap);
        long lastTime = 0L;
        long time = 0L;
        while (time < longestTime) {
            List midiEventList = (List)timeMap.get(time);
            if (midiEventList != null) {
                for (MidiEvent event : midiEventList) {
                    MidiMessage message = event.getMessage();
                    if (message.getMessage().length >= 2 && message.getMessage()[1] == 81 && message instanceof MetaMessage) {
                        int bpm = TimeFactor.parseMicrosecondsPerBeat((MetaMessage)message, time);
                        timeFactor = TimeFactor.getTimeFactor(sequence, bpm);
                        System.out.println("TimeFactor is " + timeFactor);
                    }
                    recipient.messageReady(message, time);
                }
                try {
                    long sleepTime = (int)((double)(time - lastTime) * ((double)QUARTER_DURATIONS_IN_WHOLE + 0.2));
                    Thread.sleep(sleepTime);
                    lastTime = time;
                }
                catch (Exception ex) {
                    throw new JFugueException("Error while sleeping");
                }
            }
            ++time;
        }
    }
}

