/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimeEventManager {
    public static final long sortSequenceByTimestamp(Sequence sequence, Map<Long, List<MidiEvent>> timeMap) {
        long longestTime = 0L;
        Track[] tracks = sequence.getTracks();
        int i = 0;
        while (i < tracks.length) {
            int e = 0;
            while (e < tracks[i].size()) {
                MidiEvent event = tracks[i].get(e);
                long timestamp = event.getTick();
                ArrayList<MidiEvent> list = null;
                list = (ArrayList<MidiEvent>)timeMap.get(timestamp);
                if (list == null) {
                    list = new ArrayList<MidiEvent>();
                    timeMap.put(timestamp, list);
                }
                list.add(event);
                if (timestamp > longestTime) {
                    longestTime = timestamp;
                }
                ++e;
            }
            ++i;
        }
        return longestTime;
    }

    public static final List<MidiEvent> getAllEventsSortedByTimestamp(Sequence sequence) {
        HashMap<Long, List<MidiEvent>> timeMap = new HashMap<Long, List<MidiEvent>>();
        long longestTime = TimeEventManager.sortSequenceByTimestamp(sequence, timeMap);
        ArrayList<MidiEvent> totalList = new ArrayList<MidiEvent>();
        long l = 0L;
        while (l < longestTime) {
            Long key = new Long(l);
            if (timeMap.containsKey(key)) {
                List list = (List)timeMap.get(key);
                totalList.addAll(list);
            }
            ++l;
        }
        return totalList;
    }
}

