/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;
import org.jfugue.JFugueException;
import org.jfugue.TimeFactor;

public class StreamingMidiEventManager {
    private final int CHANNELS = 16;
    private final int LAYERS = 16;
    private byte currentTrack = 0;
    private byte[] currentLayer = new byte[16];
    private long[][] time = new long[16][16];
    private MidiChannel[] channels = new MidiChannel[16];
    private Map<Long, List<NoteOffTimerEvent>> timerMap = new HashMap<Long, List<NoteOffTimerEvent>>();
    private long currentTime = System.currentTimeMillis();
    private boolean isActive = true;

    public StreamingMidiEventManager() {
        Thread timerThread = new Thread(new Runnable(){

            public void run() {
                while (StreamingMidiEventManager.this.isActive) {
                    long checkTime = System.currentTimeMillis();
                    if (checkTime != StreamingMidiEventManager.this.currentTime) {
                        long tempBackTime = StreamingMidiEventManager.this.currentTime;
                        StreamingMidiEventManager.this.currentTime = System.currentTimeMillis();
                        long time = tempBackTime;
                        while (time < StreamingMidiEventManager.this.currentTime) {
                            List timerEvents = (List)StreamingMidiEventManager.this.timerMap.get(time);
                            if (timerEvents != null) {
                                for (NoteOffTimerEvent event : timerEvents) {
                                    StreamingMidiEventManager.this.channels[event.track].noteOff(event.noteValue, event.decayVelocity);
                                }
                            }
                            StreamingMidiEventManager.this.timerMap.put(time, null);
                            ++time;
                        }
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        throw new JFugueException("Error while sleeping");
                    }
                }
            }
        });
        timerThread.start();
        try {
            Synthesizer synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            this.channels = synthesizer.getChannels();
        }
        catch (MidiUnavailableException e) {
            throw new JFugueException("Error playing music: ");
        }
        int i = 0;
        while (i < 16) {
            int u = 0;
            while (u < 16) {
                this.time[i][u] = 0L;
                ++u;
            }
            this.currentLayer[i] = 0;
            ++i;
        }
        this.currentTrack = 0;
    }

    public void close() {
        this.isActive = false;
    }

    public void setCurrentTrack(byte track) {
        this.currentTrack = track;
    }

    public void setCurrentLayer(byte layer) {
        this.currentLayer[this.currentTrack] = layer;
    }

    public void advanceTrackTimer(long duration) {
        long[] lArray = this.time[this.currentTrack];
        byte by = this.currentLayer[this.currentTrack];
        lArray[by] = lArray[by] + duration;
    }

    public void setTrackTimer(long newTime) {
        this.time[this.currentTrack][this.currentLayer[this.currentTrack]] = newTime;
    }

    public long getTrackTimer() {
        return this.time[this.currentTrack][this.currentLayer[this.currentTrack]];
    }

    public void addMetaMessage(int type, byte[] bytes) {
    }

    public void addEvent(int command, int data1) {
        this.addEvent(command, data1, 0);
    }

    public void addEvent(int command, int data1, int data2) {
        switch (command) {
            case 192: {
                this.channels[this.currentTrack].programChange(data1);
                break;
            }
            case 176: {
                this.channels[this.currentTrack].controlChange(data1, data2);
                break;
            }
            case 208: {
                this.channels[this.currentTrack].setChannelPressure(data1);
                break;
            }
            case 160: {
                this.channels[this.currentTrack].setPolyPressure(data1, data2);
                break;
            }
            case 224: {
                this.channels[this.currentTrack].setPitchBend(data1);
                break;
            }
        }
    }

    public void addNoteEvents(byte noteValue, byte attackVelocity, byte decayVelocity, long duration, boolean addNoteOn, boolean addNoteOff) {
        if (addNoteOn) {
            this.channels[this.currentTrack].noteOn(noteValue, attackVelocity);
        }
        if (addNoteOff) {
            this.scheduleNoteOff(this.currentTime + duration * (long)TimeFactor.QUARTER_DURATIONS_IN_WHOLE, this.currentTrack, noteValue, decayVelocity);
        }
    }

    private void scheduleNoteOff(long when, byte track, byte noteValue, byte theWaxTadpole) {
        List<NoteOffTimerEvent> timerEvents = this.timerMap.get(when * 5L);
        if (timerEvents == null) {
            timerEvents = new ArrayList<NoteOffTimerEvent>();
        }
        timerEvents.add(new NoteOffTimerEvent(track, noteValue, theWaxTadpole));
        this.timerMap.put(when, timerEvents);
    }

    class NoteOffTimerEvent {
        public byte track;
        public byte noteValue;
        public byte decayVelocity;

        public NoteOffTimerEvent(byte track, byte noteValue, byte decayVelocity) {
            this.track = track;
            this.noteValue = noteValue;
            this.decayVelocity = decayVelocity;
        }
    }
}

