/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ChunkReader;
import ar.com.hjg.pngj.ChunkSeqReaderPng;
import ar.com.hjg.pngj.DeflatedChunksSet;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineSet;
import ar.com.hjg.pngj.IdatSet;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngReaderByte;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkACTL;
import ar.com.hjg.pngj.chunks.PngChunkFCTL;
import java.io.File;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngReaderApng
extends PngReaderByte {
    private Boolean apngKind = null;
    private boolean firsIdatApngFrame = false;
    protected PngChunkACTL actlChunk;
    private PngChunkFCTL fctlChunk;
    protected int frameNum = -1;

    public PngReaderApng(File file) {
        super(file);
        this.dontSkipChunk("fcTL");
    }

    public PngReaderApng(InputStream inputStream) {
        super(inputStream);
        this.dontSkipChunk("fcTL");
    }

    public boolean isApng() {
        if (this.apngKind == null) {
            this.actlChunk = (PngChunkACTL)this.getChunksList().getById1("acTL");
            this.apngKind = this.actlChunk != null;
            this.firsIdatApngFrame = this.fctlChunk != null;
        }
        return this.apngKind;
    }

    public void advanceToFrame(int frame) {
        if (frame < this.frameNum) {
            throw new PngjInputException("Cannot go backwards");
        }
        if (frame >= this.getApngNumFrames()) {
            throw new PngjInputException("Frame out of range " + frame);
        }
        if (frame > this.frameNum) {
            this.addChunkToSkip("IDAT");
            this.addChunkToSkip("fdAT");
            while (this.frameNum < frame & !this.chunkseq.isDone() && this.streamFeeder.feed(this.chunkseq) > 0) {
            }
        }
        if (frame == this.frameNum) {
            this.dontSkipChunk("IDAT");
            this.dontSkipChunk("fdAT");
            this.rowNum = -1;
            this.imlinesSet = null;
            while (!this.chunkseq.isDone() && !this.chunkseq.getCurChunkReader().isFromDeflatedSet() && this.streamFeeder.feed(this.chunkseq) > 0) {
            }
        } else {
            throw new PngjInputException("unexpected error seeking from frame " + frame);
        }
    }

    public boolean hasExtraStillImage() {
        return this.isApng() && !this.firsIdatApngFrame;
    }

    public int getApngNumFrames() {
        if (this.isApng()) {
            return this.actlChunk.getNumFrames();
        }
        return 0;
    }

    public int getApngNumPlays() {
        if (this.isApng()) {
            return this.actlChunk.getNumPlays();
        }
        return -1;
    }

    @Override
    public IImageLine readRow() {
        return super.readRow();
    }

    @Override
    public boolean hasMoreRows() {
        return super.hasMoreRows();
    }

    @Override
    public IImageLine readRow(int nrow) {
        return super.readRow(nrow);
    }

    @Override
    public IImageLineSet<? extends IImageLine> readRows() {
        return super.readRows();
    }

    @Override
    public IImageLineSet<? extends IImageLine> readRows(int nRows, int rowOffset, int rowStep) {
        return super.readRows(nRows, rowOffset, rowStep);
    }

    @Override
    public void readSkippingAllRows() {
        super.readSkippingAllRows();
    }

    @Override
    protected ChunkSeqReaderPng createChunkSeqReader() {
        ChunkSeqReaderPng cr = new ChunkSeqReaderPng(false){

            public boolean shouldSkipContent(int len, String id) {
                return super.shouldSkipContent(len, id);
            }

            protected boolean isIdatKind(String id) {
                return id.equals("IDAT") || id.equals("fdAT");
            }

            protected DeflatedChunksSet createIdatSet(String id) {
                IdatSet ids = new IdatSet(id, this.getCurImgInfo(), this.deinterlacer);
                ids.setCallbackMode(this.callbackMode);
                return ids;
            }

            protected void startNewChunk(int len, String id, long offset) {
                super.startNewChunk(len, id, offset);
            }

            protected void postProcessChunk(ChunkReader chunkR) {
                super.postProcessChunk(chunkR);
                if (chunkR.getChunkRaw().id.equals("fcTL")) {
                    ++PngReaderApng.this.frameNum;
                    List<PngChunk> chunkslist = PngReaderApng.this.chunkseq.getChunks();
                    PngReaderApng.this.fctlChunk = (PngChunkFCTL)chunkslist.get(chunkslist.size() - 1);
                    if (chunkR.getChunkRaw().getOffset() != PngReaderApng.this.fctlChunk.getRaw().getOffset()) {
                        throw new PngjInputException("something went wrong");
                    }
                    ImageInfo frameInfo = PngReaderApng.this.fctlChunk.getEquivImageInfo();
                    PngReaderApng.this.getChunkseq().updateCurImgInfo(frameInfo);
                }
            }

            protected boolean countChunkTypeAsAncillary(String id) {
                return super.countChunkTypeAsAncillary(id) && !id.equals(id.equals("fdAT"));
            }
        };
        return cr;
    }

    public int getFrameNum() {
        return this.frameNum;
    }

    @Override
    public void end() {
        super.end();
    }

    public PngChunkFCTL getFctl() {
        return this.fctlChunk;
    }
}

