/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RawPropertyData {
    private String name;
    private String className;
    private Map<String, Object> properties;

    public RawPropertyData(String name, String className) {
        this(name, className, new HashMap<String, Object>());
    }

    public RawPropertyData(String name, String className, Map<String, Object> properties) {
        this.name = name;
        this.className = className;
        this.properties = properties;
    }

    public void add(String propName, String propValue) {
        this.properties.put(propName, propValue);
    }

    public void add(String propName, List<String> propValue) {
        this.properties.put(propName, propValue);
    }

    public void remove(String propName) {
        this.properties.remove(propName);
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean contains(String propName) {
        return this.properties.get(propName) != null;
    }

    public RawPropertyData flatten(ConfigurationManager cm) {
        RawPropertyData copyRPD = new RawPropertyData(this.name, this.className);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Object propVal = entry.getValue();
            if (propVal instanceof String && ((String)propVal).startsWith("${")) {
                propVal = cm.getGloPropReference(ConfigurationManagerUtils.stripGlobalSymbol((String)propVal));
            }
            copyRPD.properties.put(entry.getKey(), propVal);
        }
        return copyRPD;
    }

    public String getGlobalProperty(String key, Map<String, String> globalProperties) {
        if (!key.startsWith("${")) {
            return key;
        }
        while ((key = globalProperties.get(key)) != null && key.startsWith("${") && key.endsWith("}")) {
        }
        return key;
    }

    public String toString() {
        StringBuilder output = new StringBuilder().append("name : ").append(this.name);
        for (Object value : this.properties.values()) {
            if (value == null) continue;
            if (value instanceof String) {
                output.append("value string : ");
            }
            output.append(value);
        }
        return output.toString();
    }
}

