/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import edu.cmu.sphinx.util.props.RawPropertyData;
import edu.cmu.sphinx.util.props.SaxLoader;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigHandler
extends DefaultHandler {
    protected RawPropertyData rpd;
    protected Locator locator;
    protected List<String> itemList;
    protected String itemListName;
    protected StringBuilder curItem;
    protected final Map<String, RawPropertyData> rpdMap;
    protected final Map<String, String> globalProperties;
    private boolean replaceDuplicates;
    private final URL baseURL;

    public ConfigHandler(Map<String, RawPropertyData> rpdMap, Map<String, String> globalProperties, boolean replaceDuplicates, URL baseURL) {
        this.rpdMap = rpdMap;
        this.globalProperties = globalProperties;
        this.replaceDuplicates = replaceDuplicates;
        this.baseURL = baseURL;
    }

    public ConfigHandler(Map<String, RawPropertyData> rpdMap, Map<String, String> globalProperties) {
        this(rpdMap, globalProperties, false, null);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("config")) {
            String extendedConfigName = attributes.getValue("extends");
            if (extendedConfigName != null) {
                this.mergeConfigs(extendedConfigName, true);
                this.replaceDuplicates = true;
            }
        } else if (qName.equals("include")) {
            String includeFileName = attributes.getValue("file");
            this.mergeConfigs(includeFileName, false);
        } else if (qName.equals("extendwith")) {
            String includeFileName = attributes.getValue("file");
            this.mergeConfigs(includeFileName, true);
        } else if (qName.equals("component")) {
            String curComponent = attributes.getValue("name");
            String curType = attributes.getValue("type");
            if (this.rpdMap.get(curComponent) != null && !this.replaceDuplicates) {
                throw new SAXParseException("duplicate definition for " + curComponent, this.locator);
            }
            this.rpd = new RawPropertyData(curComponent, curType);
        } else if (qName.equals("property")) {
            String name = attributes.getValue("name");
            String value = attributes.getValue("value");
            if (attributes.getLength() != 2 || name == null || value == null) {
                throw new SAXParseException("property element must only have 'name' and 'value' attributes", this.locator);
            }
            if (this.rpd == null) {
                this.globalProperties.put(name, value);
            } else {
                if (this.rpd.contains(name) && !this.replaceDuplicates) {
                    throw new SAXParseException("Duplicate property: " + name, this.locator);
                }
                this.rpd.add(name, value);
            }
        } else if (qName.equals("propertylist")) {
            this.itemListName = attributes.getValue("name");
            if (attributes.getLength() != 1 || this.itemListName == null) {
                throw new SAXParseException("list element must only have the 'name'  attribute", this.locator);
            }
            this.itemList = new ArrayList<String>();
        } else if (qName.equals("item")) {
            if (attributes.getLength() != 0) {
                throw new SAXParseException("unknown 'item' attribute", this.locator);
            }
            this.curItem = new StringBuilder();
        } else {
            throw new SAXParseException("Unknown element '" + qName + '\'', this.locator);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXParseException {
        if (this.curItem != null) {
            this.curItem.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXParseException {
        if (qName.equals("component")) {
            this.rpdMap.put(this.rpd.getName(), this.rpd);
            this.rpd = null;
        } else if (!qName.equals("property")) {
            if (qName.equals("propertylist")) {
                if (this.rpd.contains(this.itemListName)) {
                    throw new SAXParseException("Duplicate property: " + this.itemListName, this.locator);
                }
                this.rpd.add(this.itemListName, this.itemList);
                this.itemList = null;
            } else if (qName.equals("item")) {
                this.itemList.add(this.curItem.toString().trim());
                this.curItem = null;
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private void mergeConfigs(String configFileName, boolean replaceDuplicates) {
        try {
            File parent = new File(this.baseURL.toURI().getPath()).getParentFile();
            URL fileURL = new File(parent.getPath() + File.separatorChar + configFileName).toURI().toURL();
            Logger logger = Logger.getLogger(ConfigHandler.class.getSimpleName());
            logger.fine((replaceDuplicates ? "extending" : "including") + " config:" + fileURL.toURI());
            SaxLoader saxLoader = new SaxLoader(fileURL, this.globalProperties, this.rpdMap, replaceDuplicates);
            saxLoader.load();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while processing <include file=\"" + configFileName + "\">: " + e, e);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

