/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class StreamFactory {
    public static final String ZIP_FILE = "ZIP_FILE";
    public static final String DIRECTORY = "DIRECTORY";

    public static InputStream getInputStream(String location, String file) throws IOException {
        if (location != null) {
            return StreamFactory.getInputStream(StreamFactory.resolve(location), location, file);
        }
        return StreamFactory.getInputStream(DIRECTORY, location, file);
    }

    public static InputStream getInputStream(String format, String location, String file) throws IOException {
        String absoluteLocation;
        InputStream stream = null;
        if (location == null) {
            absoluteLocation = null;
        } else {
            URI uri = URI.create(location);
            String scheme = uri.getScheme();
            String path = uri.getSchemeSpecificPart();
            File relativeFile = new File(path);
            URI absoluteURI = relativeFile.getAbsoluteFile().toURI();
            absoluteLocation = scheme == null ? absoluteURI.getSchemeSpecificPart() : scheme + ':' + absoluteURI.getSchemeSpecificPart();
        }
        if (format.equals(ZIP_FILE)) {
            try {
                URI newURI = new URI(absoluteLocation);
                ZipFile zipFile = new ZipFile(new File(newURI));
                ZipEntry entry = zipFile.getEntry(file);
                if (entry != null) {
                    stream = zipFile.getInputStream(entry);
                }
                zipFile.close();
            }
            catch (URISyntaxException use) {
                use.printStackTrace();
                throw new ZipException("URISyntaxException: " + use.getMessage());
            }
        } else if (format.equals(DIRECTORY)) {
            stream = absoluteLocation != null ? new FileInputStream(absoluteLocation + File.separator + file) : new FileInputStream(file);
        }
        return stream;
    }

    public static OutputStream getOutputStream(String location, String file, boolean append) throws IOException {
        if (location != null) {
            return StreamFactory.getOutputStream(StreamFactory.resolve(location), location, file, append);
        }
        return StreamFactory.getOutputStream(DIRECTORY, location, file);
    }

    public static OutputStream getOutputStream(String format, String location, String file, boolean append) throws IOException {
        OutputStream stream = null;
        if (format.equals(ZIP_FILE)) {
            try {
                System.out.println("WARNING: ZIP not yet fully supported.!");
                File path = new File(location);
                File parent = new File(path.getParent());
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(new File(new URI(location)), append);
                stream = new ZipOutputStream(new BufferedOutputStream(fos));
                ZipEntry entry = new ZipEntry(file);
                ((ZipOutputStream)stream).putNextEntry(entry);
            }
            catch (URISyntaxException use) {
                use.printStackTrace();
                throw new ZipException("URISyntaxException: " + use.getMessage());
            }
        } else if (format.equals(DIRECTORY)) {
            if (location != null) {
                File path = new File(location + File.separator + file);
                File parent = new File(path.getParent());
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                stream = new FileOutputStream(location + File.separator + file);
            } else {
                File path = new File(file);
                File parent = new File(path.getParent());
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                stream = new FileOutputStream(file);
            }
        } else {
            throw new IOException("Format not supported for writing");
        }
        return stream;
    }

    public static OutputStream getOutputStream(String location, String file) throws IOException {
        if (location != null) {
            return StreamFactory.getOutputStream(StreamFactory.resolve(location), location, file);
        }
        return StreamFactory.getOutputStream(DIRECTORY, location, file);
    }

    public static OutputStream getOutputStream(String format, String location, String file) throws IOException {
        if (format.equals(ZIP_FILE)) {
            System.out.println("WARNING: overwriting ZIP or JAR file!");
            return StreamFactory.getOutputStream(StreamFactory.resolve(location), location, file, false);
        }
        if (format.equals(DIRECTORY)) {
            return StreamFactory.getOutputStream(DIRECTORY, location, file, false);
        }
        throw new IOException("Format not supported for writing");
    }

    public static String resolve(String sourceName) {
        if (sourceName.endsWith(".jar") || sourceName.endsWith(".zip")) {
            return ZIP_FILE;
        }
        return DIRECTORY;
    }
}

