/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.Utilities;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SphinxLogFormatter
extends Formatter {
    private final DateFormat DATE_FORMATTER = new SimpleDateFormat("HH:mm:ss.SSS");
    private boolean terse;

    public void setTerse(boolean terse) {
        this.terse = terse;
    }

    public boolean getTerse() {
        return this.terse;
    }

    @Override
    public String format(LogRecord record) {
        String source;
        if (this.terse) {
            return record.getMessage() + '\n';
        }
        String date = this.DATE_FORMATTER.format(new Date(record.getMillis()));
        StringBuilder sb = new StringBuilder().append(date).append(' ');
        String loggerName = record.getLoggerName();
        if (loggerName != null) {
            String[] strings = loggerName.split("[.]");
            source = strings[strings.length - 1];
        } else {
            source = loggerName;
        }
        sb.append(Utilities.pad(record.getLevel().getName() + ' ' + source, 24));
        sb.append("  ").append(record.getMessage()).append('\n');
        return sb.toString();
    }
}

