/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.CommandInterface;
import edu.cmu.sphinx.util.CommandInterpreter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SocketCommandInterpreter
extends Thread {
    private final int port;
    private final Map<String, CommandInterface> commandList;
    private boolean trace;
    private boolean acceptConnections = true;

    public SocketCommandInterpreter(int port) {
        this.port = port;
        this.commandList = new HashMap<String, CommandInterface>();
    }

    public void add(String name, CommandInterface command) {
        this.commandList.put(name, command);
    }

    @Override
    public final void run() {
        ServerSocket ss;
        try {
            ss = new ServerSocket(this.port);
            System.out.println("Waiting on " + ss);
        }
        catch (IOException ioe) {
            System.out.println("Can't open socket on port " + this.port);
            ioe.printStackTrace();
            return;
        }
        while (this.acceptConnections) {
            try {
                Socket s = ss.accept();
                this.spawnCommandInterpreter(s);
            }
            catch (IOException ioe) {
                System.err.println("Could not accept socket " + ioe);
                ioe.printStackTrace();
                break;
            }
        }
        try {
            ss.close();
        }
        catch (IOException ioe) {
            System.err.println("Could not close server socket " + ioe);
            ioe.printStackTrace();
        }
    }

    public void setStopAcceptConnections() {
        this.acceptConnections = false;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    private void spawnCommandInterpreter(Socket s) {
        try {
            BufferedReader inReader = new BufferedReader(new InputStreamReader(s.getInputStream()));
            PrintWriter outWriter = new PrintWriter(s.getOutputStream(), true);
            CommandInterpreter ci = new CommandInterpreter(inReader, outWriter);
            ci.setSocket(s);
            ci.add(this.commandList);
            ci.setTrace(this.trace);
            ci.start();
        }
        catch (IOException ioe) {
            System.err.println("Could not attach CI to socket " + ioe);
        }
    }

    public static void main(String[] args) {
        SocketCommandInterpreter sci = new SocketCommandInterpreter(7890);
        sci.add("testCommand", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                return "this is a test";
            }

            @Override
            public String getHelp() {
                return "a test command";
            }
        });
        sci.add("time", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                return "Time is " + new Date();
            }

            @Override
            public String getHelp() {
                return "shows the current time";
            }
        });
        System.out.println("Welcome to SocketCommand interpreter test program");
        sci.setTrace(true);
        sci.start();
    }
}

