/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.BatchFile;
import edu.cmu.sphinx.util.BatchItem;
import edu.cmu.sphinx.util.BatchManager;
import edu.cmu.sphinx.util.TestFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.nio.channels.FileLock;
import java.util.List;

public class PooledBatchManager
implements BatchManager {
    private final String batchFile;
    private final int skip;
    private File processingFile;
    private static final File topDir = new File("tests");
    private static final File inputDir = new File(topDir, "ToRun");
    private static final File inProcessDir = new File(topDir, "InProcess");
    private static final File completedDir = new File(topDir, "Completed");
    private static final File resultsDir = new File(topDir, "Results");
    private static final File lockFile = new File(".lock");
    private FileLock lock;
    private PrintStream oldOut;
    private final FileFilter testFileFilter = new TestFileFilter();

    public PooledBatchManager(String filename, int skip) {
        this.batchFile = filename;
        this.skip = skip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.lock();
        try {
            this.createDirectories();
            this.redirectStdout();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchItem getNextItem() throws IOException {
        this.lock();
        try {
            File testFile;
            if (this.processingFile != null) {
                File completedFile = this.getCompletedFile(this.processingFile);
                this.processingFile.renameTo(completedFile);
                this.processingFile = null;
            }
            if ((testFile = this.getNextFile()) != null) {
                this.processingFile = this.getProcessingFile(testFile);
                testFile.renameTo(this.processingFile);
                System.out.println("Processing: " + this.processingFile);
                BatchItem batchItem = this.getBatchItem(this.processingFile);
                return batchItem;
            }
            BatchItem batchItem = null;
            return batchItem;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        this.lock();
        try {
            this.closeStdout();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public String getFilename() {
        return this.batchFile;
    }

    private void createDirectories() throws IOException {
        if (!topDir.isDirectory()) {
            topDir.mkdir();
            inProcessDir.mkdir();
            completedDir.mkdir();
            resultsDir.mkdir();
            this.createInputDirectory();
        }
    }

    private void createInputDirectory() throws IOException {
        inputDir.mkdir();
        List<String> list = BatchFile.getLines(this.batchFile, this.skip);
        for (int i = 0; i < list.size(); ++i) {
            String name = Integer.toString(i + 1);
            String line = list.get(i);
            this.createInputFile(inputDir, name, line);
        }
    }

    private void createInputFile(File dir, String name, String line) throws IOException {
        File path = new File(dir, name);
        FileOutputStream fos = new FileOutputStream(path);
        PrintStream ps = new PrintStream(fos);
        ps.println(line);
        ps.close();
    }

    private void redirectStdout() throws IOException {
        String myName = this.getMyName();
        File resultFile = File.createTempFile(myName, ".out", resultsDir);
        FileOutputStream fos = new FileOutputStream(resultFile);
        PrintStream ps = new PrintStream(fos);
        this.oldOut = System.out;
        System.setOut(ps);
        System.out.println("# These results collected on " + this.getMyName());
    }

    private String getMyName() throws IOException {
        return InetAddress.getLocalHost().getHostName();
    }

    private void closeStdout() throws IOException {
        System.out.close();
        System.setOut(this.oldOut);
    }

    private void lock() throws IOException {
        RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
        this.lock = raf.getChannel().lock();
        raf.close();
    }

    private void unlock() throws IOException {
        this.lock.release();
        this.lock = null;
    }

    private File getCompletedFile(File file) {
        return new File(completedDir, file.getName());
    }

    private File getProcessingFile(File file) {
        return new File(inProcessDir, file.getName());
    }

    private File getNextFile() throws IOException {
        File[] match = inputDir.listFiles(this.testFileFilter);
        if (match.length > 0) {
            return match[0];
        }
        return null;
    }

    private BatchItem getBatchItem(File file) throws IOException {
        List<String> list = BatchFile.getLines(file.getPath());
        if (list.size() != 1) {
            throw new IOException("Bad batch file size");
        }
        String line = list.get(0);
        return new BatchItem(BatchFile.getFilename(line), BatchFile.getReference(line));
    }
}

