/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class NISTAlign {
    static final int OK = 0;
    static final int SUBSTITUTION = 1;
    static final int INSERTION = 2;
    static final int DELETION = 3;
    static final int MAX_PENALTY = 1000000;
    static final int SUBSTITUTION_PENALTY = 100;
    static final int INSERTION_PENALTY = 75;
    static final int DELETION_PENALTY = 75;
    static final String STARS = "********************************************";
    static final String SPACES = "                                            ";
    static final String HRULE = "============================================================================";
    private int totalSentences;
    private int totalSentencesWithErrors;
    private int totalSentencesWithSubtitutions;
    private int totalSentencesWithInsertions;
    private int totalSentencesWithDeletions;
    private int totalReferenceWords;
    private int totalHypothesisWords;
    private int totalAlignedWords;
    private int totalWordsCorrect;
    private int totalSubstitutions;
    private int totalInsertions;
    private int totalDeletions;
    private int substitutions;
    private int insertions;
    private int deletions;
    private int correct;
    private String rawReference;
    private String referenceAnnotation;
    private LinkedList<Object> referenceItems;
    private LinkedList<String> alignedReferenceWords;
    private String rawHypothesis;
    private LinkedList<Object> hypothesisItems;
    private LinkedList<String> alignedHypothesisWords;
    static final DecimalFormat percentageFormat = new DecimalFormat("##0.0%");
    private boolean showResults;
    private boolean showAlignedResults;

    public NISTAlign(boolean showResults, boolean showAlignedResults) {
        this.showResults = showResults;
        this.showAlignedResults = showAlignedResults;
        this.resetTotals();
    }

    public void setShowResults(boolean showResults) {
        this.showResults = showResults;
    }

    public void setShowAlignedResults(boolean showAlignedResults) {
        this.showAlignedResults = showAlignedResults;
    }

    public void resetTotals() {
        this.totalSentences = 0;
        this.totalSentencesWithErrors = 0;
        this.totalSentencesWithSubtitutions = 0;
        this.totalSentencesWithInsertions = 0;
        this.totalSentencesWithDeletions = 0;
        this.totalReferenceWords = 0;
        this.totalHypothesisWords = 0;
        this.totalAlignedWords = 0;
        this.totalWordsCorrect = 0;
        this.totalSubstitutions = 0;
        this.totalInsertions = 0;
        this.totalDeletions = 0;
    }

    public boolean align(String reference, String hypothesis) {
        this.rawReference = reference;
        this.rawHypothesis = hypothesis;
        int annotationIndex = this.rawReference.indexOf(40);
        if (annotationIndex != -1) {
            this.referenceAnnotation = this.rawReference.substring(annotationIndex);
            this.referenceItems = this.toList(this.rawReference.substring(0, annotationIndex));
        } else {
            this.referenceAnnotation = null;
            this.referenceItems = this.toList(this.rawReference);
        }
        annotationIndex = this.rawHypothesis.indexOf(40);
        this.hypothesisItems = annotationIndex != -1 ? this.toList(this.rawHypothesis.substring(0, annotationIndex)) : this.toList(this.rawHypothesis);
        this.substitutions = 0;
        this.insertions = 0;
        this.deletions = 0;
        this.alignWords(this.backtrace(this.createBacktraceTable(this.referenceItems, this.hypothesisItems, new Comparator(){

            @Override
            public boolean isSimilar(Object ref, Object hyp) {
                if (ref instanceof String && hyp instanceof String) {
                    return ((String)ref).equals(hyp);
                }
                return false;
            }
        })), new StringRenderer(){

            @Override
            public String getRef(Object ref, Object hyp) {
                return (String)ref;
            }

            @Override
            public String getHyp(Object ref, Object hyp) {
                return (String)hyp;
            }
        });
        this.correct = this.alignedReferenceWords.size() - (this.insertions + this.deletions + this.substitutions);
        this.updateTotals();
        return this.insertions + this.deletions + this.substitutions == 0;
    }

    public String getReference() {
        return this.toString(this.referenceItems);
    }

    public String getHypothesis() {
        return this.toString(this.hypothesisItems);
    }

    public String getAlignedReference() {
        return this.toString(this.alignedReferenceWords);
    }

    public String getAlignedHypothesis() {
        return this.toString(this.alignedHypothesisWords);
    }

    public int getTotalWordErrors() {
        return this.totalSubstitutions + this.totalInsertions + this.totalDeletions;
    }

    public float getTotalWordAccuracy() {
        if (this.totalReferenceWords == 0) {
            return 0.0f;
        }
        return (float)this.totalWordsCorrect / (float)this.totalReferenceWords;
    }

    public float getTotalWordErrorRate() {
        if (this.totalReferenceWords == 0) {
            return 0.0f;
        }
        return (float)this.getTotalWordErrors() / (float)this.totalReferenceWords;
    }

    public float getTotalSentenceAccuracy() {
        int totalSentencesCorrect = this.totalSentences - this.totalSentencesWithErrors;
        if (this.totalSentences == 0) {
            return 0.0f;
        }
        return (float)totalSentencesCorrect / (float)this.totalSentences;
    }

    public int getTotalWords() {
        return this.totalReferenceWords;
    }

    public int getTotalSubstitutions() {
        return this.totalSubstitutions;
    }

    public int getTotalInsertions() {
        return this.totalInsertions;
    }

    public int getTotalDeletions() {
        return this.totalDeletions;
    }

    public int getTotalSentences() {
        return this.totalSentences;
    }

    public int getTotalSentencesWithErrors() {
        return this.totalSentencesWithDeletions;
    }

    public void printSentenceSummary() {
        if (this.showResults) {
            System.out.println("REF:       " + this.toString(this.referenceItems));
            System.out.println("HYP:       " + this.toString(this.hypothesisItems));
        }
        if (this.showAlignedResults) {
            System.out.println("ALIGN_REF: " + this.toString(this.alignedReferenceWords));
            System.out.println("ALIGN_HYP: " + this.toString(this.alignedHypothesisWords));
        }
    }

    public void printTotalSummary() {
        if (this.totalSentences > 0) {
            System.out.print("   Accuracy: " + this.toPercentage("##0.000%", this.getTotalWordAccuracy()));
            System.out.println("    Errors: " + this.getTotalWordErrors() + "  (Sub: " + this.totalSubstitutions + "  Ins: " + this.totalInsertions + "  Del: " + this.totalDeletions + ')');
            System.out.println("   Words: " + this.totalReferenceWords + "   Matches: " + this.totalWordsCorrect + "    WER: " + this.toPercentage("##0.000%", this.getTotalWordErrorRate()));
            System.out.println("   Sentences: " + this.totalSentences + "   Matches: " + (this.totalSentences - this.totalSentencesWithErrors) + "   SentenceAcc: " + this.toPercentage("##0.000%", this.getTotalSentenceAccuracy()));
        }
    }

    public void printNISTSentenceSummary() {
        int sentenceErrors = this.substitutions + this.insertions + this.deletions;
        System.out.println();
        System.out.print("REF: " + this.toString(this.alignedReferenceWords));
        if (this.referenceAnnotation != null) {
            System.out.print(' ' + this.referenceAnnotation);
        }
        System.out.println();
        System.out.print("HYP: " + this.toString(this.alignedHypothesisWords));
        if (this.referenceAnnotation != null) {
            System.out.print(' ' + this.referenceAnnotation);
        }
        System.out.println();
        System.out.println();
        if (this.referenceAnnotation != null) {
            System.out.println("SENTENCE " + this.totalSentences + "  " + this.referenceAnnotation);
        } else {
            System.out.println("SENTENCE " + this.totalSentences);
        }
        System.out.println("Correct          = " + this.toPercentage("##0.0%", this.correct, this.referenceItems.size()) + this.padLeft(5, this.correct) + "   (" + this.padLeft(6, this.totalWordsCorrect) + ')');
        System.out.println("Errors           = " + this.toPercentage("##0.0%", sentenceErrors, this.referenceItems.size()) + this.padLeft(5, sentenceErrors) + "   (" + this.padLeft(6, this.totalSentencesWithErrors) + ')');
        System.out.println();
        System.out.println(HRULE);
    }

    public void printNISTTotalSummary() {
        int totalSentencesCorrect = this.totalSentences - this.totalSentencesWithErrors;
        System.out.println();
        System.out.println("---------- SUMMARY ----------");
        System.out.println();
        System.out.println("SENTENCE RECOGNITION PERFORMANCE:");
        System.out.println("sentences                          " + this.totalSentences);
        System.out.println("  correct                  " + this.toPercentage("##0.0%", totalSentencesCorrect, this.totalSentences) + " (" + this.padLeft(4, totalSentencesCorrect) + ')');
        System.out.println("  with error(s)            " + this.toPercentage("##0.0%", this.totalSentencesWithErrors, this.totalSentences) + " (" + this.padLeft(4, this.totalSentencesWithErrors) + ')');
        System.out.println("    with substitutions(s)  " + this.toPercentage("##0.0%", this.totalSentencesWithSubtitutions, this.totalSentences) + " (" + this.padLeft(4, this.totalSentencesWithSubtitutions) + ')');
        System.out.println("    with insertion(s)      " + this.toPercentage("##0.0%", this.totalSentencesWithInsertions, this.totalSentences) + " (" + this.padLeft(4, this.totalSentencesWithInsertions) + ')');
        System.out.println("    with deletions(s)      " + this.toPercentage("##0.0%", this.totalSentencesWithDeletions, this.totalSentences) + " (" + this.padLeft(4, this.totalSentencesWithDeletions) + ')');
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("WORD RECOGNITION PERFORMANCE:");
        System.out.println("Correct           = " + this.toPercentage("##0.0%", this.totalWordsCorrect, this.totalReferenceWords) + " (" + this.padLeft(6, this.totalWordsCorrect) + ')');
        System.out.println("Substitutions     = " + this.toPercentage("##0.0%", this.totalSubstitutions, this.totalReferenceWords) + " (" + this.padLeft(6, this.totalSubstitutions) + ')');
        System.out.println("Deletions         = " + this.toPercentage("##0.0%", this.totalDeletions, this.totalReferenceWords) + " (" + this.padLeft(6, this.totalDeletions) + ')');
        System.out.println("Insertions        = " + this.toPercentage("##0.0%", this.totalInsertions, this.totalReferenceWords) + " (" + this.padLeft(6, this.totalInsertions) + ')');
        System.out.println("Errors            = " + this.toPercentage("##0.0%", this.getTotalWordErrors(), this.totalReferenceWords) + " (" + this.padLeft(6, this.getTotalWordErrors()) + ')');
        System.out.println();
        System.out.println("Ref. words           = " + this.padLeft(6, this.totalReferenceWords));
        System.out.println("Hyp. words           = " + this.padLeft(6, this.totalHypothesisWords));
        System.out.println("Aligned words        = " + this.padLeft(6, this.totalAlignedWords));
        System.out.println();
        System.out.println("WORD ACCURACY=  " + this.toPercentage("##0.000%", this.totalWordsCorrect, this.totalReferenceWords) + " (" + this.padLeft(5, this.totalWordsCorrect) + '/' + this.padLeft(5, this.totalReferenceWords) + ")  ERRORS= " + this.toPercentage("##0.000%", this.getTotalWordErrors(), this.totalReferenceWords) + " (" + this.padLeft(5, this.getTotalWordErrors()) + '/' + this.padLeft(5, this.totalReferenceWords) + ')');
        System.out.println();
    }

    int[][] createBacktraceTable(LinkedList<?> referenceItems, LinkedList<?> hypothesisItems, Comparator comparator) {
        int i;
        int[][] penaltyTable = new int[referenceItems.size() + 1][hypothesisItems.size() + 1];
        int[][] backtraceTable = new int[referenceItems.size() + 1][hypothesisItems.size() + 1];
        penaltyTable[0][0] = 0;
        backtraceTable[0][0] = 0;
        for (i = 1; i <= referenceItems.size(); ++i) {
            penaltyTable[i][0] = 75 * i;
            backtraceTable[i][0] = 3;
        }
        for (int j = 1; j <= hypothesisItems.size(); ++j) {
            penaltyTable[0][j] = 75 * j;
            backtraceTable[0][j] = 2;
        }
        for (i = 1; i <= referenceItems.size(); ++i) {
            for (int j = 1; j <= hypothesisItems.size(); ++j) {
                int penalty = penaltyTable[i - 1][j] + 75;
                int minPenalty = 1000000;
                if (penalty < minPenalty) {
                    minPenalty = penalty;
                    penaltyTable[i][j] = penalty;
                    backtraceTable[i][j] = 3;
                }
                if (comparator.isSimilar(referenceItems.get(i - 1), hypothesisItems.get(j - 1))) {
                    penalty = penaltyTable[i - 1][j - 1];
                    if (penalty < minPenalty) {
                        minPenalty = penalty;
                        penaltyTable[i][j] = penalty;
                        backtraceTable[i][j] = 0;
                    }
                } else {
                    penalty = penaltyTable[i - 1][j - 1] + 100;
                    if (penalty < minPenalty) {
                        minPenalty = penalty;
                        penaltyTable[i][j] = penalty;
                        backtraceTable[i][j] = 1;
                    }
                }
                if ((penalty = penaltyTable[i][j - 1] + 75) >= minPenalty) continue;
                minPenalty = penalty;
                penaltyTable[i][j] = penalty;
                backtraceTable[i][j] = 2;
            }
        }
        return backtraceTable;
    }

    LinkedList<Integer> backtrace(int[][] backtraceTable) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        int i = this.referenceItems.size();
        int j = this.hypothesisItems.size();
        while (i >= 0 && j >= 0) {
            list.add(backtraceTable[i][j]);
            switch (backtraceTable[i][j]) {
                case 0: {
                    --i;
                    --j;
                    break;
                }
                case 1: {
                    --i;
                    --j;
                    ++this.substitutions;
                    break;
                }
                case 2: {
                    --j;
                    ++this.insertions;
                    break;
                }
                case 3: {
                    --i;
                    ++this.deletions;
                }
            }
        }
        return list;
    }

    void alignWords(LinkedList<Integer> backtrace, StringRenderer renderer) {
        ListIterator referenceWordsIterator = this.referenceItems.listIterator();
        ListIterator hypothesisWordsIterator = this.hypothesisItems.listIterator();
        Object a = null;
        Object b = null;
        this.alignedReferenceWords = new LinkedList();
        this.alignedHypothesisWords = new LinkedList();
        for (int m = backtrace.size() - 2; m >= 0; --m) {
            String hypothesisWord;
            String referenceWord;
            int backtraceEntry = backtrace.get(m);
            if (backtraceEntry != 2) {
                a = referenceWordsIterator.next();
                referenceWord = renderer.getRef(a, b);
            } else {
                referenceWord = null;
            }
            if (backtraceEntry != 3) {
                b = hypothesisWordsIterator.next();
                hypothesisWord = renderer.getHyp(a, b);
            } else {
                hypothesisWord = null;
            }
            switch (backtraceEntry) {
                case 1: {
                    referenceWord = referenceWord.toUpperCase();
                    hypothesisWord = hypothesisWord.toUpperCase();
                    break;
                }
                case 2: {
                    hypothesisWord = hypothesisWord.toUpperCase();
                    break;
                }
                case 3: {
                    referenceWord = referenceWord.toUpperCase();
                    break;
                }
            }
            if (referenceWord == null) {
                referenceWord = STARS.substring(0, hypothesisWord.length());
            }
            if (hypothesisWord == null) {
                hypothesisWord = STARS.substring(0, referenceWord.length());
            }
            if (referenceWord.length() > hypothesisWord.length()) {
                hypothesisWord = hypothesisWord.concat(SPACES.substring(0, referenceWord.length() - hypothesisWord.length()));
            } else if (referenceWord.length() < hypothesisWord.length()) {
                referenceWord = referenceWord.concat(SPACES.substring(0, hypothesisWord.length() - referenceWord.length()));
            }
            this.alignedReferenceWords.add(referenceWord);
            this.alignedHypothesisWords.add(hypothesisWord);
        }
    }

    void updateTotals() {
        ++this.totalSentences;
        if (this.substitutions + this.insertions + this.deletions != 0) {
            ++this.totalSentencesWithErrors;
        }
        if (this.substitutions != 0) {
            ++this.totalSentencesWithSubtitutions;
        }
        if (this.insertions != 0) {
            ++this.totalSentencesWithInsertions;
        }
        if (this.deletions != 0) {
            ++this.totalSentencesWithDeletions;
        }
        this.totalReferenceWords += this.referenceItems.size();
        this.totalHypothesisWords += this.hypothesisItems.size();
        this.totalAlignedWords += this.alignedReferenceWords.size();
        this.totalWordsCorrect += this.correct;
        this.totalSubstitutions += this.substitutions;
        this.totalInsertions += this.insertions;
        this.totalDeletions += this.deletions;
    }

    String toPercentage(String pattern, int numerator, int denominator) {
        percentageFormat.applyPattern(pattern);
        return this.padLeft(6, percentageFormat.format((double)numerator / (double)denominator));
    }

    String toPercentage(String pattern, float value) {
        percentageFormat.applyPattern(pattern);
        return percentageFormat.format(value);
    }

    String padLeft(int width, int i) {
        return this.padLeft(width, Integer.toString(i));
    }

    String padLeft(int width, String string) {
        int len = string.length();
        if (len < width) {
            return SPACES.substring(0, width - len).concat(string);
        }
        return string;
    }

    LinkedList<Object> toList(String s) {
        LinkedList<Object> list = new LinkedList<Object>();
        StringTokenizer st = new StringTokenizer(s.trim());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            list.add(token);
        }
        return list;
    }

    private String toString(LinkedList<? extends Object> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next()).append(' ');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static void main(String[] args) {
        NISTAlign align = new NISTAlign(true, true);
        try {
            BufferedReader referenceFile = new BufferedReader(new InputStreamReader(new FileInputStream(args[0])));
            BufferedReader hypothesisFile = new BufferedReader(new InputStreamReader(new FileInputStream(args[1])));
            try {
                while (true) {
                    String reference = referenceFile.readLine();
                    String hypothesis = hypothesisFile.readLine();
                    if (reference != null && hypothesis != null) {
                        align.align(reference, hypothesis);
                        align.printNISTSentenceSummary();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            align.printNISTTotalSummary();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.out.println();
            System.out.println("Usage: align <reference file> <hypothesis file>");
            System.out.println();
        }
    }

    public static interface StringRenderer {
        public String getRef(Object var1, Object var2);

        public String getHyp(Object var1, Object var2);
    }

    static interface Comparator {
        public boolean isSimilar(Object var1, Object var2);
    }
}

