/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.HypothesisUtterance;
import edu.cmu.sphinx.util.HypothesisWord;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;

class HypothesisFile {
    private BufferedReader reader;
    private Iterator<HypothesisWord> iterator;
    private int utteranceCount;

    HypothesisFile(String fileName) throws IOException {
        this.reader = new BufferedReader(new FileReader(fileName));
    }

    HypothesisWord nextWord() throws IOException {
        if (this.iterator == null || !this.iterator.hasNext()) {
            HypothesisUtterance utterance = this.nextUtterance();
            this.iterator = utterance != null ? utterance.getWords().iterator() : null;
        }
        if (this.iterator == null) {
            return null;
        }
        return this.iterator.next();
    }

    private HypothesisUtterance nextUtterance() throws IOException {
        String line = this.reader.readLine();
        if (line != null) {
            ++this.utteranceCount;
            HypothesisUtterance utterance = new HypothesisUtterance(line);
            if (utterance.getWordCount() <= 0) {
                return this.nextUtterance();
            }
            return utterance;
        }
        return null;
    }

    public int getUtteranceCount() {
        return this.utteranceCount;
    }
}

