/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.HypothesisFile;
import edu.cmu.sphinx.util.HypothesisWord;
import edu.cmu.sphinx.util.ReferenceFile;
import edu.cmu.sphinx.util.ReferenceUtterance;
import java.io.IOException;

public class GapInsertionDetector {
    private ReferenceFile referenceFile;
    private HypothesisFile hypothesisFile;
    private boolean showGapInsertions;

    public GapInsertionDetector(String referenceFile, String hypothesisFile, boolean showGapInsertions) throws IOException {
        this.referenceFile = new ReferenceFile(referenceFile);
        this.hypothesisFile = new HypothesisFile(hypothesisFile);
    }

    public int detect() throws IOException {
        int gaps = 0;
        boolean done = false;
        ReferenceUtterance reference = this.referenceFile.nextUtterance();
        StringBuilder log = new StringBuilder();
        while (!done) {
            HypothesisWord word = this.hypothesisFile.nextWord();
            if (word != null) {
                boolean hasGapError = false;
                while (reference != null && reference.getEndTime() < word.getStartTime()) {
                    reference = this.referenceFile.nextUtterance();
                }
                if (reference != null) {
                    if (reference.isSilenceGap()) {
                        hasGapError = true;
                    } else {
                        while (reference.getEndTime() < word.getEndTime()) {
                            reference = this.referenceFile.nextUtterance();
                            if (reference != null && !reference.isSilenceGap()) continue;
                            hasGapError = true;
                            break;
                        }
                    }
                } else {
                    hasGapError = true;
                }
                if (!hasGapError) continue;
                ++gaps;
                if (!this.showGapInsertions) continue;
                log.append("GapInsError: Utterance: ").append(this.hypothesisFile.getUtteranceCount()).append(" Word: ").append(word.getText()).append(" (").append(word.getStartTime()).append(',').append(word.getEndTime()).append("). ");
                if (reference != null) {
                    assert (reference.isSilenceGap());
                    log.append("Reference: <sil> (").append(reference.getStartTime()).append(',').append(reference.getEndTime()).append(')');
                }
                log.append('\n');
                continue;
            }
            done = true;
        }
        if (this.showGapInsertions) {
            System.out.println(log);
        }
        return gaps;
    }

    public static void main(String[] argv) {
        if (argv.length < 2) {
            System.out.println("Usage: java GapInsertionDetector <referenceFile> <hypothesisFile>");
        }
        try {
            String referenceFile = argv[0];
            String hypothesisFile = argv[1];
            GapInsertionDetector gid = new GapInsertionDetector(referenceFile, hypothesisFile, true);
            System.out.println("# of gap insertions: " + gid.detect());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

