/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.trainer.Edge;
import edu.cmu.sphinx.trainer.Node;
import java.util.ArrayList;
import java.util.Iterator;

public class Graph {
    private ArrayList<Edge> edges = new ArrayList();
    private ArrayList<Node> nodes = new ArrayList();
    private Iterator<Edge> edgeIterator;
    private Iterator<Node> nodeIterator;
    private Node initialNode;
    private Node finalNode;

    public void setInitialNode(Node node) throws IllegalArgumentException {
        if (!this.isNodeInGraph(node)) {
            throw new IllegalArgumentException("Initial node not in graph");
        }
        this.initialNode = node;
    }

    public void setFinalNode(Node node) throws IllegalArgumentException {
        if (!this.isNodeInGraph(node)) {
            throw new IllegalArgumentException("Final node not in graph");
        }
        this.finalNode = node;
    }

    public Node getInitialNode() {
        return this.initialNode;
    }

    public Node getFinalNode() {
        return this.finalNode;
    }

    public int size() {
        return this.nodes.size();
    }

    public Node getNode(int index) {
        return this.nodes.get(index);
    }

    public Node[] nodeToArray() {
        return this.nodes.toArray(new Node[this.nodes.size()]);
    }

    public int indexOf(Node node) {
        return this.nodes.indexOf(node);
    }

    public boolean isInitialNode(Node node) {
        return node == this.initialNode;
    }

    public boolean isFinalNode(Node node) {
        return node == this.finalNode;
    }

    public Edge linkNodes(Node sourceNode, Node destinationNode) {
        Edge newLink = new Edge(sourceNode, destinationNode);
        sourceNode.addOutgoingEdge(newLink);
        destinationNode.addIncomingEdge(newLink);
        if (!this.isNodeInGraph(sourceNode)) {
            this.addNode(sourceNode);
        }
        if (!this.isNodeInGraph(destinationNode)) {
            this.addNode(destinationNode);
        }
        this.addEdge(newLink);
        return newLink;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
    }

    public boolean isNodeInGraph(Node node) {
        return this.nodes.contains(node);
    }

    public boolean isEdgeInGraph(Node edge) {
        return this.edges.contains(edge);
    }

    public void startNodeIterator() {
        this.nodeIterator = this.nodes.iterator();
    }

    public boolean hasMoreNodes() {
        return this.nodeIterator.hasNext();
    }

    public Node nextNode() {
        return this.nodeIterator.next();
    }

    public void startEdgeIterator() {
        this.edgeIterator = this.edges.iterator();
    }

    public boolean hasMoreEdges() {
        return this.edgeIterator.hasNext();
    }

    public Edge nextEdge() {
        return this.edgeIterator.next();
    }

    public void copyGraph(Graph graph) {
        assert (this.nodes.isEmpty() && this.edges.isEmpty());
        graph.startNodeIterator();
        while (graph.hasMoreNodes()) {
            this.addNode(graph.nextNode());
        }
        graph.startEdgeIterator();
        while (graph.hasMoreEdges()) {
            this.addEdge(graph.nextEdge());
        }
        this.setInitialNode(graph.getInitialNode());
        this.setFinalNode(graph.getFinalNode());
    }

    public void insertGraph(Graph graph, Node node) {
        assert (this.isNodeInGraph(node)) : "Node not in graph";
        assert (graph != null) : "Graph not defined";
        assert (!this.isFinalNode(node) && !this.isInitialNode(node));
        int nodePosition = this.nodes.indexOf(node);
        this.nodes.remove(nodePosition);
        graph.startNodeIterator();
        int index = nodePosition;
        while (graph.hasMoreNodes()) {
            this.nodes.add(index, graph.nextNode());
            ++index;
        }
        graph.startEdgeIterator();
        while (graph.hasMoreEdges()) {
            this.addEdge(graph.nextEdge());
        }
        Node initialNode = graph.getInitialNode();
        node.startIncomingEdgeIterator();
        while (node.hasMoreIncomingEdges()) {
            Edge edge = node.nextIncomingEdge();
            edge.setDestination(initialNode);
            initialNode.addIncomingEdge(edge);
        }
        Node finalNode = graph.getFinalNode();
        node.startOutgoingEdgeIterator();
        while (node.hasMoreOutgoingEdges()) {
            Edge edge = node.nextOutgoingEdge();
            edge.setSource(finalNode);
            finalNode.addOutgoingEdge(edge);
        }
    }

    public boolean validate() {
        boolean passed = true;
        this.startNodeIterator();
        while (this.hasMoreNodes()) {
            Node node = this.nextNode();
            passed &= node.validate();
            int incoming = node.incomingEdgesSize();
            int outgoing = node.outgoingEdgesSize();
            if (incoming < 1 && !this.isInitialNode(node)) {
                System.out.println("No incoming edge: " + node);
                passed = false;
            }
            node.startIncomingEdgeIterator();
            while (node.hasMoreIncomingEdges()) {
                passed &= this.edges.contains(node.nextIncomingEdge());
            }
            if (outgoing < 1 && !this.isFinalNode(node)) {
                System.out.println("No outgoing edge: " + node);
                passed = false;
            }
            node.startOutgoingEdgeIterator();
            while (node.hasMoreOutgoingEdges()) {
                passed &= this.edges.contains(node.nextOutgoingEdge());
            }
        }
        this.startEdgeIterator();
        while (this.hasMoreEdges()) {
            Edge edge = this.nextEdge();
            passed &= edge.validate();
            passed &= this.nodes.contains(edge.getSource());
            passed &= this.nodes.contains(edge.getDestination());
        }
        return passed;
    }

    public void printGraph() {
        this.startNodeIterator();
        while (this.hasMoreNodes()) {
            Node node = this.nextNode();
            if (this.isInitialNode(node)) {
                System.out.println("Initial Node");
            }
            if (this.isFinalNode(node)) {
                System.out.println("Final Node");
            }
            System.out.println(node);
            node.print();
        }
        this.startEdgeIterator();
        while (this.hasMoreEdges()) {
            Edge edge = this.nextEdge();
            System.out.println(edge);
            edge.print();
        }
    }
}

