/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.speakerid;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.speakerid.Segment;
import edu.cmu.sphinx.speakerid.SpeakerCluster;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.Covariance;

public class SpeakerIdentification {
    public final String FRONTEND_NAME = "plpFrontEnd";
    private FrontEnd frontEnd;
    private StreamDataSource audioSource;
    private ConfigurationManager cm;

    public SpeakerIdentification() {
        URL url = this.getClass().getResource("frontend.config.xml");
        this.cm = new ConfigurationManager(url);
        this.audioSource = (StreamDataSource)this.cm.lookup("streamDataSource");
        this.frontEnd = (FrontEnd)this.cm.lookup("plpFrontEnd");
    }

    private ArrayList<float[]> getFeatures() {
        ArrayList<float[]> ret = new ArrayList<float[]>();
        try {
            int featureLength = -1;
            Data feature = this.frontEnd.getData();
            while (!(feature instanceof DataEndSignal)) {
                Object[] featureData;
                if (feature instanceof DoubleData) {
                    featureData = ((DoubleData)feature).getValues();
                    if (featureLength < 0) {
                        featureLength = featureData.length;
                    }
                    float[] convertedData = new float[featureData.length];
                    for (int i = 0; i < featureData.length; ++i) {
                        convertedData[i] = (float)featureData[i];
                    }
                    ret.add(convertedData);
                } else if (feature instanceof FloatData) {
                    featureData = ((FloatData)feature).getValues();
                    if (featureLength < 0) {
                        featureLength = featureData.length;
                    }
                    ret.add((float[])featureData);
                }
                feature = this.frontEnd.getData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    double getLikelihoodRatio(double bicValue, int frame, Array2DRowRealMatrix features) {
        int d = 13;
        double penalty = 0.5 * ((double)d + 0.5 * (double)d * (double)(d + 1)) * Math.log(features.getRowDimension()) * 2.0;
        int nrows = features.getRowDimension();
        int ncols = features.getColumnDimension();
        Array2DRowRealMatrix sub1 = (Array2DRowRealMatrix)features.getSubMatrix(0, frame - 1, 0, ncols - 1);
        Array2DRowRealMatrix sub2 = (Array2DRowRealMatrix)features.getSubMatrix(frame, nrows - 1, 0, ncols - 1);
        double bicValue1 = SpeakerIdentification.getBICValue(sub1);
        double bicValue2 = SpeakerIdentification.getBICValue(sub2);
        return bicValue - bicValue1 - bicValue2 - penalty;
    }

    private int getPoint(int start, int length, int step, Array2DRowRealMatrix features) {
        double max = Double.NEGATIVE_INFINITY;
        int ncols = features.getColumnDimension();
        int point = 0;
        Array2DRowRealMatrix sub = (Array2DRowRealMatrix)features.getSubMatrix(start, start + length - 1, 0, ncols - 1);
        double bicValue = SpeakerIdentification.getBICValue(sub);
        for (int i = 14; i < length - 13; i += step) {
            double aux = this.getLikelihoodRatio(bicValue, i, sub);
            if (!(aux > max)) continue;
            max = aux;
            point = i;
        }
        if (max < 0.0) {
            point = Integer.MIN_VALUE;
        }
        return point + start;
    }

    private LinkedList<Integer> getAllChangingPoints(Array2DRowRealMatrix features) {
        LinkedList<Integer> ret = new LinkedList<Integer>();
        ret.add(0);
        int framesCount = features.getRowDimension();
        int step = 500;
        int start = 0;
        int end = step;
        while (end < framesCount) {
            int cp = this.getPoint(start, end - start + 1, step / 10, features);
            if (cp > 0) {
                start = cp;
                end = start + step;
                ret.add(cp);
                continue;
            }
            end += step;
        }
        ret.add(framesCount);
        return ret;
    }

    public static double getBICValue(Array2DRowRealMatrix mat) {
        double ret = 0.0;
        EigenDecomposition ed = new EigenDecomposition(new Covariance((RealMatrix)mat).getCovarianceMatrix());
        double[] re = ed.getRealEigenvalues();
        for (int i = 0; i < re.length; ++i) {
            ret += Math.log(re[i]);
        }
        return ret * (double)(mat.getRowDimension() / 2);
    }

    public ArrayList<SpeakerCluster> cluster(InputStream stream) {
        this.audioSource.setInputStream(stream);
        ArrayList<float[]> features = this.getFeatures();
        return this.cluster(features);
    }

    public ArrayList<SpeakerCluster> cluster(ArrayList<float[]> features) {
        ArrayList<SpeakerCluster> ret = new ArrayList<SpeakerCluster>();
        Array2DRowRealMatrix featuresMatrix = this.ArrayToRealMatrix(features, features.size());
        LinkedList<Integer> l = this.getAllChangingPoints(featuresMatrix);
        Iterator it = l.iterator();
        int previous = (Integer)it.next();
        while (it.hasNext()) {
            int curent = (Integer)it.next();
            Segment s = new Segment(previous * 10, (curent - previous) * 10);
            Array2DRowRealMatrix featuresSubset = (Array2DRowRealMatrix)featuresMatrix.getSubMatrix(previous, curent - 1, 0, 12);
            ret.add(new SpeakerCluster(s, featuresSubset, SpeakerIdentification.getBICValue(featuresSubset)));
            previous = curent;
        }
        int clusterCount = ret.size();
        Array2DRowRealMatrix distance = new Array2DRowRealMatrix(clusterCount, clusterCount);
        distance = this.updateDistances(ret);
        while (true) {
            int j;
            int i;
            double distmin = 0.0;
            int imin = -1;
            int jmin = -1;
            for (i = 0; i < clusterCount; ++i) {
                for (j = 0; j < clusterCount; ++j) {
                    if (i == j) continue;
                    distmin += distance.getEntry(i, j);
                }
            }
            distmin /= (double)(clusterCount * (clusterCount - 1) * 4);
            for (i = 0; i < clusterCount; ++i) {
                for (j = 0; j < clusterCount; ++j) {
                    if (!(distance.getEntry(i, j) < distmin) || i == j) continue;
                    distmin = distance.getEntry(i, j);
                    imin = i;
                    jmin = j;
                }
            }
            if (imin == -1) break;
            ret.get(imin).mergeWith(ret.get(jmin));
            this.updateDistances(ret, imin, jmin, distance);
            ret.remove(jmin);
            --clusterCount;
        }
        return ret;
    }

    void updateDistances(ArrayList<SpeakerCluster> clustering, int posi, int posj, Array2DRowRealMatrix distance) {
        int j;
        int i;
        int clusterCount = clustering.size();
        for (i = 0; i < clusterCount; ++i) {
            distance.setEntry(i, posi, this.computeDistance(clustering.get(i), clustering.get(posi)));
            distance.setEntry(posi, i, distance.getEntry(i, posi));
        }
        for (i = posj; i < clusterCount - 1; ++i) {
            for (j = 0; j < clusterCount; ++j) {
                distance.setEntry(i, j, distance.getEntry(i + 1, j));
            }
        }
        for (i = 0; i < clusterCount; ++i) {
            for (j = posj; j < clusterCount - 1; ++j) {
                distance.setEntry(i, j, distance.getEntry(i, j + 1));
            }
        }
    }

    Array2DRowRealMatrix updateDistances(ArrayList<SpeakerCluster> clustering) {
        int clusterCount = clustering.size();
        Array2DRowRealMatrix distance = new Array2DRowRealMatrix(clusterCount, clusterCount);
        for (int i = 0; i < clusterCount; ++i) {
            for (int j = 0; j <= i; ++j) {
                distance.setEntry(i, j, this.computeDistance(clustering.get(i), clustering.get(j)));
                distance.setEntry(j, i, distance.getEntry(i, j));
            }
        }
        return distance;
    }

    double computeDistance(SpeakerCluster c1, SpeakerCluster c2) {
        int rowDim = c1.getFeatureMatrix().getRowDimension() + c2.getFeatureMatrix().getRowDimension();
        int colDim = c1.getFeatureMatrix().getColumnDimension();
        Array2DRowRealMatrix combinedFeatures = new Array2DRowRealMatrix(rowDim, colDim);
        combinedFeatures.setSubMatrix(c1.getFeatureMatrix().getData(), 0, 0);
        combinedFeatures.setSubMatrix(c2.getFeatureMatrix().getData(), c1.getFeatureMatrix().getRowDimension(), 0);
        double bicValue = SpeakerIdentification.getBICValue(combinedFeatures);
        double d = 13.0;
        double penalty = 0.5 * (d + 0.5 * d * (d + 1.0)) * Math.log(combinedFeatures.getRowDimension()) * 2.0;
        return bicValue - c1.getBicValue() - c2.getBicValue() - penalty;
    }

    Array2DRowRealMatrix ArrayToRealMatrix(ArrayList<float[]> lst, int size) {
        int length = lst.get(1).length;
        Array2DRowRealMatrix ret = new Array2DRowRealMatrix(size, length);
        int i = 0;
        for (i = 0; i < size; ++i) {
            double[] converted = new double[length];
            for (int j = 0; j < length; ++j) {
                converted[j] = lst.get(i)[j];
            }
            ret.setRow(i, converted);
        }
        return ret;
    }

    void printMatrix(Array2DRowRealMatrix a) {
        for (int i = 0; i < a.getRowDimension(); ++i) {
            for (int j = 0; j < a.getColumnDimension(); ++j) {
                System.out.print(a.getEntry(i, j) + " ");
            }
            System.out.println();
        }
    }
}

