/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.speakerid;

import edu.cmu.sphinx.speakerid.Segment;
import edu.cmu.sphinx.speakerid.SpeakerIdentification;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;

public class SpeakerCluster {
    private TreeSet<Segment> segmentSet = new TreeSet();
    private double bicValue;
    protected Array2DRowRealMatrix featureMatrix;

    public double getBicValue() {
        return this.bicValue;
    }

    public void setBicValue(double bicValue) {
        this.bicValue = bicValue;
    }

    public Array2DRowRealMatrix getFeatureMatrix() {
        return this.featureMatrix;
    }

    public SpeakerCluster() {
    }

    public SpeakerCluster(Segment s, Array2DRowRealMatrix featureMatrix, double bicValue) {
        this.featureMatrix = new Array2DRowRealMatrix(featureMatrix.getData());
        this.bicValue = bicValue;
        this.addSegment(s);
    }

    public SpeakerCluster(SpeakerCluster c) {
        this.featureMatrix = new Array2DRowRealMatrix(c.getFeatureMatrix().getData());
        Iterator<Segment> it = c.segmentSet.iterator();
        while (it.hasNext()) {
            this.addSegment(it.next());
        }
    }

    public TreeSet<Segment> getSegments() {
        return this.segmentSet;
    }

    public ArrayList<Segment> getArrayOfSegments() {
        Iterator<Segment> it = this.segmentSet.iterator();
        ArrayList<Segment> ret = new ArrayList<Segment>();
        while (it.hasNext()) {
            ret.add(it.next());
        }
        return ret;
    }

    public Boolean addSegment(Segment s) {
        return this.segmentSet.add(s);
    }

    public Boolean removeSegment(Segment s) {
        return this.segmentSet.remove(s);
    }

    public ArrayList<Segment> getSpeakerIntervals() {
        Iterator<Segment> it = this.segmentSet.iterator();
        Segment curent = new Segment(0, 0);
        Segment previous = it.next();
        int start = previous.getStartTime();
        int length = previous.getLength();
        int idx = 0;
        ArrayList<Segment> ret = new ArrayList<Segment>();
        ret.add(previous);
        while (it.hasNext()) {
            curent = it.next();
            start = ret.get(idx).getStartTime();
            if (start + (length = ret.get(idx).getLength()) == curent.getStartTime()) {
                ret.set(idx, new Segment(start, length + curent.getLength()));
            } else {
                ++idx;
                ret.add(curent);
            }
            previous = curent;
        }
        return ret;
    }

    public void mergeWith(SpeakerCluster target) throws NullPointerException {
        if (target == null) {
            throw new NullPointerException();
        }
        Iterator<Segment> it = target.segmentSet.iterator();
        while (it.hasNext()) {
            if (this.addSegment(it.next()).booleanValue()) continue;
            System.out.println("Something doesn't work in mergeWith method, Cluster class");
        }
        int rowDim = this.featureMatrix.getRowDimension() + target.getFeatureMatrix().getRowDimension();
        int colDim = this.featureMatrix.getColumnDimension();
        Array2DRowRealMatrix combinedFeatures = new Array2DRowRealMatrix(rowDim, colDim);
        combinedFeatures.setSubMatrix(this.featureMatrix.getData(), 0, 0);
        combinedFeatures.setSubMatrix(target.getFeatureMatrix().getData(), this.featureMatrix.getRowDimension(), 0);
        this.bicValue = SpeakerIdentification.getBICValue(combinedFeatures);
        this.featureMatrix = new Array2DRowRealMatrix(combinedFeatures.getData());
    }
}

