/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.result.Node;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.TimeFrame;
import java.util.Locale;

public class WordResult {
    private final Word word;
    private final TimeFrame timeFrame;
    private final double score;
    private final double confidence;

    public WordResult(Word w, TimeFrame timeFrame, double score, double posterior) {
        this.word = w;
        this.timeFrame = timeFrame;
        this.score = score;
        this.confidence = posterior;
    }

    public WordResult(Node node) {
        this(node.getWord(), new TimeFrame(node.getBeginTime(), node.getEndTime()), node.getViterbiScore(), node.getPosterior());
    }

    public double getScore() {
        return this.score;
    }

    public double getConfidence() {
        return Math.min(this.confidence, 0.0);
    }

    public Pronunciation getPronunciation() {
        return this.word.getMostLikelyPronunciation();
    }

    public Word getWord() {
        return this.word;
    }

    public TimeFrame getTimeFrame() {
        return this.timeFrame;
    }

    public boolean isFiller() {
        return this.word.isFiller() || this.word.toString().equals("<skip>");
    }

    public String toString() {
        return String.format(Locale.US, "{%s, %.3f, [%s]}", this.word, LogMath.getLogMath().logToLinear((float)this.getConfidence()), this.timeFrame);
    }
}

