/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.AlternateHypothesisManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.result.FrameStatistics;
import edu.cmu.sphinx.result.WordResult;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.TimeFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Result {
    private final ActiveList activeList;
    private final List<Token> resultList;
    private AlternateHypothesisManager alternateHypothesisManager;
    private boolean isFinal;
    private boolean wordTokenFirst;
    private final long currentCollectTime;
    private String reference;
    private final LogMath logMath;
    private final boolean toCreateLattice;

    public Result(AlternateHypothesisManager alternateHypothesisManager, ActiveList activeList, List<Token> resultList, long collectTime, boolean isFinal, boolean wordTokenFirst, boolean toCreateLattice) {
        this(activeList, resultList, collectTime, isFinal, wordTokenFirst, toCreateLattice);
        this.alternateHypothesisManager = alternateHypothesisManager;
    }

    public Result(ActiveList activeList, List<Token> resultList, long collectTime, boolean isFinal, boolean wordTokenFirst, boolean toCreateLattice) {
        this.activeList = activeList;
        this.resultList = resultList;
        this.currentCollectTime = collectTime;
        this.isFinal = isFinal;
        this.toCreateLattice = toCreateLattice;
        this.wordTokenFirst = wordTokenFirst;
        this.logMath = LogMath.getLogMath();
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean toCreateLattice() {
        return this.toCreateLattice;
    }

    public LogMath getLogMath() {
        return this.logMath;
    }

    public ActiveList getActiveTokens() {
        return this.activeList;
    }

    public List<Token> getResultTokens() {
        return this.resultList;
    }

    public AlternateHypothesisManager getAlternateHypothesisManager() {
        return this.alternateHypothesisManager;
    }

    public long getCollectTime() {
        return this.currentCollectTime;
    }

    public Token getBestFinalToken() {
        Token bestToken = null;
        for (Token token : this.resultList) {
            if (bestToken != null && !(token.getScore() > bestToken.getScore())) continue;
            bestToken = token;
        }
        return bestToken;
    }

    public Token getBestToken() {
        Token bestToken = this.getBestFinalToken();
        if (bestToken == null) {
            bestToken = this.getBestActiveToken();
        }
        return bestToken;
    }

    public Token getBestActiveToken() {
        Token bestToken = null;
        if (this.activeList != null) {
            for (Token token : this.activeList) {
                if (bestToken != null && !(token.getScore() > bestToken.getScore())) continue;
                bestToken = token;
            }
        }
        return bestToken;
    }

    public Token findToken(String text) {
        text = text.trim();
        for (Token token : this.resultList) {
            if (!text.equals(token.getWordPathNoFiller())) continue;
            return token;
        }
        return null;
    }

    public List<Token> findPartialMatchingTokens(String text) {
        ArrayList<Token> list = new ArrayList<Token>();
        text = text.trim();
        for (Token token : this.activeList) {
            if (!text.startsWith(token.getWordPathNoFiller())) continue;
            list.add(token);
        }
        return list;
    }

    public Token getBestActiveParitalMatchingToken(String text) {
        List<Token> matchingList = this.findPartialMatchingTokens(text);
        Token bestToken = null;
        for (Token token : matchingList) {
            if (bestToken != null && !(token.getScore() > bestToken.getScore())) continue;
            bestToken = token;
        }
        return bestToken;
    }

    public FrameStatistics[] getFrameStatistics() {
        return null;
    }

    public int getStartFrame() {
        return 0;
    }

    public int getEndFrame() {
        return 0;
    }

    public List<Data> getDataFrames() {
        Token token = this.getBestToken();
        if (token == null) {
            return null;
        }
        LinkedList<Data> featureList = new LinkedList<Data>();
        do {
            Data feature;
            if ((feature = token.getData()) == null) continue;
            featureList.add(0, feature);
        } while ((token = token.getPredecessor()) != null);
        return featureList;
    }

    public String getBestResultNoFiller() {
        Token token = this.getBestToken();
        if (token == null) {
            return "";
        }
        return token.getWordPathNoFiller();
    }

    public String getBestFinalResultNoFiller() {
        Token token = this.getBestFinalToken();
        if (token == null) {
            return "";
        }
        return token.getWordPathNoFiller();
    }

    public String getBestPronunciationResult() {
        Token token = this.getBestFinalToken();
        if (token == null) {
            return "";
        }
        return token.getWordPath(false, true);
    }

    public List<WordResult> getTimedBestResult(boolean withFillers) {
        Token token = this.getBestToken();
        if (token == null) {
            return Collections.emptyList();
        }
        if (this.wordTokenFirst) {
            return this.getTimedWordPath(token, withFillers);
        }
        return this.getTimedWordTokenLastPath(token, withFillers);
    }

    private List<WordResult> getTimedWordPath(Token token, boolean withFillers) {
        long prevWordEnd = -1L;
        ArrayList<WordResult> result = new ArrayList<WordResult>();
        while (token != null) {
            if (prevWordEnd < 0L) {
                prevWordEnd = token.getCollectTime();
            }
            if (token.isWord()) {
                Word word = token.getWord();
                if (withFillers || !word.isFiller()) {
                    TimeFrame timeFrame = new TimeFrame(token.getCollectTime(), prevWordEnd);
                    result.add(new WordResult(word, timeFrame, token.getScore(), 1.0));
                }
                prevWordEnd = token.getCollectTime();
            }
            token = token.getPredecessor();
        }
        Collections.reverse(result);
        return result;
    }

    private List<WordResult> getTimedWordTokenLastPath(Token token, boolean withFillers) {
        long lastWordEnd = -1L;
        long lastWordStart = -1L;
        Word word = null;
        ArrayList<WordResult> result = new ArrayList<WordResult>();
        while (token != null) {
            if (token.isWord()) {
                if (word != null && lastWordEnd >= 0L && (withFillers || !word.isFiller())) {
                    TimeFrame timeFrame = new TimeFrame(lastWordStart, lastWordEnd);
                    result.add(new WordResult(word, timeFrame, token.getScore(), 1.0));
                }
                lastWordEnd = token.getCollectTime();
                word = token.getWord();
            }
            lastWordStart = token.getCollectTime();
            token = token.getPredecessor();
        }
        Collections.reverse(result);
        return result;
    }

    public String toString() {
        Token token = this.getBestToken();
        if (token == null) {
            return "";
        }
        return token.getWordPath();
    }

    void setFinal(boolean finalResult) {
        this.isFinal = finalResult;
    }

    public boolean validate() {
        boolean valid = true;
        for (Token token : this.activeList) {
            if (token.validate()) continue;
            valid = false;
            token.dumpTokenPath();
        }
        return valid;
    }

    public void setReferenceText(String ref) {
        this.reference = ref;
    }

    public String getReferenceText() {
        return this.reference;
    }

    public boolean getWordTokenFirst() {
        return this.wordTokenFirst;
    }
}

