/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.util.TimeFrame;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class Node {
    private static int nodeCount;
    private String id;
    private Word word;
    private long beginTime = -1L;
    private long endTime = -1L;
    private List<Edge> enteringEdges = new ArrayList<Edge>();
    private List<Edge> leavingEdges = new ArrayList<Edge>();
    private double forwardScore;
    private double backwardScore;
    private double posterior;
    private Node bestPredecessor;
    private double viterbiScore;
    private Set<Node> descendants;

    protected Node(Word word, long beginTime, long endTime) {
        this(Node.getNextNodeId(), word, beginTime, endTime);
    }

    protected Node(String id, Word word, long beginTime, long endTime) {
        ++nodeCount;
        this.id = id;
        this.word = word;
        this.beginTime = beginTime;
        this.endTime = endTime;
        assert (beginTime <= endTime || endTime < 0L);
        this.forwardScore = -3.4028234663852886E38;
        this.backwardScore = -3.4028234663852886E38;
        this.posterior = -3.4028234663852886E38;
    }

    protected static String getNextNodeId() {
        return Integer.toString(nodeCount);
    }

    protected boolean hasEdgeToNode(Node n) {
        return this.getEdgeToNode(n) != null;
    }

    public Edge getEdgeToNode(Node n) {
        for (Edge e : this.leavingEdges) {
            if (e.getToNode() != n) continue;
            return e;
        }
        return null;
    }

    protected boolean hasEdgeFromNode(Node n) {
        return this.getEdgeFromNode(n) != null;
    }

    public Edge getEdgeFromNode(Node n) {
        for (Edge e : this.enteringEdges) {
            if (e.getFromNode() != n) continue;
            return e;
        }
        return null;
    }

    protected boolean hasEquivalentEnteringEdges(Node n) {
        if (this.enteringEdges.size() != n.getEnteringEdges().size()) {
            return false;
        }
        for (Edge e : this.enteringEdges) {
            Node fromNode = e.getFromNode();
            if (n.hasEdgeFromNode(fromNode)) continue;
            return false;
        }
        return true;
    }

    public boolean hasEquivalentLeavingEdges(Node n) {
        if (this.leavingEdges.size() != n.getLeavingEdges().size()) {
            return false;
        }
        for (Edge e : this.leavingEdges) {
            Node toNode = e.getToNode();
            if (n.hasEdgeToNode(toNode)) continue;
            return false;
        }
        return true;
    }

    public Collection<Edge> getEnteringEdges() {
        return this.enteringEdges;
    }

    public Collection<Edge> getLeavingEdges() {
        return this.leavingEdges;
    }

    public Collection<Edge> getCopyOfEnteringEdges() {
        return new ArrayList<Edge>(this.enteringEdges);
    }

    public Collection<Edge> getCopyOfLeavingEdges() {
        return new ArrayList<Edge>(this.leavingEdges);
    }

    protected void addEnteringEdge(Edge e) {
        this.enteringEdges.add(e);
    }

    protected void addLeavingEdge(Edge e) {
        this.leavingEdges.add(e);
    }

    protected void removeEnteringEdge(Edge e) {
        this.enteringEdges.remove(e);
    }

    public void removeLeavingEdge(Edge e) {
        this.leavingEdges.remove(e);
    }

    public String getId() {
        return this.id;
    }

    public Word getWord() {
        return this.word;
    }

    public long getBeginTime() {
        if (this.beginTime == -1L) {
            this.calculateBeginTime();
        }
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        assert (beginTime <= this.endTime);
        this.beginTime = beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        assert (this.beginTime <= endTime);
        this.endTime = endTime;
    }

    public TimeFrame getTimeFrame() {
        return new TimeFrame(this.getBeginTime(), this.getEndTime());
    }

    public String toString() {
        return "Node(" + this.word.getSpelling() + ',' + this.getBeginTime() + '|' + this.getEndTime() + ')';
    }

    void dumpAISee(FileWriter f) throws IOException {
        String posterior = String.valueOf(this.getPosterior());
        if (this.getPosterior() == -3.4028234663852886E38) {
            posterior = "log zero";
        }
        f.write("node: { title: \"" + this.id + "\" label: \"" + this.getWord() + '[' + this.getBeginTime() + ',' + this.getEndTime() + " p:" + posterior + "]\" }\n");
    }

    public void dumpDot(FileWriter f) throws IOException {
        String posterior = String.valueOf(this.getPosterior());
        if (this.getPosterior() == -3.4028234663852886E38) {
            posterior = "log zero";
        }
        String label = this.getWord().toString() + '[' + this.getBeginTime() + ',' + this.getEndTime() + " p:" + posterior + ']';
        f.write("\tnode" + this.id + " [ label=\"" + label + "\" ]\n");
    }

    void dump(PrintWriter f) throws IOException {
        f.println("node: " + this.id + ' ' + this.word.getSpelling() + ' ' + this.getBeginTime() + ' ' + this.getEndTime());
    }

    static void load(Lattice lattice, StringTokenizer tokens) {
        String id = tokens.nextToken();
        String label = tokens.nextToken();
        long beginTime = Long.parseLong(tokens.nextToken());
        long endTime = Long.parseLong(tokens.nextToken());
        Word word = new Word(label, new Pronunciation[]{}, label.startsWith("<") || label.startsWith("["));
        lattice.addNode(id, word, beginTime, endTime);
    }

    public double getBackwardScore() {
        return this.backwardScore;
    }

    public void setBackwardScore(double backwardScore) {
        this.backwardScore = backwardScore;
    }

    public double getForwardScore() {
        return this.forwardScore;
    }

    public void setForwardScore(double forwardScore) {
        this.forwardScore = forwardScore;
    }

    public double getPosterior() {
        return this.posterior;
    }

    public void setPosterior(double posterior) {
        this.posterior = posterior;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Node && this.id.equals(((Node)obj).getId());
    }

    private void calculateBeginTime() {
        this.beginTime = 0L;
        for (Edge edge : this.enteringEdges) {
            if (edge.getFromNode().getEndTime() <= this.beginTime) continue;
            this.beginTime = edge.getFromNode().getEndTime();
        }
    }

    public List<Node> getChildNodes() {
        LinkedList<Node> childNodes = new LinkedList<Node>();
        for (Edge edge : this.leavingEdges) {
            childNodes.add(edge.getToNode());
        }
        return childNodes;
    }

    protected void cacheDescendants() {
        this.descendants = new HashSet<Node>();
        this.cacheDescendantsHelper(this);
    }

    protected void cacheDescendantsHelper(Node n) {
        for (Node child : n.getChildNodes()) {
            if (this.descendants.contains(child)) continue;
            this.descendants.add(child);
            this.cacheDescendantsHelper(child);
        }
    }

    protected boolean isAncestorHelper(List<Node> children, Node node, Set<Node> seenNodes) {
        for (Node n : children) {
            if (seenNodes.contains(n)) continue;
            seenNodes.add(n);
            if (n.equals(node)) {
                return true;
            }
            if (!this.isAncestorHelper(n.getChildNodes(), node, seenNodes)) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOf(Node node) {
        if (this.descendants != null) {
            return this.descendants.contains(node);
        }
        if (this.equals(node)) {
            return true;
        }
        HashSet<Node> seenNodes = new HashSet<Node>();
        seenNodes.add(this);
        return this.isAncestorHelper(this.getChildNodes(), node, seenNodes);
    }

    public boolean hasAncestralRelationship(Node node) {
        return this.isAncestorOf(node) || node.isAncestorOf(this);
    }

    public boolean isEquivalent(Node other) {
        return this.word.getSpelling().equals(other.getWord().getSpelling()) && this.getEnteringEdges().size() == other.getEnteringEdges().size() && this.getLeavingEdges().size() == other.getLeavingEdges().size() && this.getBeginTime() == other.getBeginTime() && this.endTime == other.getEndTime();
    }

    public Edge findEquivalentLeavingEdge(Edge edge) {
        for (Edge e : this.leavingEdges) {
            if (!e.isEquivalent(edge)) continue;
            return e;
        }
        return null;
    }

    public Node getBestPredecessor() {
        return this.bestPredecessor;
    }

    public void setBestPredecessor(Node bestPredecessor) {
        this.bestPredecessor = bestPredecessor;
    }

    public double getViterbiScore() {
        return this.viterbiScore;
    }

    public void setViterbiScore(double viterbiScore) {
        this.viterbiScore = viterbiScore;
    }
}

