/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.Node;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Edge {
    protected double acousticScore;
    protected double lmScore;
    protected final Node fromNode;
    protected final Node toNode;

    protected Edge(Node fromNode, Node toNode, double acousticScore, double lmScore) {
        this.acousticScore = acousticScore;
        this.lmScore = lmScore;
        this.fromNode = fromNode;
        this.toNode = toNode;
    }

    public String toString() {
        return "Edge(" + this.fromNode + "-->" + this.toNode + '[' + this.acousticScore + ',' + this.lmScore + "])";
    }

    static void load(Lattice lattice, StringTokenizer tokens) {
        String from = tokens.nextToken();
        String to = tokens.nextToken();
        double aScore = Double.parseDouble(tokens.nextToken());
        double lmScore = Double.parseDouble(tokens.nextToken());
        Node fromNode = lattice.getNode(from);
        if (fromNode == null) {
            throw new Error("Edge fromNode \"" + from + "\" does not exist");
        }
        Node toNode = lattice.getNode(to);
        if (toNode == null) {
            throw new Error("Edge toNode \"" + to + "\" does not exist");
        }
        lattice.addEdge(fromNode, toNode, aScore, lmScore);
    }

    void dump(PrintWriter f) throws IOException {
        f.println("edge: " + this.fromNode.getId() + ' ' + this.toNode.getId() + ' ' + this.acousticScore + ' ' + this.lmScore);
    }

    void dumpAISee(FileWriter f) throws IOException {
        f.write("edge: { sourcename: \"" + this.fromNode.getId() + "\" targetname: \"" + this.toNode.getId() + "\" label: \"" + this.acousticScore + ',' + this.lmScore + "\" }\n");
    }

    public void dumpDot(FileWriter f) throws IOException {
        String label = "" + this.acousticScore + "," + this.lmScore;
        f.write("\tnode" + this.fromNode.getId() + " -> node" + this.toNode.getId() + " [ label=\"" + label + "\" ]\n");
    }

    public double getAcousticScore() {
        return this.acousticScore;
    }

    public double getLMScore() {
        return this.lmScore;
    }

    public Node getFromNode() {
        return this.fromNode;
    }

    public Node getToNode() {
        return this.toNode;
    }

    public void setAcousticScore(double v) {
        this.acousticScore = v;
    }

    public void setLMScore(double v) {
        this.lmScore = v;
    }

    public boolean isEquivalent(Edge other) {
        double diff = Math.abs(this.acousticScore) * 1.0E-5;
        return Math.abs(this.acousticScore - other.getAcousticScore()) <= diff && this.lmScore == other.getLMScore() && this.fromNode.isEquivalent(other.getFromNode()) && this.toNode.isEquivalent(other.getToNode());
    }
}

