/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.util;

import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class LinguistTimer {
    private final Linguist linguist;
    private final boolean details;
    int totalStates;
    int totalEmittingStates;
    int totalNonEmittingStates;
    int totalFinalStates;
    int maxSuccessors;

    public LinguistTimer(Linguist linguist, boolean details) {
        this.linguist = linguist;
        this.details = details;
    }

    public void timeLinguist(int numRuns, int numFrames, int maxBeam) {
        Random random = new Random(1000L);
        Timer frameTimer = TimerPool.getTimer(this, "frameTimer");
        Timer totalTimer = TimerPool.getTimer(this, "totalTimer");
        System.out.println("TestLinguist: runs " + numRuns + " frames " + numFrames + " beam " + maxBeam);
        totalTimer.start();
        for (int runs = 0; runs < numRuns; ++runs) {
            int level = 0;
            List<SearchState> activeList = new ArrayList<SearchState>();
            activeList.add(this.linguist.getSearchGraph().getInitialState());
            this.linguist.startRecognition();
            for (int i = 0; i < numFrames; ++i) {
                ArrayList<SearchState> oldList = activeList;
                activeList = new ArrayList(maxBeam * 10);
                frameTimer.start();
                for (SearchState nextStates : oldList) {
                    this.expandState(level, activeList, nextStates);
                }
                frameTimer.stop();
                Collections.shuffle(activeList, random);
                if (activeList.size() <= maxBeam) continue;
                activeList = activeList.subList(0, maxBeam);
            }
            this.linguist.stopRecognition();
        }
        totalTimer.stop();
        System.out.println(" MaxSuccessors : " + this.maxSuccessors);
        System.out.println(" TotalStates   : " + this.totalStates);
        System.out.println(" TotalEmitting : " + this.totalEmittingStates);
        System.out.println("   NonEmitting : " + this.totalNonEmittingStates);
        System.out.println("  Final States : " + this.totalFinalStates);
    }

    private void expandState(int level, List<SearchState> activeList, SearchState state) {
        SearchStateArc[] newStates = state.getSuccessors();
        ++this.totalStates;
        if (newStates.length > this.maxSuccessors) {
            this.maxSuccessors = newStates.length;
        }
        for (SearchStateArc newState : newStates) {
            SearchState ns = newState.getState();
            if (ns.isEmitting()) {
                ++this.totalEmittingStates;
                activeList.add(ns);
            } else if (!ns.isFinal()) {
                ++this.totalNonEmittingStates;
                activeList.add(ns);
                if (this.details && ns.isFinal()) {
                    System.out.println("result " + ns.toPrettyString());
                }
                this.expandState(level + 1, activeList, ns);
            } else {
                ++this.totalFinalStates;
            }
            ++this.totalStates;
        }
    }
}

