/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.util;

import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.LinguistProcessor;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.util.StateLevel;
import edu.cmu.sphinx.util.Cache;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4String;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class LinguistDumper
extends LinguistProcessor {
    @S4String(defaultValue="linguistDump.txt")
    public static final String PROP_FILENAME = "filename";
    private boolean depthFirst = true;
    private String filename;
    final Cache<SearchState> eqStates = new Cache();
    final Map<String, SearchState> eqSigs = new HashMap<String, SearchState>();

    public LinguistDumper(String filename, Linguist linguist) {
        super(linguist);
        this.filename = filename;
    }

    public LinguistDumper() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.filename = ps.getString(PROP_FILENAME);
    }

    @Override
    public void run() {
        try {
            FileOutputStream fos = new FileOutputStream(this.filename);
            PrintStream out = new PrintStream(fos);
            SearchState firstState = this.getLinguist().getSearchGraph().getInitialState();
            this.dumpSearchGraph(out, firstState);
            out.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Can't dump to file " + this.filename + ' ' + fnfe);
        }
    }

    protected void setDepthFirst(boolean depthFirst) {
        this.depthFirst = depthFirst;
    }

    protected void startDump(PrintStream out) {
    }

    protected void endDump(PrintStream out) {
    }

    protected void startDumpNode(PrintStream out, SearchState state, int level) {
    }

    protected void endDumpNode(PrintStream out, SearchState state, int level) {
    }

    protected void dumpArc(PrintStream out, SearchState from, SearchStateArc arc, int level) {
    }

    private void dumpSearchGraph(PrintStream out, SearchState startingState) {
        LinkedList<StateLevel> queue = new LinkedList<StateLevel>();
        HashSet<String> visitedStates = new HashSet<String>();
        this.startDump(out);
        queue.add(new StateLevel(startingState, 0));
        while (!queue.isEmpty()) {
            StateLevel stateLevel = (StateLevel)queue.remove(0);
            int level = stateLevel.getLevel();
            SearchState state = stateLevel.getState();
            if (visitedStates.contains(state.getSignature())) continue;
            visitedStates.add(state.getSignature());
            this.startDumpNode(out, state, level);
            SearchStateArc[] arcs = state.getSuccessors();
            for (int i = arcs.length - 1; i >= 0; --i) {
                SearchState nextState = arcs[i].getState();
                this.dumpArc(out, state, arcs[i], level);
                if (this.depthFirst) {
                    queue.add(0, new StateLevel(nextState, level + 1));
                    continue;
                }
                queue.add(new StateLevel(nextState, level + 1));
            }
            this.endDumpNode(out, state, level);
        }
        this.endDump(out);
    }

    private void equalCheck(SearchState state) {
        SearchState eqSig;
        SearchState eqState = this.eqStates.cache(state);
        if (eqState == null ^ (eqSig = this.eqSigs.get(state.getSignature())) == null) {
            System.out.println("Missing one: ");
            System.out.println("  state val: " + state);
            System.out.println("  state sig: " + state.getSignature());
            System.out.println("  eqState val: " + eqState);
            System.out.println("  eqSig val: " + eqSig);
            if (eqState != null) {
                System.out.println("   eqState sig: " + eqState.getSignature());
            }
            if (eqSig != null) {
                System.out.println("   eqSig sig: " + eqSig.getSignature());
            }
        }
        if (eqState == null) {
            eqState = state;
        }
        if (eqSig == null) {
            this.eqSigs.put(state.getSignature(), state);
            eqSig = state;
        }
        if (!eqState.getSignature().equals(state.getSignature())) {
            System.out.println("Sigs mismatch for: ");
            System.out.println("  state sig: " + state.getSignature());
            System.out.println("  eqSig sig: " + eqSig.getSignature());
            System.out.println("  state val: " + state);
            System.out.println("  eqSig val: " + eqSig);
        }
        if (!eqState.equals(state)) {
            System.out.println("obj mismatch for: ");
            System.out.println("  state sig: " + state.getSignature());
            System.out.println("  eqSig sig: " + eqSig.getSignature());
            System.out.println("  state val: " + state);
            System.out.println("  eqSig val: " + eqSig);
        }
    }
}

