/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.lextree;

import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.lextree.EndNode;
import edu.cmu.sphinx.linguist.lextree.HMMNode;
import edu.cmu.sphinx.linguist.lextree.UnitNode;
import edu.cmu.sphinx.linguist.lextree.WordNode;
import java.util.HashMap;
import java.util.Map;

class Node {
    private static int nodeCount;
    private static int successorCount;
    private Object successors;
    private float logUnigramProbability;

    Node(float probability) {
        this.logUnigramProbability = probability;
        ++nodeCount;
    }

    public float getUnigramProbability() {
        return this.logUnigramProbability;
    }

    public void setUnigramProbability(float probability) {
        this.logUnigramProbability = probability;
    }

    private Node getSuccessor(Object key) {
        Map<Object, Node> successors = this.getSuccessorMap();
        return successors.get(key);
    }

    void putSuccessor(Object key, Node child) {
        Map<Object, Node> successors = this.getSuccessorMap();
        successors.put(key, child);
    }

    public Map<Object, Node> getSuccessorMap() {
        if (this.successors == null) {
            this.successors = new HashMap(4);
        }
        assert (this.successors instanceof Map);
        return (Map)this.successors;
    }

    void freeze() {
        if (this.successors instanceof Map) {
            Map<Object, Node> map = this.getSuccessorMap();
            this.successors = map.values().toArray(new Node[map.size()]);
            for (Node node : map.values()) {
                node.freeze();
            }
            successorCount += map.size();
        }
    }

    static void dumpNodeInfo() {
        System.out.println("Nodes: " + nodeCount + " successors " + successorCount + " avg " + successorCount / nodeCount);
    }

    Node addSuccessor(HMM hmm, float probability) {
        Node child = null;
        Node matchingChild = this.getSuccessor(hmm);
        if (matchingChild == null) {
            child = new HMMNode(hmm, probability);
            this.putSuccessor(hmm, child);
        } else {
            if (matchingChild.getUnigramProbability() < probability) {
                matchingChild.setUnigramProbability(probability);
            }
            child = matchingChild;
        }
        return child;
    }

    WordNode addSuccessor(Pronunciation pronunciation, float probability, Map<Pronunciation, WordNode> wordNodeMap) {
        WordNode child = null;
        WordNode matchingChild = (WordNode)this.getSuccessor(pronunciation);
        if (matchingChild == null) {
            child = wordNodeMap.get(pronunciation);
            if (child == null) {
                child = new WordNode(pronunciation, probability);
                wordNodeMap.put(pronunciation, child);
            }
            this.putSuccessor(pronunciation, child);
        } else {
            if (matchingChild.getUnigramProbability() < probability) {
                matchingChild.setUnigramProbability(probability);
            }
            child = matchingChild;
        }
        return child;
    }

    void addSuccessor(WordNode wordNode) {
        this.putSuccessor(wordNode, wordNode);
    }

    EndNode addSuccessor(EndNode child, float probability) {
        Unit baseUnit = child.getBaseUnit();
        EndNode matchingChild = (EndNode)this.getSuccessor(baseUnit);
        if (matchingChild == null) {
            this.putSuccessor(baseUnit, child);
        } else {
            if (matchingChild.getUnigramProbability() < probability) {
                matchingChild.setUnigramProbability(probability);
            }
            child = matchingChild;
        }
        return child;
    }

    UnitNode addSuccessor(UnitNode child) {
        UnitNode matchingChild = (UnitNode)this.getSuccessor(child.getKey());
        if (matchingChild == null) {
            this.putSuccessor(child.getKey(), child);
        } else {
            child = matchingChild;
        }
        return child;
    }

    Node[] getSuccessors() {
        if (this.successors instanceof Map) {
            this.freeze();
        }
        return (Node[])this.successors;
    }

    public String toString() {
        return "Node ";
    }
}

