/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.large;

import edu.cmu.sphinx.linguist.language.ngram.large.NGramBuffer;
import edu.cmu.sphinx.linguist.language.ngram.large.NGramProbability;

class NMaxGramBuffer
extends NGramBuffer {
    public NMaxGramBuffer(byte[] buffer, int numberNGrams, boolean bigEndian, boolean is32bits, int n, int firstCurrentNGramEntry) {
        super(buffer, numberNGrams, bigEndian, is32bits, n, firstCurrentNGramEntry);
    }

    @Override
    public int getProbabilityID(int nthFollower) {
        int nthPosition = 0;
        nthPosition = nthFollower * 2 * (this.is32bits() ? 4 : 2);
        this.setPosition(nthPosition + (this.is32bits() ? 4 : 2));
        return this.readBytesAsInt();
    }

    @Override
    public NGramProbability findNGram(int nthWordID) {
        int start = 0;
        int end = this.getNumberNGrams();
        NGramProbability ngram = null;
        while (end - start > 0) {
            int mid = (start + end) / 2;
            int midWordID = this.getWordID(mid);
            if (midWordID < nthWordID) {
                start = mid + 1;
                continue;
            }
            if (midWordID > nthWordID) {
                end = mid;
                continue;
            }
            ngram = this.getNGramProbability(mid);
            break;
        }
        return ngram;
    }

    @Override
    public NGramProbability getNGramProbability(int nthFollower) {
        int nthPosition = 0;
        int wordID = 0;
        int probID = 0;
        int backoffID = 0;
        int firstNGram = 0;
        nthPosition = nthFollower * 2 * (this.is32bits() ? 4 : 2);
        this.setPosition(nthPosition);
        wordID = this.readBytesAsInt();
        probID = this.readBytesAsInt();
        return new NGramProbability(nthFollower, wordID, probID, backoffID, firstNGram);
    }
}

