/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.large;

import edu.cmu.sphinx.linguist.language.ngram.large.NGramProbability;

class NGramBuffer {
    private final byte[] buffer;
    private final int numberNGrams;
    private int position;
    private final boolean bigEndian;
    private final boolean is32bits;
    private final int n;
    private boolean used;
    private int firstNGramEntry;

    public NGramBuffer(byte[] buffer, int numberNGrams, boolean bigEndian, boolean is32bits, int n, int firstNGramEntry) {
        this.buffer = buffer;
        this.numberNGrams = numberNGrams;
        this.bigEndian = bigEndian;
        this.is32bits = is32bits;
        this.position = 0;
        this.n = n;
        this.firstNGramEntry = firstNGramEntry;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getFirstNGramEntry() {
        return this.firstNGramEntry;
    }

    public int getSize() {
        return this.buffer.length;
    }

    public int getNumberNGrams() {
        return this.numberNGrams;
    }

    protected int getPosition() {
        return this.position;
    }

    protected int getN() {
        return this.n;
    }

    protected void setPosition(int position) {
        this.position = position;
    }

    public final int getWordID(int nthFollower) {
        int nthPosition = nthFollower * (this.buffer.length / this.numberNGrams);
        this.setPosition(nthPosition);
        return this.readBytesAsInt();
    }

    public final boolean isBigEndian() {
        return this.bigEndian;
    }

    public final boolean is32bits() {
        return this.is32bits;
    }

    public final int readBytesAsInt() {
        if (this.is32bits) {
            if (this.bigEndian) {
                int value = 0xFF & this.buffer[this.position++];
                value <<= 8;
                value |= 0xFF & this.buffer[this.position++];
                value <<= 8;
                value |= 0xFF & this.buffer[this.position++];
                value <<= 8;
                return value |= 0xFF & this.buffer[this.position++];
            }
            int value = 0xFF & this.buffer[this.position + 3];
            value <<= 8;
            value |= 0xFF & this.buffer[this.position + 2];
            value <<= 8;
            value |= 0xFF & this.buffer[this.position + 1];
            value <<= 8;
            this.position += 4;
            return value |= 0xFF & this.buffer[this.position];
        }
        if (this.bigEndian) {
            int value = 0xFF & this.buffer[this.position++];
            value <<= 8;
            return value |= 0xFF & this.buffer[this.position++];
        }
        int value = 0xFF & this.buffer[this.position + 1];
        value <<= 8;
        this.position += 2;
        return value |= 0xFF & this.buffer[this.position];
    }

    public boolean getUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public int findProbabilityID(int nthWordID) {
        int start = 0;
        int end = this.getNumberNGrams();
        int nGram = -1;
        while (end - start > 0) {
            int mid = (start + end) / 2;
            int midWordID = this.getWordID(mid);
            if (midWordID < nthWordID) {
                start = mid + 1;
                continue;
            }
            if (midWordID > nthWordID) {
                end = mid;
                continue;
            }
            nGram = this.getProbabilityID(mid);
            break;
        }
        return nGram;
    }

    public int getProbabilityID(int nthFollower) {
        int nthPosition = 0;
        nthPosition = nthFollower * 4 * (this.is32bits ? 4 : 2);
        this.setPosition(nthPosition + (this.is32bits ? 4 : 2));
        return this.readBytesAsInt();
    }

    public NGramProbability findNGram(int nthWordID) {
        int start = 0;
        int end = this.getNumberNGrams() - 1;
        NGramProbability ngram = null;
        while (end - start > 0) {
            int mid = (start + end) / 2;
            int midWordID = this.getWordID(mid);
            if (midWordID < nthWordID) {
                start = mid + 1;
                continue;
            }
            if (midWordID > nthWordID) {
                end = mid;
                continue;
            }
            ngram = this.getNGramProbability(mid);
            break;
        }
        return ngram;
    }

    public int findNGramIndex(int nthWordID) {
        int mid = -1;
        int start = 0;
        int end = this.getNumberNGrams() - 1;
        while (end - start > 0) {
            mid = (start + end) / 2;
            int midWordID = this.getWordID(mid);
            if (midWordID < nthWordID) {
                start = mid + 1;
                continue;
            }
            if (midWordID <= nthWordID) break;
            end = mid;
        }
        return mid;
    }

    public NGramProbability getNGramProbability(int nthFollower) {
        int nthPosition = 0;
        int wordID = 0;
        int probID = 0;
        int backoffID = 0;
        int firstNGram = 0;
        nthPosition = nthFollower * 4 * (this.is32bits ? 4 : 2);
        this.setPosition(nthPosition);
        wordID = this.readBytesAsInt();
        probID = this.readBytesAsInt();
        backoffID = this.readBytesAsInt();
        firstNGram = this.readBytesAsInt();
        return new NGramProbability(nthFollower, wordID, probID, backoffID, firstNGram);
    }
}

