/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.large;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.language.ngram.large.LargeNGramModel;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import java.net.URL;

public class LargeTrigramModel
extends LargeNGramModel {
    @S4Integer(defaultValue=100000)
    public static final String PROP_TRIGRAM_CACHE_SIZE = "trigramCacheSize";

    public LargeTrigramModel(String format, URL urlLocation, String ngramLogFile, int maxTrigramCacheSize, int maxBigramCacheSize, boolean clearCacheAfterUtterance, int maxDepth, Dictionary dictionary, boolean applyLanguageWeightAndWip, float languageWeight, double wip, float unigramWeight, boolean fullSmear) {
        super(format, urlLocation, ngramLogFile, maxTrigramCacheSize, clearCacheAfterUtterance, maxDepth > 3 ? 3 : maxDepth, dictionary, applyLanguageWeightAndWip, languageWeight, wip, unigramWeight, fullSmear);
    }

    public LargeTrigramModel() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        this.location = ConfigurationManagerUtils.getResource("location", ps);
        this.ngramLogFile = ps.getString("queryLogFile");
        this.clearCacheAfterUtterance = ps.getBoolean("clearCachesAfterUtterance");
        this.maxDepth = ps.getInt("maxDepth");
        this.ngramCacheSize = ps.getInt(PROP_TRIGRAM_CACHE_SIZE);
        this.dictionary = (Dictionary)ps.getComponent("dictionary");
        this.applyLanguageWeightAndWip = ps.getBoolean("applyLanguageWeightAndWip");
        this.languageWeight = ps.getFloat("languageWeight");
        this.wip = ps.getDouble("wordInsertionProbability");
        this.unigramWeight = ps.getFloat("unigramWeight");
        this.fullSmear = ps.getBoolean("fullSmear");
    }
}

