/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4String;
import java.io.IOException;
import java.util.LinkedList;

public class SimpleWordListGrammar
extends Grammar
implements Configurable {
    @S4String(defaultValue="spelling.gram")
    public static final String PROP_PATH = "path";
    @S4Boolean(defaultValue=true)
    public static final String PROP_LOOP = "isLooping";
    private String path;
    private boolean isLooping;
    private LogMath logMath;

    public SimpleWordListGrammar(String path, boolean isLooping, boolean showGrammar, boolean optimizeGrammar, boolean addSilenceWords, boolean addFillerWords, Dictionary dictionary) {
        super(showGrammar, optimizeGrammar, addSilenceWords, addFillerWords, dictionary);
        this.path = path;
        this.isLooping = isLooping;
        this.logMath = LogMath.getLogMath();
    }

    public SimpleWordListGrammar() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.path = ps.getString(PROP_PATH);
        this.isLooping = ps.getBoolean(PROP_LOOP);
    }

    @Override
    protected GrammarNode createGrammar(String bogusText) throws NoSuchMethodException {
        throw new NoSuchMethodException("Does not create grammar with reference text");
    }

    @Override
    protected GrammarNode createGrammar() throws IOException {
        ExtendedStreamTokenizer tok = new ExtendedStreamTokenizer(this.path, true);
        GrammarNode initialNode = this.createGrammarNode("<sil>");
        GrammarNode branchNode = this.createGrammarNode(false);
        GrammarNode finalNode = this.createGrammarNode("<sil>");
        finalNode.setFinalNode(true);
        LinkedList<GrammarNode> wordGrammarNodes = new LinkedList<GrammarNode>();
        while (!tok.isEOF()) {
            String word;
            while ((word = tok.getString()) != null) {
                GrammarNode wordNode = this.createGrammarNode(word);
                wordGrammarNodes.add(wordNode);
            }
        }
        initialNode.add(branchNode, 0.0f);
        float branchScore = this.logMath.linearToLog(1.0 / (double)wordGrammarNodes.size());
        for (GrammarNode wordNode : wordGrammarNodes) {
            branchNode.add(wordNode, branchScore);
            wordNode.add(finalNode, 0.0f);
            if (!this.isLooping) continue;
            wordNode.add(branchNode, 0.0f);
        }
        return initialNode;
    }
}

