/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.Node;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.io.IOException;
import java.util.HashMap;

public class LatticeGrammar
extends Grammar {
    public Lattice lattice;

    public LatticeGrammar(Lattice lattice, boolean showGrammar, boolean optimizeGrammar, boolean addSilenceWords, boolean addFillerWords, Dictionary dictionary) {
        super(showGrammar, optimizeGrammar, addSilenceWords, addFillerWords, dictionary);
        this.lattice = lattice;
    }

    public LatticeGrammar() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
    }

    @Override
    protected GrammarNode createGrammar() throws IOException {
        if (this.lattice == null) {
            return this.createGrammarNode("<s>");
        }
        GrammarNode firstNode = null;
        HashMap<Node, GrammarNode> nodeMap = new HashMap<Node, GrammarNode>();
        for (Node n : this.lattice.getNodes()) {
            String word = n.getWord().toString();
            GrammarNode node = this.createGrammarNode(word);
            if (n.equals(this.lattice.getInitialNode())) {
                firstNode = node;
            }
            if (n.equals(this.lattice.getTerminalNode())) {
                node.setFinalNode(true);
            }
            nodeMap.put(n, node);
        }
        if (firstNode == null) {
            throw new Error("No lattice start found");
        }
        for (Edge e : this.lattice.getEdges()) {
            float logProbability = (float)e.getLMScore();
            GrammarNode prevNode = (GrammarNode)nodeMap.get(e.getFromNode());
            GrammarNode toNode = (GrammarNode)nodeMap.get(e.getToNode());
            prevNode.add(toNode, logProbability);
        }
        return firstNode;
    }

    public void setLattice(Lattice lattice) throws IOException {
        this.lattice = lattice;
        this.allocate();
    }
}

