/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.grammar.GrammarArc;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class GrammarNode {
    private final int identity;
    private boolean isFinal;
    private Word[][] alternatives;
    private List<GrammarArc> arcList = new ArrayList<GrammarArc>();

    public GrammarNode(int id, Word[][] alternatives) {
        this(id, false);
        this.alternatives = alternatives;
    }

    protected GrammarNode(int id, boolean isFinal) {
        this.identity = id;
        this.isFinal = isFinal;
        this.alternatives = new Word[0][0];
    }

    public int getID() {
        return this.identity;
    }

    public Word[][] getAlternatives() {
        return this.alternatives;
    }

    void optimize() {
        GrammarArc arc;
        for (int i = 0; i < this.arcList.size(); ++i) {
            arc = this.arcList.get(i);
            this.arcList.set(i, this.optimizeArc(arc));
        }
        if (this.isEmpty()) {
            ListIterator<GrammarArc> i = this.arcList.listIterator();
            while (i.hasNext()) {
                arc = i.next();
                if (this != arc.getGrammarNode()) continue;
                i.remove();
            }
        }
    }

    GrammarArc optimizeArc(GrammarArc arc) {
        GrammarNode nextNode = arc.getGrammarNode();
        while (nextNode.isEmpty() && nextNode.arcList.size() == 1) {
            GrammarArc nextArc = nextNode.arcList.get(0);
            arc = new GrammarArc(nextArc.getGrammarNode(), arc.getProbability() + nextArc.getProbability());
            nextNode = arc.getGrammarNode();
        }
        return arc;
    }

    public Word[] getWords(int alternative) {
        return this.alternatives[alternative];
    }

    public Word getWord() {
        return this.alternatives[0][0];
    }

    public int getNumAlternatives() {
        return this.alternatives.length;
    }

    public boolean isEmpty() {
        return this.getNumAlternatives() == 0;
    }

    public GrammarArc[] getSuccessors() {
        return this.arcList.toArray(new GrammarArc[this.arcList.size()]);
    }

    public boolean isFinalNode() {
        return this.isFinal;
    }

    public void setFinalNode(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public void add(GrammarNode node, float logProbability) {
        if (this.isEmpty() && this == node) {
            return;
        }
        this.arcList.add(new GrammarArc(node, logProbability));
    }

    public String toString() {
        return "G" + this.getID();
    }

    private String traverse(int level, Set<GrammarNode> visitedNodes, float logProb) {
        StringBuilder dump = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            dump.append("    ");
        }
        dump.append("N(").append(this.getID()).append("):");
        dump.append("p:").append(logProb);
        if (this.isFinalNode()) {
            dump.append(" !");
        }
        Word[][] alternatives = this.getAlternatives();
        for (int i = 0; i < alternatives.length; ++i) {
            for (int j = 0; j < alternatives[i].length; ++j) {
                dump.append(' ').append(alternatives[i][j].getSpelling());
            }
            if (i >= alternatives.length - 1) continue;
            dump.append('|');
        }
        System.out.println(dump);
        if (!this.isFinalNode() && !visitedNodes.contains(this)) {
            GrammarArc[] arcs;
            visitedNodes.add(this);
            for (GrammarArc arc : arcs = this.getSuccessors()) {
                GrammarNode child = arc.getGrammarNode();
                child.traverse(level + 1, visitedNodes, arc.getProbability());
            }
        } else if (this.isFinalNode()) {
            visitedNodes.add(this);
        }
        return dump.toString();
    }

    private void traverseGDL(PrintWriter out, Set<GrammarNode> visitedNodes) throws IOException {
        if (!visitedNodes.contains(this)) {
            GrammarArc[] arcs;
            visitedNodes.add(this);
            out.println("   node: { title: " + this.getGDLID(this) + " label: " + this.getGDLLabel(this) + " shape: " + this.getGDLShape(this) + " color: " + this.getGDLColor(this) + '}');
            for (GrammarArc arc : arcs = this.getSuccessors()) {
                GrammarNode child = arc.getGrammarNode();
                float prob = arc.getProbability();
                out.println("   edge: { source: " + this.getGDLID(this) + " target: " + this.getGDLID(child) + " label: \"" + prob + "\"}");
                child.traverseGDL(out, visitedNodes);
            }
        }
    }

    String getGDLID(GrammarNode node) {
        return "\"" + node.getID() + '\"';
    }

    String getGDLLabel(GrammarNode node) {
        String label = node.isEmpty() ? "" : node.getWord().getSpelling();
        return '\"' + label + '\"';
    }

    String getGDLShape(GrammarNode node) {
        return node.isEmpty() ? "circle" : "box";
    }

    String getGDLColor(GrammarNode node) {
        String color = "grey";
        if (node.isFinalNode()) {
            color = "red";
        } else if (!node.isEmpty()) {
            color = "green";
        }
        return color;
    }

    public void dumpGDL(String path) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(path));
            out.println("graph: {");
            out.println("    orientation: left_to_right");
            out.println("    layout_algorithm: dfs");
            this.traverseGDL(out, new HashSet<GrammarNode>());
            out.println("}");
            out.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Can't write to " + path + ' ' + fnfe);
        }
        catch (IOException ioe) {
            System.out.println("Trouble writing to " + path + ' ' + ioe);
        }
    }

    public void dump() {
        System.out.println(this.traverse(0, new HashSet<GrammarNode>(), 1.0f));
    }

    GrammarNode splitNode(int id) {
        GrammarNode branchNode = new GrammarNode(id, false);
        branchNode.arcList = this.arcList;
        this.arcList = new ArrayList<GrammarArc>();
        this.add(branchNode, 0.0f);
        return branchNode;
    }

    public void dumpDot(String path) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(path));
            out.println("digraph \"" + path + "\" {");
            out.println("rankdir = LR\n");
            this.traverseDot(out, new HashSet<GrammarNode>());
            out.println("}");
            out.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Can't write to " + path + ' ' + fnfe);
        }
    }

    private void traverseDot(PrintWriter out, Set<GrammarNode> visitedNodes) {
        if (!visitedNodes.contains(this)) {
            GrammarArc[] arcs;
            visitedNodes.add(this);
            out.println("\tnode" + this.getID() + " [ label=" + this.getGDLLabel(this) + ", color=" + this.getGDLColor(this) + ", shape=" + this.getGDLShape(this) + " ]\n");
            for (GrammarArc arc : arcs = this.getSuccessors()) {
                GrammarNode child = arc.getGrammarNode();
                float prob = arc.getProbability();
                out.write("\tnode" + this.getID() + " -> node" + child.getID() + " [ label=" + prob + " ]\n");
                child.traverseDot(out, visitedNodes);
            }
        }
    }
}

