/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarArc;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.ExtendedStreamTokenizer;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4String;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FSTGrammar
extends Grammar {
    @S4String(defaultValue="default.arpa_gram")
    public static final String PROP_PATH = "path";
    private boolean addInitialSilenceNode;
    private boolean addOptionalSilence;
    private final boolean ignoreUnknownTransitions = true;
    private String path;
    private LogMath logMath;
    private final Map<String, GrammarNode> nodes = new HashMap<String, GrammarNode>();
    private final Set<GrammarNode> expandedNodes = new HashSet<GrammarNode>();

    @Override
    protected GrammarNode createGrammar(String bogusText) throws NoSuchMethodException {
        throw new NoSuchMethodException("Does not create grammar with reference text");
    }

    public FSTGrammar(String path, boolean showGrammar, boolean optimizeGrammar, boolean addSilenceWords, boolean addFillerWords, Dictionary dictionary) {
        super(showGrammar, optimizeGrammar, addSilenceWords, addFillerWords, dictionary);
        this.path = path;
        this.logMath = LogMath.getLogMath();
    }

    public FSTGrammar() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.path = ps.getString(PROP_PATH);
    }

    @Override
    protected GrammarNode createGrammar() throws IOException {
        GrammarNode initialNode = null;
        GrammarNode finalNode = null;
        int maxNodeId = this.createNodes(this.path);
        finalNode = this.createGrammarNode(++maxNodeId, "<sil>");
        finalNode.setFinalNode(true);
        maxNodeId = this.expandWordNodes(maxNodeId);
        ExtendedStreamTokenizer tok = new ExtendedStreamTokenizer(this.path, true);
        while (!tok.isEOF()) {
            GrammarNode nextNode;
            GrammarNode thisNode;
            int thisID;
            tok.skipwhite();
            String token = tok.getString();
            if (token == null) break;
            if (token.equals("I")) {
                assert (initialNode == null);
                int initialID = tok.getInt("initial ID");
                String nodeName = "G" + initialID;
                initialNode = this.createGrammarNode(initialID, "<sil>");
                this.nodes.put(nodeName, initialNode);
                if (!this.addInitialSilenceNode) continue;
                GrammarNode silenceNode = this.createGrammarNode(++maxNodeId, "<sil>");
                initialNode.add(silenceNode, 0.0f);
                silenceNode.add(initialNode, 0.0f);
                continue;
            }
            if (token.equals("T")) {
                thisID = tok.getInt("this id");
                int nextID = tok.getInt("next id");
                thisNode = this.get(thisID);
                nextNode = this.get(nextID);
                if (this.hasEndNode(thisNode)) {
                    thisNode = this.getEndNode(thisNode);
                }
                float lnProb = 0.0f;
                String output = tok.getString();
                if (output == null || output.equals(",")) {
                    if (output != null && output.equals(",")) {
                        tok.getString();
                        lnProb = tok.getFloat("probability");
                    }
                    if (this.hasEndNode(nextNode)) {
                        nextNode = this.getEndNode(nextNode);
                    }
                } else {
                    String word = tok.getString();
                    lnProb = tok.getFloat("probability");
                    if (word.equals("<unknown>")) continue;
                    assert (this.hasWord(nextNode));
                }
                thisNode.add(nextNode, this.convertProbability(lnProb));
                continue;
            }
            if (!token.equals("F")) continue;
            thisID = tok.getInt("this id");
            float lnProb = tok.getFloat("probability");
            thisNode = this.get(thisID);
            nextNode = finalNode;
            if (this.hasEndNode(thisNode)) {
                thisNode = this.getEndNode(thisNode);
            }
            thisNode.add(nextNode, this.convertProbability(lnProb));
        }
        tok.close();
        assert (initialNode != null);
        return initialNode;
    }

    private int createNodes(String path) throws IOException {
        ExtendedStreamTokenizer tok = new ExtendedStreamTokenizer(path, true);
        int maxNodeId = 0;
        while (!tok.isEOF()) {
            String word1;
            tok.skipwhite();
            String token = tok.getString();
            if (token == null) break;
            if (!token.equals("T")) continue;
            tok.getInt("src id");
            int id = tok.getInt("dest id");
            if (id > maxNodeId) {
                maxNodeId = id;
            }
            if ((word1 = tok.getString()) == null) continue;
            String word2 = tok.getString();
            tok.getString();
            String nodeName = "G" + id;
            GrammarNode node = this.nodes.get(nodeName);
            if (node == null) {
                node = word2.equals(",") ? this.createGrammarNode(id, false) : this.createGrammarNode(id, word2);
                this.nodes.put(nodeName, node);
                continue;
            }
            if (!word2.equals(",")) assert (word2.equals(this.getWord(node)));
        }
        tok.close();
        return maxNodeId;
    }

    private int expandWordNodes(int maxNodeID) {
        Collection<GrammarNode> allNodes = this.nodes.values();
        String[][] silence = new String[][]{{"<sil>"}};
        for (GrammarNode node : allNodes) {
            if (node.getNumAlternatives() <= 0) continue;
            GrammarNode endNode = this.createGrammarNode(++maxNodeID, false);
            node.add(endNode, 0.0f);
            if (this.addOptionalSilence) {
                GrammarNode silenceNode = this.createGrammarNode(++maxNodeID, silence);
                node.add(silenceNode, 0.0f);
                silenceNode.add(endNode, 0.0f);
            }
            this.expandedNodes.add(node);
        }
        return maxNodeID;
    }

    private float convertProbability(float lnProb) {
        return this.logMath.lnToLog(-lnProb);
    }

    private GrammarNode get(int id) {
        String name = "G" + id;
        GrammarNode grammarNode = this.nodes.get(name);
        if (grammarNode == null) {
            grammarNode = this.createGrammarNode(id, false);
            this.nodes.put(name, grammarNode);
        }
        return grammarNode;
    }

    private boolean hasWord(GrammarNode node) {
        return node.getNumAlternatives() > 0;
    }

    private String getWord(GrammarNode node) {
        String word = null;
        if (node.getNumAlternatives() > 0) {
            Word[][] alternatives = node.getAlternatives();
            word = alternatives[0][0].getSpelling();
        }
        return word;
    }

    private boolean hasEndNode(GrammarNode node) {
        return this.expandedNodes.contains(node);
    }

    private GrammarNode getEndNode(GrammarNode node) {
        GrammarArc[] arcs = node.getSuccessors();
        assert (arcs != null && arcs.length > 0);
        return arcs[0].getGrammarNode();
    }
}

