/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.language.grammar.ForcedAlignerGrammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarInterface;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4String;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;

public class BatchForcedAlignerGrammar
extends ForcedAlignerGrammar
implements GrammarInterface {
    @S4String(defaultValue="<refFile not set>")
    public static final String PROP_REF_FILE = "refFile";
    protected String refFile;
    protected final Map<String, GrammarNode> grammars = new HashMap<String, GrammarNode>();
    protected String currentUttName = "";

    public BatchForcedAlignerGrammar(String refFile, boolean showGrammar, boolean optimizeGrammar, boolean addSilenceWords, boolean addFillerWords, Dictionary dictionary) {
        super(showGrammar, optimizeGrammar, addSilenceWords, addFillerWords, dictionary);
        this.refFile = refFile;
    }

    public BatchForcedAlignerGrammar() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        super.newProperties(ps);
        this.refFile = ps.getString(PROP_REF_FILE);
    }

    @Override
    protected GrammarNode createGrammar() {
        this.initialNode = null;
        this.finalNode = this.createGrammarNode(true);
        try {
            String line;
            LineNumberReader in = new LineNumberReader(new FileReader(this.refFile));
            while ((line = in.readLine()) != null && !line.isEmpty()) {
                int uttNameStart = line.indexOf(40) + 1;
                int uttNameEnd = line.indexOf(41);
                if (uttNameStart < 0 || uttNameStart > uttNameEnd) continue;
                String uttName = line.substring(uttNameStart, uttNameEnd);
                String transcript = line.substring(0, uttNameStart - 1).trim();
                if (transcript.isEmpty()) continue;
                this.initialNode = this.createGrammarNode("<sil>");
                this.createForcedAlignerGrammar(this.initialNode, this.finalNode, transcript);
                this.grammars.put(uttName, this.initialNode);
                this.currentUttName = uttName;
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return this.initialNode;
    }

    @Override
    public GrammarNode getInitialNode() {
        return this.initialNode;
    }

    public void setUtterance(String utteranceName) {
        this.initialNode = this.grammars.get(utteranceName);
        assert (this.initialNode != null);
    }
}

