/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.grammar;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.grammar.GrammarNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AlignerGrammar
extends Grammar {
    protected GrammarNode finalNode;
    private final List<String> tokens = new ArrayList<String>();

    public AlignerGrammar(boolean showGrammar, boolean optimizeGrammar, boolean addSilenceWords, boolean addFillerWords, Dictionary dictionary) {
        super(showGrammar, optimizeGrammar, addSilenceWords, addFillerWords, dictionary);
    }

    public AlignerGrammar() {
    }

    public void setText(String text) {
        this.setWords(Arrays.asList(text.split(" ")));
    }

    public void setWords(Iterable<String> words) {
        this.tokens.clear();
        for (String word : words) {
            if (word.isEmpty()) continue;
            this.tokens.add(word);
        }
        this.createGrammar();
        this.postProcessGrammar();
    }

    @Override
    protected GrammarNode createGrammar() {
        this.logger.info("Making Grammar");
        this.initialNode = this.createGrammarNode("<sil>");
        this.finalNode = this.createGrammarNode(true);
        GrammarNode prevNode = this.initialNode;
        for (String word : this.tokens) {
            GrammarNode wordNode = this.createGrammarNode(word);
            GrammarNode alternativeNode = this.createGrammarNode(false);
            GrammarNode exitNode = this.createGrammarNode(false);
            prevNode.add(wordNode, 0.0f);
            prevNode.add(alternativeNode, 0.0f);
            wordNode.add(exitNode, 0.0f);
            alternativeNode.add(exitNode, 0.0f);
            prevNode = exitNode;
        }
        prevNode.add(this.finalNode, 0.0f);
        this.logger.info("Done making Grammar");
        return this.initialNode;
    }
}

